#!/usr/bin/perl -w

my $srcr = "srcr2";

my $ip = `read_handler $srcr/es.ip`;
chomp($ip);

print <<EOF;
Content-type: text/html

<html>
<head>
<title>Status for node $ip</title>
<link rel='stylesheet' media='screen' type='text/css' href='/style.css' />
<link rel='stylesheet' media='print' type='text/css' href='/print.css' />
</head>
<body>
<div class='stylehead'>
<div class='header'>
<div class='pagename'>
[[$ip]]
</div>
<div class='logo'>
<a href='http://roofnet.net/' name='top' accesskey='h' title='[ALT+H]' onclick='return svchk()' onkeypress='return svchk()'>Roofnet</a>
</div>
</div>

EOF

my $r = `/usr/bin/read_handler $srcr/lt.routes`;
my $routes = "";
foreach my $line (split /\n/, $r) {
    $line =~ s/hops //g;
    $line =~ s/metric //g;
    my @ar = split /\s+/, $line;
    $routes .= "<tr>";
    $routes .= "<td>" . shift(@ar) . "</td>";
    $routes .= "<td>" . shift(@ar) . "</td>";
    $routes .= "<td>" . shift(@ar) . "</td>";
    while (scalar(@ar)) {
	$routes .= "<td>" . shift(@ar) . " " . shift(@ar) . " " . shift(@ar) . "</td>";
    }
    $routes .= "</tr>\n";
}

my $gw = `/usr/bin/read_handler $srcr/gw.stats`;
my $gateways = "";
foreach my $line (split /\n/, $gw) {
    $line =~ s/seen (\d+) //g;
    $line =~ s/first_update (\d+)\.(\d+) //g;
    $line =~ s/last_update //g;
    $line =~ s/current_metric //g;
    my @ar = split /\s+/, $line;
    $gateays .= "<tr>";
    while (scalar(@ar)) {
	$gateways .= "<td>" . shift(@ar) . "</td>";
    }
    $gateays .= "</tr>\n";
}
my $is_gw = `read_handler $srcr/gw.is_gateway`;
chomp($is_gw);
my $vlan0_if = `/sbin/ifconfig vlan0`;
my $eth0_if = `/sbin/ifconfig eth0`;
my $ath1_if = `/sbin/ifconfig ath1`;
my $wan_ip = "";

if ($vlan0_if =~ /addr:(\d+)\.(\d+)\.(\d+)\.(\d+)/) {
    $wan_ip = "$1.$2.$3.$4";
} elsif ($eth0_if =~ /addr:(\d+)\.(\d+)\.(\d+)\.(\d+)/) {
    # minis don't have vlan0
    $wan_ip = "$1.$2.$3.$4";
}
my $ath1_ip;
if ($ath1_if =~ /addr:(\d+)\.(\d+)\.(\d+)\.(\d+)/) {
    $ath1_ip = "$1.$2.$3.$4";
}

my $serial_number = `/usr/bin/serial_number.sh`;
# only show last three digits of the serial number
$serial_number =~ s/(\S+)-(\S+)-(\S+)/xxx-xxx-$3/g;
$serial_number =~ s/r00fnet/XXXXnet/g;

my $ath0_iw = `/usr/sbin/iwconfig ath0`;
my $ath0_bssid = "";
my $ath1_iw = `/usr/sbin/iwconfig ath1`;
my $ath1_bssid = "";
if ($ath0_iw =~ /Point: (\S+)/) {
    $ath0_bssid = lc($1);
}
if ($ath1_iw =~ /Point: (\S+)/) {
    $ath1_bssid = lc($1);
}

my $channel_desc = "";
if ($ath0_iw =~ /Frequency:(\d+)\.(\d+)/) {
    if ($2%5 == 2) {
	$channel_desc .= ($2 - 407) / 5;
    }
    $channel_desc .= " ($1.$2 GHz)";
}

my $ssid = "";
if ($ath0_iw =~ /ESSID:"(\S+)"/) {
    $ssid = $1;
}

my $ath1_ssid = "";
if ($ath1_iw =~ /ESSID:"(\S+)"/) {
    $ath1_ssid = $1;
}

my $build = `cat /MERAKI_BUILD`;
chomp($build);


print <<EOF;
<h2>Welcome to your <a href='http://roofnet.net/'>Roofnet</a> mini!</h2>
<div class='level2'>
Roofnet minis operate like a normal access point, but they also form a mesh
network with other Roofnet minis in the area that do not otherwise have a
network connection to extend the coverage area of the wireless network.
</div>

<h2>Current Status</h2>
<div class='level2'>
This Roofnet mini is advertising the ssid "$ssid".
You can <a href='configure/'>change the ssid</a>.

EOF


if ($wan_ip ne "") {
    
    print <<EOF;
    <br>
    This node received IP address $wan_ip on its ethernet port and is sharing that connection.
EOF
} elsif ($ath1_ip ne "") {
    print <<EOF;
    This node received IP address $ath1_ip using the ssid of \"$ath1_ssid\" to its wireless uplink.
EOF
} else {
    print <<EOF;
    This node did not detect an ethernet connection and is not using it.
EOF
}

print <<EOF;
</div>
<br>
<div class='level2'>
<table BORDER=0 cellspacing=5 class=inline>
<tr><td>roofnet IP:</td><td>$ip</td></tr>
<tr><td>software build:</td><td>$build</td></tr>
<tr><td>gateway:</td><td>$is_gw</td></tr>
EOF
if ($wan_ip ne "") {
print <<EOF;
<tr><td>wired uplink IP:</td><td>$wan_ip</td></tr>
EOF
} elsif ($ath1_ip ne "") {
print <<EOF;
<tr><td>wireless uplink IP:</td><td>$ath1_ip</td></tr>
<tr><td>wireless uplink SSID:</td><td>$ath1_ssid</td></tr>
<tr><td>wireless uplink AP:</td><td>$ath1_bssid</td></tr>
EOF
}

print<<EOF;
<tr><td>mac adddress (BSSID):</td><td>$ath0_bssid</td></tr>
<tr><td>serial number/password:</td><td>$serial_number</td></tr>
<tr><td>channel:</td><td>$channel_desc</td></tr>
<tr><td>local SSID:</td><td>$ssid</td></tr>
</table>
</div>
<br><br>
EOF


    if (!$is_gw) {
print <<EOF
<br>
The table below shows other roofnet minis that are acting as gateways and sharing their internet
connection with this node. The table includes a "metric" to the gateways, which is inversely proportional
to how much throughput this node can get to them. It also shows how long ago this node received a "hello"
message from that gateway. The gateways send "hello" messages every 30 seconds.
<h2>Gateways</h2>
<div class='level2'>
<table BORDER=0 cellspacing=5 class=inline>
<tr><th>Gateway</th><th>Metric</th><th>Last Update (secs)</th></tr>
$gateways
</table>
</div>
<br><br>
EOF
}

print <<EOF;

<h2>Other Roofnet minis</h2> 
<div class='level2'> 
The table below shows other roofnet minis this node can communicate with.
</div>
<br>
<div class='level2'>
<table BORDER=0 cellspacing=5 class=inline>
<tr><th>Node</th><th>Hops Away</th><th>Metric</th><th>Route (metrics in parentheses)</th></tr>
$routes
</table>
</div>
<br><br>


</div>
</body></html>
EOF


