#!/usr/bin/ruby

while 1
  sleep 150  # wait a bit for node to stabilize after boot

  # Get Wireless IP
  ip = `read_handler srcr2/es.ip`.chomp rescue ""

  # Get MAC, SSID, Channel
  ath0_config = `iwconfig ath0` rescue ""
  mac = ath0_config[/Access Point: (\S+)/, 1] rescue ""
  ssid = ath0_config[/ESSID:(\S+)/,1].gsub(/"/,'') rescue ""
  channel = ath0_config[/Frequency:(\S+)/,1] rescue ""
  ssid << "+/+" << channel

  # Get clients / Bytes
  clients = IO.read("/click/local_wireless_clients_counter_incoming/table_size").chomp.to_i rescue 0
  bytes = IO.read("/click/local_wireless_clients_counter_incoming/bytes").chomp.to_i / 1024 rescue 0

  # Get Best Gateway and its metric
  best_gw = ""
  best_gw_metric = 0
  gw_stats = `read_handler srcr2/gw.stats` rescue ""
  gw_stats.each_line { |line|
    gw_ip, junk, junk, junk, junk, junk, junk, junk, gwm = line.split(' ')
    gw_metric = gwm.to_i
    if gw_metric > 0 and (best_gw_metric == 0 or gw_metric < best_gw_metric)
      best_gw_metric = gw_metric
      best_gw = gw_ip
    end
  }

  # Is this node a gateway?
  is_gw = `read_handler srcr2/gw.is_gateway`.chomp rescue "false"

  # Get Build Number
  build = `cat /MERAKI_BUILD`.chomp

  # Get Platform
  plat = `cat /MERAKI_ARCH`.chomp

  # Get Node Serial Number
  #serial = `cat /MERAKI_SERIAL`.chomp rescue ""

  # Get all Neighbors
  neighbors = `read_handler srcr2/lt.neighbors` rescue ""

  # For each neighbor, get its metric and signal
  neighborList=""
  gw_route = ""
  routes = `read_handler srcr2/lt.routes` rescue ""
  routes.each_line { |route|
    dest, junk, hops, junk, junk, junk, mtrc, nbor = route.split(' ')
    metric = mtrc.gsub(/([()])/, '')
    # save gateway metric / route
    if dest == best_gw
      gw_route = route.chomp.gsub(/ /,'+')
    end
    if hops == '1'
      # get signal from bcast_stats
      bcast_stats = `read_handler srcr2/es.bcast_stats` rescue ""
      bcast_stats.each_line { |bstats|
        ip2, junk, junk, rate, junk, junk, junk, signal = bstats.split(' ')
        if ip2 == nbor and rate == "11"
          neighborList << metric << "-" << signal << "+" << nbor << ";"
        end
      }
    end
  }

  # write request to temp file
  f = File.new("/tmp/reporter.out", "w")
  f.write("GET /checkin.php?ip=#{ip}&mac=#{mac}&gateway=#{is_gw}&bestgw=#{best_gw}&bestgwm=#{best_gw_metric}&gwr=#{gw_route}&build=#{build}&platform=#{plat}&routes=#{neighborList}&ssid=#{ssid}&clients=#{clients}&bytes=#{bytes} HTTP/1.1\nHost: roofnet.net\n\n")
  f.close

  # send request to roofnet.net
  reply = `cat /tmp/reporter.out | nc -w5 www.roofnet.net 80`

  sleep 150
end
