GENIMAGE := $(BUILD_DIR)/genimage

all: $(BUILD_DIR)/stage2-embedded.elf $(BUILD_DIR)/crc

ifeq ($(BOARD), ar531x)
all: $(BUILD_DIR)/stage2-flash.elf
endif

$(GENIMAGE): brcm/genimage.c
	gcc -o $@ -lz $<

SWITCH_MODULES := switch-adm.ko switch-core.ko switch-robo.ko
SWITCH_MODULES_BUILD := $(addprefix $(BUILD_DIR)/switch/, $(SWITCH_MODULES))
SWITCH_MODULES_ROOT := $(addprefix $(ROOT_DIR)/lib/modules/, $(SWITCH_MODULES))

$(SWITCH_MODULES_BUILD): FORCE
	rsync -a brcm/switch/ $(BUILD_DIR)/switch/
	$(MAKE) -C "$(LINUX_BUILD_DIR)" \
		CROSS_COMPILE="$(TARGET_CROSS)" \
		ARCH="$(LINUX_KARCH)" \
		PATH="$(TARGET_PATH)" \
		SUBDIRS=$(shell pwd)/$(BUILD_DIR)/switch \
		EXTRA_CFLAGS="-DBCMGPIO2" \
		modules

$(SWITCH_MODULES_ROOT): $(SWITCH_MODULES_BUILD)
	cp $^ $(ROOT_DIR)/lib/modules

$(BUILD_DIR)/vmlinux.lzma: $(LINUX_BUILD_DIR)/vmlinux-meraki.bin
	cat $^ | $(LZMA) e -si -so -eos -lc1 -lp2 -pb2 > $@ || (rm -f $@ && false)

$(BUILD_DIR)/stage2-flash.bin.lzma: $(BUILD_DIR)/stage2-flash.bin
	$(LZMA) e -eos -lc1 -lp2 -pb2 $< $@

# it is very unclear why loader.tmp.gz goes in here.. but something
# has to be there because of the way that openwrt's decompress.c looks
# for an image
$(BUILD_DIR)/stage2.trx: brcm/loader.tmp.gz $(BUILD_DIR)/stage2-flash.bin.lzma
	$(STAGING_DIR)/bin/trx -o $@ $^

$(BUILD_DIR)/piece1: $(BUILD_DIR)/stage2.trx $(LINUX_BUILD_DIR)/vmlinux-meraki.bin.lzma
	[ `wc -c < $(BUILD_DIR)/stage2.trx` -le $$((0x10000)) ]
	dd if=$(BUILD_DIR)/stage2.trx of=$@ bs=$$((0x10000)) conv=sync count=1
	dd if=$(LINUX_BUILD_DIR)/vmlinux-meraki.bin.lzma bs=1M conv=sync count=1 >> $@

$(BUILD_DIR)/piece2: $(LINUX_BUILD_DIR)/vmlinux-meraki.bin.lzma
	[ `wc -c < $<` -le $$((0x400000)) ]
	dd if=$< bs=1M skip=1 > $@

all: $(BUILD_DIR)/upgrade-from-2.0.x.trx
$(BUILD_DIR)/upgrade-from-2.0.x.trx: $(BUILD_DIR)/piece1 $(BUILD_DIR)/piece2
	cp $(BUILD_DIR)/piece1 $@
	[ `wc -c < $@` -eq $$((0x110000)) ]
	dd if=/dev/zero bs=$$((0x10000)) count=1 >> $@ # for the ascii crap
	[ `wc -c < $@` -eq $$((0x120000)) ]
	cat $(BUILD_DIR)/piece2 >> $@

$(BUILD_DIR)/1419-kernpart: $(BUILD_DIR)/stage2-flash.elf $(BUILD_DIR)/piece1
	dd if=$(BUILD_DIR)/stage2-flash.elf bs=$$((0x20000)) count=1 conv=sync > $@
	cat $(BUILD_DIR)/piece1 >> $@

all: $(BUILD_DIR)/upgrade-from-1419.img
$(BUILD_DIR)/upgrade-from-1419.img: $(BUILD_DIR)/1419-kernpart $(BUILD_DIR)/piece2 $(GENIMAGE)
	$(GENIMAGE) $(BUILD_DIR)/1419-kernpart $(BUILD_DIR)/piece2 $@

rootfs: $(SWITCH_MODULES_ROOT)

dist: $(BUILD_DIR)/upgrade-from-2.0.x.trx $(BUILD_DIR)/upgrade-from-1419.img $(BUILD_DIR)/stage2-embedded.elf
	mkdir dist-ng-`cat $(ROOT_DIR)/MERAKI_BUILD` && cp $^ dist-ng-`cat $(ROOT_DIR)/MERAKI_BUILD`
