/* Copyright (C) 1990, 1991 Aladdin Enterprises.  All rights reserved.
   Distributed by Free Software Foundation, Inc.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* ver 1.1  21-Aug-1993 by kura@nacsis.ac.jp (kura@mmp.cl.nec.co.jp) */

/* gdevextp.c */
#include "gdevprn.h"
#include "gdevxprn.h"

#ifdef PC9801
#include <dos.h>
#endif

/* If you want to compile with ghostscript-2.4.1, #define gs241 */

dev_proc_open_device(gdev_ext_prn_open);
dev_proc_open_device(gdev_ext_resizable_prn_open);
dev_proc_output_page(gdev_ext_prn_output_page);

gx_device_procs prn_ext_resizable_procs =
  prn_procs(gdev_ext_resizable_prn_open,
	    gdev_ext_prn_output_page,
	    gdev_prn_close);
gx_device_procs prn_ext_procs =
  prn_procs(gdev_ext_prn_open,
	    gdev_ext_prn_output_page,
	    gdev_prn_close);
#define ppdev ((gx_device_printer *)pdev)

typedef enum { o_fput, o_bios } out_type;
private FILE *gdev_ext_output_file = NULL;
private out_type gdev_ext_out_type = o_fput;

int
#ifdef gs241
gdev_ext_prn_open_printer(gx_device *pdev)
#else
gdev_ext_prn_open_printer(gx_device *pdev, int binary_mode)
#endif
{
#ifdef PC9801
	if (strcmp(ppdev->fname, "-") && strcmp(ppdev->fname, "PRN"))
#else
	if (strcmp(ppdev->fname, "-"))
#endif
#ifdef gs241
		return gdev_prn_open_printer(pdev);
#else
		return gdev_prn_open_printer(pdev, binary_mode);
#endif

	/* if output-file is stdout, leave it open */
	return 0;
}

int
gdev_ext_prn_close_printer(gx_device *pdev)
{
	if (strcmp(ppdev->fname, "-") == 0) {
		/* if output-file is stdout, leave it open, but flush it */
		if (gdev_ext_output_file != NULL)
			fflush(gdev_ext_output_file);
	}
#ifdef PC9801
	else if (strcmp(ppdev->fname, "PRN") == 0)
		;	/* nothing */
#endif
	else
		return gdev_prn_close_printer(pdev);

	return 0;
}

/****** Note that num_copies is currently ignored: this is wrong. ******/
int
gdev_ext_prn_open(gx_device *pdev)
{
	int	code;

	if ((code = gdev_prn_open(pdev)) < 0)
		return code;

	if (gdev_ext_out_type != o_fput || gdev_ext_output_file != NULL)
		return 0;

	if (strcmp(ppdev->fname, "-")) {
#ifdef PC9801
		if (strlen(ppdev->fname) == 0)
			strcpy(ppdev->fname, "PRN");
		if (!strcmp(ppdev->fname, "PRN")) {
			gdev_ext_out_type = o_bios;
		}
#endif
		return 0;
	}

	/* if output-file is stdout, set error or print messages to stderr
	   and output to stdout. */
	if ((gdev_ext_output_file = fdopen(dup(1), "w")) == NULL) {
		perror("gdevextp.c: fdopen()");
		return -1;
	}
	dup2(2, 1);

	return 0;
}

int
gdev_ext_resizable_prn_open(gx_device *pdev)
{
	extern char	*gdev_ext_default_paper_size();
	extern int	gdev_ext_paper_width;
	extern int	gdev_ext_paper_height;
	char	*size = gdev_ext_default_paper_size();

	if (size != NULL) {
		pdev->width = (int)((long)gdev_ext_paper_width *
			pdev->x_pixels_per_inch / 10);
		pdev->height = (int)((long)gdev_ext_paper_height *
			pdev->y_pixels_per_inch / 10);
	}

	return gdev_ext_prn_open(pdev);
}

int
gdev_ext_prn_output_page(gx_device *pdev, int num_copies, int flush)
{	int code, outcode, closecode;

	ppdev->page_count++;
#ifdef gs241
	code = gdev_ext_prn_open_printer(pdev);
#else
	code = gdev_ext_prn_open_printer(pdev, 1);
#endif
	if ( code < 0 ) return code;

	/* print the accumulated page description */
	outcode = (*ppdev->print_page)(ppdev, ppdev->file);

	closecode = gdev_ext_prn_close_printer(pdev);

	if ( ppdev->buffer_space ) /* reinitialize clist for writing */
#ifdef gs241
	  code = (*gs_clist_device.procs->output_page)(pdev, num_copies, flush);
#else
	  code = (*gs_clist_device_procs.output_page)(pdev, num_copies, flush);
#endif

	if ( outcode < 0 ) return outcode;
	if ( closecode < 0 ) return closecode;
	return code;
}

void
gdev_ext_prn_putc(int c, FILE *fp)
{
	switch (gdev_ext_out_type) {
	case o_fput:
		if (fp != NULL)
			putc(c, fp);
		else if (gdev_ext_output_file != NULL)
			putc(c, gdev_ext_output_file);
		break;
	case o_bios:
#ifdef PC9801
		{
			int status;
			do {
				status = inportb(0x42);
			} while ((status & (1 << 2)) == 0);	/* BUSY */
			outportb(0x40, c);
			outportb(0x46, 0x0e);	/* PSTROBE off */
			outportb(0x46, 0x0f);	/* PSTROBE on */
		}
#endif
		break;
	}
}

void
gdev_ext_prn_puts(char *s, FILE *fp)
{
	while (*s)
		gdev_ext_prn_putc(*s++, fp);
}
