/*
 * KAKASI (Kanji Kana Simple inversion program)
 * $Header: H2.c,v 2.2 92/08/02 takahasi Exp $
 * Copyright (C) 1992
 * Hironobu Takahashi (takahasi@tiny.or.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either versions 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with KAKASI, see the file COPYING.  If not, write to the Free
 * Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* $Log:	H2.c,v $
 * Revision 2.0  92/07/18  12:06:58  takahasi
 * *** empty log message ***
 * 
*/
#include <stdio.h>
#include "kakasi.h"

struct H2rom_tbl {
    unsigned char kana[10];
    char romaji[7];
}
H2rom_h_table[] = { 

    "", "a", "", "a", "", "i", "", "i", "", "u", "", "u",
    "", "vu", "", "va", "", "vi", "", "ve",
    "", "vo",
    "", "e", "", "e", "", "o", "", "o",

    "", "ka", "", "ga", "", "ki", "", "kya", "", "kyu",
    "", "kyo", "", "gi", "", "gya", "", "gyu", "", "gyo",
    "", "ku", "", "gu", "", "ke", "", "ge", "", "ko", "", "go",

    "", "sa", "", "za", "", "shi", "", "sha", "", "shu",
    "", "sho", "", "ji", "", "ja", "", "ju", "", "jo",
    "", "su", "", "zu", "", "se", "", "ze", "", "so", "", "zo",

    "", "ta", "", "da", "", "chi", "", "cha", "", "chu",
    "", "cho", "", "di", "¤", "dya", "¤", "dyu", "¤", "dyo",

    "", "tsu", 
    "ä", "vvu", "ä", "vva", "ä", "vvi",
    "ä", "vve", "ä", "vvo",
    "ä", "kka", "ä", "gga", "ä", "kki", "ä", "kkya",
    "ä", "kkyu", "ä", "kkyo", "ä", "ggi", "ä", "ggya",
    "ä", "ggyu", "ä", "ggyo", "ä", "kku", "ä", "ggu",
    "ä", "kke", "ä", "gge", "ä", "kko", "ä", "ggo", "ä", "ssa",
    "ä", "zza", "ä", "sshi", "ä", "ssha",
    "ä", "sshu", "ä", "ssho",
    "ä", "jji", "ä", "jja", "ä", "jju", "ä", "jjo",
    "ä", "ssu", "ä", "zzu", "ä", "sse", "ä", "zze", "ä", "sso",
    "ä", "zzo", "ä", "tta", "ä", "dda", "ä", "cchi",
    "ä", "ccha", "ä", "cchu", "ä", "ccho", "ä", "ddi",
    "ä¤", "ddya", "ä¤", "ddyu", "ä¤", "ddyo", "ä", "ttsu",
    "ä", "ddu", "ä", "tte", "ä", "dde", "ä", "tto", "ä", "ddo",
    "ä", "hha", "ä", "bba", "ä", "ppa", "ä", "hhi",
    "äҤ", "hhya", "äҤ", "hhyu", "äҤ", "hhyo", "ä", "bbi",
    "äӤ", "bbya", "äӤ", "bbyu", "äӤ", "bbyo", "ä", "ppi",
    "äԤ", "ppya", "äԤ", "ppyu", "äԤ", "ppyo", "ä", "ffu",
    "äդ", "ffa", "äդ", "ffi", "äդ", "ffe", "äդ", "ffo",
    "ä", "bbu", "ä", "ppu", "ä", "hhe", "ä", "bbe", "ä", "ppe",
    "ä", "hho", "ä", "bbo", "ä", "ppo", "ä", "yya", "ä", "yyu",
    "ä", "yyo", "ä", "rra", "ä", "rri", "ä", "rrya",
    "ä", "rryu", "ä", "rryo", "ä", "rru", "ä", "rre",
    "ä", "rro",

    "", "tsu", "", "du", "", "te", "", "de", "", "to", "", "do",

    "", "na", "", "ni", "ˤ", "nya", "ˤ", "nyu", "ˤ", "nyo",
    "", "nu", "", "ne", "", "no",

    "", "ha", "", "ba", "", "pa", "", "hi", "Ҥ", "hya",
    "Ҥ", "hyu", "Ҥ", "hyo", "", "bi", "Ӥ", "bya", "Ӥ", "byu",
    "Ӥ", "byo", "", "pi", "Ԥ", "pya", "Ԥ", "pyu", "Ԥ", "pyo",
    "", "fu", "դ", "fa", "դ", "fi", "դ", "fe", "դ", "fo",
    "", "bu", "", "pu", "", "he", "", "be", "", "pe", "", "ho",
    "", "bo", "", "po",

    "", "ma", "", "mi", "ߤ", "mya", "ߤ", "myu", "ߤ", "myo",
    "", "mu", "", "me", "", "mo",

    "", "ya", "", "ya", "", "yu", "", "yu", "", "yo", "", "yo",

    "", "ra", "", "ri", "", "rya", "", "ryu", "", "ryo",
    "", "ru", "", "re", "", "ro",

    "", "wa", "", "wa", "", "i", "", "e", 
    "", "wo", "", "n",
    "", "n'a", "", "n'i", "", "n'u", "", "n'e", "", "n'o",
    "", ""

}, H2rom_k_table[] = { 

    "", "a", "", "a", "", "i", "", "i", "", "u", "", "u",
    "", "vu", "", "va", "", "vi",
    "", "ve", "", "vo",
    "", "e", "", "e", "", "o", "", "o",

    "", "ka", "", "ga", "", "ki", "", "kya", "", "kyu",
    "", "kyo", "", "gi", "", "gya", "", "gyu", "", "gyo",
    "", "ku", "", "gu", "", "ke", "", "ge", "", "ko", "", "go",

    "", "sa", "", "za", "", "si", "", "sya", "", "syu",
    "", "syo", "", "zi", "", "zya", "", "zyu", "", "zyo",
    "", "su", "", "zu", "", "se", "", "ze", "", "so", "", "zo",

    "", "ta", "", "da", "", "ti", "", "tya", "", "tyu",
    "", "tyo", "", "di", "¤", "dya", "¤", "dyu", "¤", "dyo",

    "", "tu",
    "ä", "vvu", "ä", "vva", "ä", "vvi",
    "ä", "vve", "ä", "vvo",
    "ä", "kka", "ä", "gga", "ä", "kki", "ä", "kkya",
    "ä", "kkyu", "ä", "kkyo", "ä", "ggi", "ä", "ggya",
    "ä", "ggyu", "ä", "ggyo", "ä", "kku", "ä", "ggu",
    "ä", "kke", "ä", "gge", "ä", "kko", "ä", "ggo", "ä", "ssa",
    "ä", "zza", "ä", "ssi", "ä", "ssya",
    "ä", "ssyu", "ä", "ssho",
    "ä", "zzi", "ä", "zzya", "ä", "zzyu", "ä", "zzyo",
    "ä", "ssu", "ä", "zzu", "ä", "sse", "ä", "zze", "ä", "sso",
    "ä", "zzo", "ä", "tta", "ä", "dda", "ä", "tti",
    "ä", "ttya", "ä", "ttyu", "ä", "ttyo", "ä", "ddi",
    "ä¤", "ddya", "ä¤", "ddyu", "ä¤", "ddyo", "ä", "ttu",
    "ä", "ddu", "ä", "tte", "ä", "dde", "ä", "tto", "ä", "ddo",
    "ä", "hha", "ä", "bba", "ä", "bba", "ä", "hhi",
    "äҤ", "hhya", "äҤ", "hhyu", "äҤ", "hhyo", "ä", "bbi",
    "äӤ", "bbya", "äӤ", "bbyu", "äӤ", "bbyo", "ä", "bbi",
    "äԤ", "bbya", "äԤ", "bbyu", "äԤ", "bbyo", "ä", "hhu",
    "äդ", "ffa", "äդ", "ffi", "äդ", "ffe", "äդ", "ffo",
    "ä", "bbu", "ä", "ppu", "ä", "hhe", "ä", "bbe", "ä", "bbe",
    "ä", "hho", "ä", "bbo", "ä", "bbo", "ä", "yya", "ä", "yyu",
    "ä", "yyo", "ä", "rra", "ä", "rri", "ä", "rrya",
    "ä", "rryu", "ä", "rryo", "ä", "rru", "ä", "rre",
    "ä", "rro",

    "", "tu", "", "du", "", "te", "", "de", "", "to", "", "do",

    "", "na", "", "ni", "ˤ", "nya", "ˤ", "nyu", "ˤ", "nyo",
    "", "nu", "", "ne", "", "no",

    "", "ha", "", "ba", "", "pa", "", "hi", "Ҥ", "hya",
    "Ҥ", "hyu", "Ҥ", "hyo", "", "bi", "Ӥ", "bya", "Ӥ", "byu",
    "Ӥ", "byo", "", "pi", "Ԥ", "pya", "Ԥ", "pyu", "Ԥ", "pyo",
    "", "hu", "դ", "fa", "դ", "fi", "դ", "fe", "դ", "fo",
    "", "bu", "", "pu", "", "he", "", "be", "", "pe", "", "ho",
    "", "bo", "", "po",

    "", "ma", "", "mi", "ߤ", "mya", "ߤ", "myu", "ߤ", "myo",
    "", "mu", "", "me", "", "mo",

    "", "ya", "", "ya", "", "yu", "", "yu", "", "yo", "", "yo",

    "", "ra", "", "ri", "", "rya", "", "ryu", "", "ryo",
    "", "ru", "", "re", "", "ro",

    "", "wa", "", "wa", "", "i", "", "e", 
    "", "wo", "", "n",
    "", "n'a", "", "n'i", "", "n'u", "", "n'e", "", "n'o",
    "", ""
};

#define H2rom_buflen 11

int H2rom(c, n, type)
Character c[], n[];
int type;
{
    static int index_table[0x81];
    static int index_made=0;
    static struct H2rom_tbl *H2rom_ptr;
    struct H2rom_tbl *p;
    int i, clen, ylen;
    unsigned char buffer[H2rom_buflen];
    int max_match, match_more;
    char *max_romaji;

    if (index_made == 0) {
	int last;

	for (i = 0; i < 0x81; ++ i) {
	    index_table[i] = -1;
	}
	index_table[0x21] = 0;
	H2rom_ptr = (romaji_type == HEPBURN) ? H2rom_h_table : H2rom_k_table;
	for (p = H2rom_ptr, i = 0; *(p->kana) != '\0'; ++ p, ++ i) {
	    index_table[(((p->kana)[1])&0x7f)+1] = i+1;
	}
	last = i;
	for (i = 0x80; i >= 0; -- i) {
	    if (index_table[i] == -1)
		index_table[i] = last;
	    else
		last = index_table[i];
	}
	index_made = 1;
    }

    buffer[H2rom_buflen-1] = '\0'; clen = H2rom_buflen-1;
    for (i = 0; i < (H2rom_buflen-1)/2; i ++) {
	buffer[i*2  ] = c[i].c1;
	buffer[i*2+1] = c[i].c2;

	if (c[i].c1 == '\0') {
	    clen = i*2;
	    break;
	}
    }

    if (clen == 0) {
	n[0].type=OTHER;
	n[0].c1 = '\0';
	return 0;
    }

    max_match = 0;
    max_romaji = NULL;
    match_more = 0;
    for (i = index_table[buffer[1]&0x7f];
	 i < index_table[(buffer[1]&0x7f)+1];
	 ++ i) {
	ylen = strlen(H2rom_ptr[i].kana);
	if (clen >= ylen) {
	    if (max_match < ylen) {
		if (strncmp(buffer, H2rom_ptr[i].kana, ylen) == 0) {
		    max_match = ylen/2;
		    max_romaji = H2rom_ptr[i].romaji;
		}
	    }
	} else {
	    if (match_more == 0)
		if (strncmp(buffer, H2rom_ptr[i].kana, clen) == 0)
		    match_more = 1;
	}
    }

    if (max_romaji == NULL) {
	i = 0;
	max_match = 1;
    } else {
	for (i = 0; max_romaji[i] != '\0'; ++ i) {
	    n[i].type=type;
	    n[i].c1 = max_romaji[i];
	}
    }
    n[i].type=OTHER;
    n[i].c1 = '\0';

    return (match_more == 0) ? max_match : -max_match;
}

int H2a(c, n)
Character c[], n[];
{
    return H2rom(c, n, ASCII);
}

int H2j(c, n)
Character c[], n[];
{
    return H2rom(c, n, JISROMAN);
}

int H2K(c, n)
Character c[], n[];
{
    if (c[0].c1 == 0xa4) {
	n[0].type = JIS83;
	n[0].c1 = 0xa5;
	n[0].c2 = c[0].c2;
	n[1].type = OTHER;
	n[1].c1 = 0;
	n[1].c2 = 0;
	if (c[0].c2 == 0xa6) { /* ==  */
	    if (c[1].c1 == 0)
		return -1;
	    if ((c[1].c1 == 0xa1) && (c[1].c2 == 0xab)) { /* ==  */
		n[0].type = JIS83;
		n[0].c1 = 0xa5;
		n[0].c2 = 0xf4;
		return 2;
	    }
	}
	return 1;
    } else if ((c[0].c1 == 0xa1) &&
	       ((c[0].c2 == 0xbc) || (c[0].c2 == 0xab) || (c[0].c2 == 0xac))) {
	n[0].type = JIS83;
	n[0].c1 = c[0].c1;
	n[0].c2 = c[0].c2;
	n[1].type = OTHER;
	n[1].c1 = 0;
	n[1].c2 = 0;
	return 1;
    } else {
	n[0].type = OTHER;
	n[0].c1 = 0;
	n[0].c2 = 0;
	return 1;
    }
}

int H2k(c, n)
Character c[], n[];
{
    unsigned char *b;
    int i;

    static unsigned char H2k_table[0x60][3] = {
	"",   "'",  "1",  "(",  "2",  ")",  "3",  "*",
	"4",  "+",  "5",  "6",  "6^", "7",  "7^", "8",
	"8^", "9",  "9^", ":",  ":^", ";",  ";^", "<",
	"<^", "=",  "=^", ">",  ">^", "?",  "?^", "@",
	"@^", "A",  "A^", "/",  "B",  "B^", "C",  "C^",
	"D",  "D^", "E",  "F",  "G",  "H",  "I",  "J",
	"J^", "J_", "K",  "K^", "K_", "L",  "L^", "L_",
	"M",  "M^", "M_", "N",  "N^", "N_", "O",  "P",
	"Q",  "R",  "S",  ",",  "T",  "-",  "U",  ".",
	"V",  "W",  "X",  "Y",  "Z",  "[",  "\\",  "\\",
	"2",  "4",  "&",  "]",  "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   ""};

    if (c[0].c1 == 0xa4) {
	for (b = H2k_table[(c[0].c2 & 0x7f) - 0x20], i = 0;
	     *b != '\0'; ++ b, ++ i) {
	    n[i].type = KATAKANA;
	    n[i].c1 = *b;
	}
	n[i].type = OTHER;
	n[i].c1 = 0;
    } else if ((c[0].c1 == 0xa1) &&
	       ((c[0].c2 == 0xbc) || (c[0].c2 == 0xab) || (c[0].c2 == 0xac))) {
	n[0].type = KATAKANA;
	switch(c[0].c2) {
	  case 0xbc:
	    n[0].c1 = '0'; break;
	  case 0xab:
	    n[0].c1 = '^'; break;
	  case 0xac:
	    n[0].c1 = '_'; break;
	}
	n[1].type = OTHER;
	n[1].c1 = 0;
    } else {
	n[0].type = OTHER;
	n[0].c1 = 0;
    }
    return 1;
}
