/*
 * KAKASI (Kanji Kana Simple inversion program)
 * $Header: atoc-conv.c,v 2.2 92/07/19 09:25:55 takahasi Locked $
 * Copyright (C) 1992
 * Hironobu Takahashi (takahasi@tiny.or.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either versions 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with KAKASI, see the file COPYING.  If not, write to the Free
 * Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* $Log:	atoc-conv.c,v $
 * Revision 2.2  92/08/02  takahasi
 * 
 * Revision 2.1  92/07/19  09:25:55  takahasi
 * 
 * Revision 2.0  92/07/18  15:17:12  takahasi
*/

static char RCS_ID[] = "@(#) $Header: atoc-conv.c,v 2.2 92/08/02 takahasi Locked $";

#include <stdio.h>

main(argc, argv)
int argc;
char *argv[];
{
    int i;
    for(i = 1; i < argc; ++ i) {
	extract(argv[i]);
    }
    return 0;
}

extract(file_name)
char *file_name;
{
    FILE *fp;
    unsigned char sjis[1024], ujis[1024];
    unsigned char f1[1024], f2[1024];

    if ((fp = fopen(file_name, "r")) == NULL) {
	perror(file_name);
	return;
    }

    while(fgets(sjis, 1024, fp) != NULL) {
	if ((sjis[0] == '\0') || (sjis[0] == '#')) continue;
	sjis2ujis(sjis, ujis);
	if (sscanf(ujis, "%s%s", f1, f2) != 2) continue;
	if (isallkana(f1) == 0) continue;
	if (isallzenkaku(f2) == 0) continue;
	if (includekanji(f2) == 0) continue;
	printf("%s %s\n", f1, f2);
    }
}

sjis2ujis(sjis, ujis)
unsigned char *sjis, *ujis;
{
    unsigned char *p, *q;
    int c1, c2, o1, o2;
    static unsigned char k2H_table[64][3] = {
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "", "", "" };
    static unsigned char k2H_dtable[64][3] = {
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "",   "",   "",
	"",   "",   "", "", "", "", "", "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "" };
    static unsigned char k2H_htable[64][3] = {
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   ""  , "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "", "", "", "", "", "",
	"",   "",   "",   "",   "",   "",   "",   "",
	"",   "",   "",   "",   "",   "",   "",   "" };

    p = sjis;
    q = ujis;
    while((c1 = *p) != '\0') {
	if (c1 == ',') {
	    *(q ++) = ' ';
	} else if (c1 < 0x80) {
	    *(q ++) = c1;
	} else if ((0xa0 <= c1) && (c1  < 0xe0)) {
	    c2 = p[1];
	    if ((c2==0xde) && (k2H_dtable[c1-0xa0][0] != '\0')) {
		*(q ++) = k2H_dtable[c1-0xa0][0];
		*(q ++) = k2H_dtable[c1-0xa0][1];
		++ p;
	    } else if ((c2==0xdf) && (k2H_htable[c1-0xa0][0] != '\0')) {
		*(q ++) = k2H_htable[c1-0xa0][0];
		*(q ++) = k2H_htable[c1-0xa0][1];
		++ p;
	    } else {
		*(q ++) = k2H_table[c1-0xa0][0];
		*(q ++) = k2H_table[c1-0xa0][1];
	    }
	} else {
	    c2 = p[1];
	    if (c2 >= 0x9f) {
		if (c1 >= 0xe0) o1 = c1*2 - 0xe0;
		else o1 = c1*2 - 0x60;
		o2 = c2 + 2;
	    } else {
		if (c1 >= 0xe0) o1 = c1*2 - 0xe1;
		else o1 = c1*2 - 0x61;
		if (c2 >= 0x7f) o2 = c2 + 0x60;
		else o2 = c2 +  0x61;
	    }
	    *(q ++) = o1;
	    *(q ++) = o2;
	    ++ p;
	}
	++ p;
    }
    *q = '\0';
}
