/*
 * KAKASI (Kanji Kana Simple inversion program)
 * $Header: dict.c,v 2.2 92/08/02 takahasi Exp $
 * Copyright (C) 1992
 * Hironobu Takahashi (takahasi@tiny.or.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either versions 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with KAKASI, see the file COPYING.  If not, write to the Free
 * Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* $Log:	dict.c,v $
 * Revision 2.1  92/07/19  09:27:19  takahasi
 * *** empty log message ***
 * 
 * Revision 2.0  92/07/18  12:07:05  takahasi
 * 
*/
#include <stdio.h>
#include <ctype.h>
#include "J2.h"
extern char *strcpy();
extern char *malloc();

#define BUFLEN 1024

#define IALLOCSIZE (1024*100)
#define CELLALLOC  5000

unsigned char *
charalloc(length)
int length;
{
    static int point;
    static unsigned char *ptr = NULL;
    unsigned char *ret;

    if ((ptr == NULL) || (point+length >= IALLOCSIZE)) {
	ptr = (unsigned char *)malloc(IALLOCSIZE);
	point = 0;
    }
    ret = ptr+point;
    point += length;
    return ret;
}

struct kanji_yomi *
cellalloc()
{
    static int point;
    static struct kanji_yomi *ptr = NULL;

    if ((ptr == NULL) || (point >= CELLALLOC)) {
	char *cptr;
	cptr = malloc((CELLALLOC+1)*sizeof(struct kanji_yomi));
	if ((int)cptr & 7) cptr += 8 - ((int)cptr & 7);
	ptr = (struct kanji_yomi *) cptr;
	point = 0;
    }
    ++ point;
    return ptr ++;
}

init_jisyo()
{
    int c1, c2;

    for(c1 = 0; c1 < 0x80; c1 ++)
	for(c2 = 0; c2 < 0x80; c2 ++)
	    jisyo_table[c1][c2] = NULL;
}

add_jisyo(filename)
char *filename;
{
    FILE *jisyo_fp;
    unsigned char buffer[BUFLEN];
    unsigned char *p;
    unsigned char *yomi, *kanji;
    int tail;
    extern char *ialloc();

    if ((jisyo_fp = fopen(filename, "r")) == NULL) {
	perror(filename);
	exit(0);
    }
    while(fgets(buffer, BUFLEN, jisyo_fp)) {
	/* ʰʳƬˤм */
	if ((buffer[0] < 0xa0) && (buffer[0] != '\033')) continue;

	/* Ԥ ujis Ѵ */
	jis2ujis_jisyo(buffer);

	yomi = buffer;
	/* ζڤܤ */
	for (p = buffer; (*p != ' ') && (*p != '\011') && (*p != ','); ++ p) {
	    if ((*p == '\0') || (*p == '\n')) goto next_line;
	}

	if (isalpha(p[-1])) { /* Ǹʸե٥åȤʤ꤬ */
	    tail = p[-1];
	    p[-1] = '\0';
	} else {
	    tail = 0;
	    p[0] = '\0';
	}

	/* ʸܤ */
	for (++ p; (*p == ' ') || (*p == '\011') || (*p == ','); ++ p) {
	    if ((*p == '\0') || (*p == '\n')) goto next_line;
	}

	if (*p == '/') { /* SKK μ餷 */
	    for (;;) {
		kanji = p+1;
		/* ζڤܤ */
		for (++ p; (*p != '/'); ++ p) {
		    if ((*p == '\0')||(*p == '\n')||(*p == '[')) goto next_line;
		}
		*p = '\0';
		add_item(yomi, kanji, tail);
	    }
	} else { /* ɸŪʼ餷 */
	    kanji = p;
	    /* ζڤܤ */
	    for (++ p; 
		 (*p != ' ') && (*p != '\n') && (*p != '\011') &&
		 (*p != '\0') && (*p != ',')
		 ; ++ p) {
		;
	    }
	    *p = '\0';
	    add_item(yomi, kanji, tail);
	}
      next_line:;
    }
    fclose(jisyo_fp);
}

add_item(yomi, kanji, tail)
unsigned char *yomi, *kanji;
int tail;
{
    unsigned char *q, *ptr_kanji, *ptr_yomi;
    struct kanji_yomi *ptr_kanji_yomi, **ptr;
    int length, c1, c2;

    /* Ƭϴ */
    if (kanji[0] < 0xb0) return;

    /* 'Ⱦʸ'ޤޤƤʤ  λѴ */
    for (q = kanji;; q += 2) {
	c1 = q[0]; c2 = q[1];
	if ((c1 == '\0') || (c2 == '\0')) break;
	if ((c1 <= 0xa0) || (c2 <= 0xa0)) return;
	itaijiknj(&c1, &c2);
	q[0] = c1; q[1] = c2;
    }

    /* ''ʳޤޤƤʤ ʤϤҤ餬ʤѴ */
    for (q = yomi; (q[0] != '\0') && (q[1] != '\0'); q += 2) {
	if (*q < 0xa1) return;
	if (*q == 0xa5) *q = 0xa4;
	if ((*q != 0xa4) &&
	    ((q[0] != 0xa1) || (q[1] != 0xbc)) && /* Ĺ */ 
	    ((q[0] != 0xa1) || (q[1] != 0xab)) && /*  */
	    ((q[0] != 0xa1) || (q[1] != 0xac)))   /* Ⱦ */
	    return;
    }

    /* ɤߤΤΥ */

    length = strlen(kanji);
    ptr_kanji =	charalloc(length-1);
    strcpy(ptr_kanji, kanji+2);
    ptr_yomi = charalloc(strlen(yomi)+1);
    strcpy(ptr_yomi, yomi);

    ptr_kanji_yomi = cellalloc();
    ptr_kanji_yomi->next = NULL;
    ptr_kanji_yomi->length = tail ? length+1 : length;
    ptr_kanji_yomi->kanji = ptr_kanji;
    ptr_kanji_yomi->yomi = ptr_yomi;
    ptr_kanji_yomi->tail = tail;

    /*  link κǸõ³ */
    for (ptr = &(jisyo_table[kanji[0]-0x80][kanji[1]-0x80]);
	 *ptr != NULL;
	 ptr = &((*ptr)->next));
    *ptr = ptr_kanji_yomi;
}

/* kanwa  initialize 򤹤롣ºݤˤƬʬ kanwa ɤ߹,
   kanwa_load  clear 롣*/

FILE *kanwadict;

init_kanwa()
{
    int i, j;
    
    if ((kanwadict = fopen(KANWADICT,"r")) == NULL) {
	perror(KANWADICT);
	exit(2);
    }

    if (fread((char *)kanwa, sizeof kanwa, 1, kanwadict) != 1) {
	perror(KANWADICT);
    }

    for (i = 0; i < 0x80; ++ i)
	for (j = 0; j < 0x80; ++ j)
	    kanwa_load[i][j] = 0;
}

/* ɬפ˱ kanwa 鳺ʬФ */

add_kanwa(c1, c2)
int c1, c2;
{
    unsigned char *ptr_yomi, *ptr_kanji;
    struct kanji_yomi *ptr_kanji_yomi, **ptr;
    int i;
    unsigned char tail, length;

    c1 &= 0x7f;
    c2 &= 0x7f;

    if (kanwa_load[c1][c2]) return;
    kanwa_load[c1][c2] = 1;

    /* ǰΤἭ˵ҤʤϽλ */
    if (kanwa[c1-0x20][c2-0x20].entry == 0) return;
    /* kanwadict νΰ֤˰ư */
    fseek(kanwadict, (long)(kanwa[c1-0x20][c2-0x20].index), 0L);

    /*  link κǸõ */
    for (ptr = &(jisyo_table[c1][c2]);
	 *ptr != NULL;
	 ptr = &((*ptr)->next));

    for (i = 0; i < kanwa[c1-0x20][c2-0x20].entry; ++ i) {
	ptr_kanji_yomi = cellalloc();

	fread(&tail, 1, 1, kanwadict);
	ptr_kanji_yomi->tail = tail;

	fread(&length, 1, 1, kanwadict);
	ptr_kanji = charalloc(length+1);
	fread(ptr_kanji, (int)length, 1, kanwadict);
	ptr_kanji[length] = '\0';
	ptr_kanji_yomi->kanji = ptr_kanji;

	ptr_kanji_yomi->length = length + ((tail == 0) ? 2 : 3);

	fread(&length, 1, 1, kanwadict);
	ptr_yomi = charalloc(length+1);
	fread(ptr_yomi, (int)length, 1, kanwadict);
	ptr_yomi[length] = '\0';
	ptr_kanji_yomi->yomi = ptr_yomi;

	ptr_kanji_yomi->next = NULL;

	*ptr = ptr_kanji_yomi;
	ptr = &(ptr_kanji_yomi->next);
    }
}

jis2ujis_jisyo(buffer)
unsigned char *buffer;
{
    unsigned char *p, *q;
    int kanji=0;

    p = q = buffer;
    while(*p != '\0') {
	if (*p == '\033') {
	    if ((p[1] == '$') &&
		((p[2] == '@') || (p[2] == 'B'))) {
		kanji = 1;
		p += 2;
	    } else if ((p[1] == '(') &&
		       ((p[2] == 'B') || (p[2] == 'J'))) {
		kanji = 0;
		p += 2;
	    } else {
		*(q ++) = *p;
	    }
	} else {
	    if (kanji) {
		*(q ++) = *(p ++) | 0x80;
		*(q ++) = *p | 0x80;
	    } else {
		*(q ++) = *p;
	    }
	}
	++ p;
    }
    *q = '\0';
}

