/*
 * KAKASI (Kanji Kana Simple inversion program)
 * $Header: itaiji.c,v 2.0 92/07/18 12:07:07 takahasi Exp $
 * Copyright (C) 1992
 * Hironobu Takahashi (takahasi@tiny.or.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either versions 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with KAKASI, see the file COPYING.  If not, write to the Free
 * Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* $Log:	itaiji.c,v $
 * Revision 2.0  92/07/18  12:07:07  takahasi
 * *** empty log message ***
 * 
*/
#include <stdio.h>
#define BUFSIZE 128

/* λѴơ֥ */

unsigned char ittbl1[0x80][0x80], ittbl2[0x80][0x80];
static int itaijitbl_made=0;

mkitaijitbl()
{
    FILE *fp;
    int i, j;
    char buffer[BUFSIZE];
    unsigned char n1, n2, o1, o2;
    
    if ((fp = fopen(ITAIJIDICT, "r")) == NULL) {
	fprintf(stderr, "Can't open Kanji itaijidict file ");
	perror(ITAIJIDICT);
	exit(0);
    }
    for (i = 0; i < 0x80; ++ i) {
	for (j = 0; j < 0x80; ++ j) {
	    ittbl1[i][j] = i | 0x80;
	    ittbl2[i][j] = j | 0x80;
	}
    }
    while(fgets(buffer, BUFSIZE, fp) != NULL) {
	sscanf(buffer, "%1c%1c%1c%1c", &n1, &n2, &o1, &o2);
	n1 &= 0x7f;
	n2 &= 0x7f;
	ittbl1[n1][n2] = o1;
	ittbl2[n1][n2] = o2;
    }
    fclose(fp);
}

/* λѴ */

itaijiknj(c1, c2)
int *c1, *c2;
{
    int b1, b2;

    if (itaijitbl_made == 0) {
	mkitaijitbl();
	itaijitbl_made =1;
    }

    b1 = *c1 & 0x7f;
    b2 = *c2 & 0x7f;
    *c1 = ittbl1[b1][b2];
    *c2 = ittbl2[b1][b2];
}
