/*
 * KAKASI (Kanji Kana Simple inversion program)
 * $Header: mkkanwa.c,v 2.0 92/07/18 12:07:17 takahasi Exp $
 * Copyright (C) 1992
 * Hironobu Takahashi (takahasi@tiny.or.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either versions 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with KAKASI, see the file COPYING.  If not, write to the Free
 * Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* $Log:	mkkanwa.c,v $
 * Revision 2.0  92/07/18  12:07:17  takahasi
 * *** empty log message ***
 * 
*/
#ifndef lint
static char SCCS_ID[] = "@(#)mkkanwa.c 1.3 92/06/15 written by H. Takahashi";
#endif

#include <stdio.h>
#include "J2.h"

main(argc, argv)
int argc;
char *argv[];
{
    FILE *kdict;
    static char options[]="h";
    int c;
    extern char *optarg;
    extern int optind;

    /* ץ = ΥСǤϤʤϤ */
    while ((c = getopt(argc, argv, options)) != -1) {
	switch (c) {
	  case 'h':
	  default:
	    usage(argv, options);
	}
    }
    if (optind >= argc)
	usage(argv, options);
    if ((kdict = fopen(argv[optind],"w")) == NULL) {
	perror(argv[optind]);
	exit(2);
    }

    /* λѴơ֥κ */
    mkitaijitbl();

    /* ɤ߹ */
    init_jisyo();
    for (optind ++ ; optind < argc; optind++)
	add_jisyo(argv[optind]);

    make_kanwa_dict(kdict);
    fclose(kdict);
    return 0;
}
	
usage(argv, options)
char *argv[];
char *options;
{
    (void)fprintf(stderr, "usage: %s -%s kanwadict dict1 [dict2,,,]\n",
		  argv[0], options);
    exit (2);
}

make_kanwa_dict(kdict)
FILE *kdict;
{
    unsigned char length;
    int i, j, count;
    struct kanji_yomi *ptr;

    fseek(kdict, sizeof kanwa, 0L);

    for (i = 0x20; i < 0x7f; ++ i)
	for (j = 0x20; j < 0x7f; ++ j) {
	    kanwa[i-0x20][j-0x20].index = ftell(kdict);
	    count = 0;
	    for (ptr = jisyo_table[i][j]; ptr != NULL;
		 ptr = ptr->next) {
		fwrite(&(ptr->tail), 1, 1, kdict);
		length = ptr->length - ((ptr->tail == 0) ? 2 : 3);
		fwrite(&length, 1, 1, kdict);
		fwrite(ptr->kanji, (int)length, 1, kdict);
		length = strlen(ptr->yomi);
		fwrite(&length, 1, 1, kdict);
		fwrite(ptr->yomi, (int)length, 1, kdict);
		++count;
	    }
	    kanwa[i-0x20][j-0x20].entry = count;
	}

    fseek(kdict, 0, 0L);
    fwrite((char *)kanwa, sizeof kanwa, 1, kdict);
}
