/*
 * $Header: /afs/athena.mit.edu/astaff/project/olcdev/highlander/src/include/RCS/rpd.h,v 1.21 1997/08/27 23:17:11 bert Exp $
 * Copyright (C) 1989,1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 */

#include <mit-copyright.h>
#include "olxx_paths.h"
#include "nl_requests.h"
#include "system.h"

#include <sys/types.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/param.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <signal.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <syslog.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <limits.h>

#if defined(__STDC__) && !defined(__HIGHC__)
/* Stupid High-C claims to be ANSI but doesn't have the include files.. */
#include <stdlib.h>
#endif

#ifndef MIN
#define        MIN(a,b) (((a)<(b))?(a):(b))
#endif

/* Note: cachesize must be a power of two.  Also, the maximum limit on open */
/* file descriptors in a process should be taken into account. */
#define CACHESIZE    256       /* file descriptor cache size */
#define CACHEWIDTH     8       /* log_2(CACHESIZE) */

#define HASHMUL 1148159605     /* multiplying factor for the hash function */
#define HASHROLL 5             /* cyclic shift size for the hash function */

struct 	entry {
  int fd;		/* file descriptor */
  char *filename;
  time_t last_mod;	/* Time log last modified */
  ino_t inode;		/* Inode of the file */
  int length;		/* Length of the question */
  char *question;	/* pointer to buffer containing question */
  short int use;	/* mark for the clock hand */
  struct entry *next;	/* next entry in the chain */
  struct entry *prev;	/* prev entry in the chain */
};

#define SYSLOG_FACILITY LOG_LOCAL6
#define LOG_DIRECTORY   OLXX_QUEUE_DIR


#ifdef __STDC__
# define        P(s) s
#else
# define P(s) ()
#endif


#ifdef KERBEROS
#define K_SERVICE	"olc"

#define SRVTAB      OLXX_CONFIG_DIR "/srvtab"
#define MONITOR_ACL OLXX_ACL_DIR "/monitor.acl"

/* Acl Library */
int acl_check P((char *acl, char *principal));
void acl_canonicalize_principal P((char *principal , char *canon ));
int acl_exact_match P((char *acl , char *principal ));
#endif /* KERBEROS */

/* fdcache.c */
void init_cache P((void ));
char *get_queue P((int *result));
char *get_log P((char *username , int instance , int *result , int censored));
char *get_file_uncached P((char *filename, int *result));
char *get_file_cached P((char *filename, int *result));
unsigned get_bucket_index P((char *name));
int allocate_entry P((void ));
void delete_entry P((struct entry *ent ));

/* get_nm.c */
char *get_nm P((char *username , int instance , int *result , int nuke ));

/* handle_request.c */
void handle_request P((int fd, struct sockaddr_in from));
void punt_connection P((int fd, struct sockaddr_in from));

/* io.c */
int sread P((int fd , void *buf , int nbytes ));
int swrite P((int fd , void *buf , int nbytes ));

#undef P
