/*
 * This file is part of the OLC On-Line Consulting system.
 * It contains definitions for operating-system routines that don't
 * appear to be defined elsewhere, at least in BSD.
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *	$Source: /afs/athena.mit.edu/astaff/project/olcdev/highlander/src/include/RCS/system.h,v $
 *	$Id: system.h,v 1.10 1997/04/01 15:46:07 bert Exp $
 *	$Author: bert $
 */

#include <mit-copyright.h>

#ifdef __STDC__
# define        P(s) s
#else
# define P(s) ()
#endif

#include <sys/types.h>
#ifdef KERBEROS
#include <krb.h>
#endif /* KERBEROS */

#ifdef HESIOD
#include <hesiod.h>
#endif

#undef P

/* This file used to define the prototypes for the functions listed
 * below.  Unfortunately, having prototypes breaks things if the
 * prototype is wrong, while not having them is usually just annoying.
 * Therefore, the prototypes have been removed.  On modern operating
 * systems, all system functions have prototypes in header files,
 * which should be included above.
 *
 * calloc, malloc, strcpy, strncpy, atoi, [bcopy], [bzero], close,
 * exit, free, getdtablezise, getopt, getsockopt, gethostbyname,
 * ioctl, listen, lseek, open, openlog, psignal(?), read,
 * getservbyname, setsockopt, shutdown, socket, strcmp, syslog, write
 */
