/* Copyright (C) 1991, 1992, 1995, 1996, 1997 Free Software Foundation, Inc.
   This file was part of the GNU C Library and changed beyond reconginition by
   Oliver Kurth 2000 as a supplement for systems without getdelim

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <config.h>
#ifndef HAVE_GETDELIM

#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <errno.h>

/* Read up to (and including) a TERMINATOR from STREAM into *LINEPTR
   (and null-terminate it). *LINEPTR is a pointer returned from malloc (or
   NULL), pointing to *N characters of space.  It is realloc'd as
   necessary.  Returns the number of characters read (not including the
   null terminator), or -1 on error or EOF.  */

#ifndef MAX_CANON
#define	MAX_CANON	256
#endif

size_t getdelim(char **lineptr, size_t *n, int terminator, FILE *stream)
{
  char *line, *p;
  size_t size, copy;

  if (*lineptr == NULL || *n < 2){ /* !seen and no buf yet need 2 chars.  */
    line = realloc (*lineptr, MAX_CANON);
    if (line == NULL)
      return -1;
    *lineptr = line;
    *n = MAX_CANON;
  }

  line = *lineptr;
  size = *n;

  copy = size;
  p = line;

  while (1){
    size_t len;

    while (--copy > 0){
      register int c = getc (stream);
      if (c == EOF)
	return -1;
      else if ((*p++ = c) == terminator){
	*p = '\0';
	return p - *lineptr;
      }
    }

    /* Need to enlarge the line buffer.  */
    len = p - line;
    size *= 2;
    line = realloc (line, size);
    if (line == NULL)
      return -1;
    *lineptr = line;
    *n = size;
    p = line + len;
    copy = size - len;
  }
}

#endif
