/*  jpilot-Mail
    Copyright (C) 2000 Oliver Kurth

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#define JP_LOG_DEBUG  1    /*debugging info for programers, and bug reports */

#define JP_LOG_INFO   2    /*info, and misc messages */
#define JP_LOG_WARN   4    /*worse messages */
#define JP_LOG_FATAL  8    /*even worse messages */
#define JP_LOG_STDOUT 256  /*messages always go to stdout */
#define JP_LOG_FILE   512  /*messages always go to the log file */
#define JP_LOG_GUI    1024 /*messages always go to the gui window */

void cb_mail_edit(GtkWidget *widget, gpointer data);
void cb_mail_send(GtkWidget *widget, gpointer data);

void cb_mail_get(GtkWidget *widget, gpointer data);

/*
struct Mail {
  int read;
  int signature;
  int confirmRead;
  int confirmDelivery;
  int priority;
  int addressing;
  
  int dated;
  struct tm date;
  
  char * subject;
  char * from;
  char * to;
  char * cc;
  char * bcc;
  char * replyTo;
  char * sentTo;
  char * body;
};
*/

struct MyMail
{
  PCRecType rt;
  unsigned int unique_id;
  unsigned char attrib;
  struct Mail mail;
  struct MyMail *next;
};

#define ATTRIB_INBOX 0
#define ATTRIB_OUTBOX 1
#define ATTRIB_DELETED 2
#define ATTRIB_FILED 3
#define ATTRIB_DRAFT 4

extern
struct Preferences
{
  char *smtp_server;
  gint smtp_port;

  char *from_name;
  char *from_address;
  char *default_domain;

  char *folder_path_inbox;

  gboolean presync_get;
  gboolean postsync_send;
  
  gboolean get_read;
}prefs;

extern struct MailSyncPref mailSyncPref;
extern struct MailSignaturePref mailSigPref;

extern struct MyMail *glob_mymail_list;

/* define flags Mozilla compatible: */
#define STATUS_READ 0x0001
#define STATUS_DELETED 0x0008

#ifndef HAVE_GETLINE
#define getline(buf, size, file) getdelim(buf, size, '\n', file)
#endif

