/*  jpilot-Mail
    Copyright (C) 2000 Oliver Kurth

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include <gtk/gtk.h>
#include "libplugin.h"
#include <pi-mail.h>

#include "masqmail.h"
#include "mail.h"

struct msg_id
{
  gchar *str;
  gboolean is_seen;
};

static
void destroy_idlist(GList *id_list)
{
  GList *node;

  foreach(id_list, node){
    struct msg_id *msgid = (struct msg_id *)(node->data);

    g_free(msgid->str);
  }
  g_list_free(id_list);
}

static
GList *read_msgids()
{
  gchar fname[256];
  FILE *fptr;

  get_home_file_name(".mailids", fname, 255);
  if(fptr = fopen(fname, "r")){
    GList *id_list = NULL;
    gchar *line = NULL;
    gint line_size = 0;
    while(!feof(fptr)){
      struct msg_id *msgid = g_malloc(sizeof(struct msg_id));
      msgid->is_seen = FALSE;
      getline(&line, &line_size, fptr);
      g_strchomp(line);
      msgid->str = g_strdup(line);
      id_list = g_list_append(id_list, msgid);
    }
    fclose(fptr);
    return id_list;
  }
  jpilot_logf(JP_LOG_INFO, "could not read idlist %s\n", fname);
  return NULL;
}

static 
gboolean write_msgids(GList *id_list)
{
  gchar fname[256];
  FILE *fptr;

  get_home_file_name(".mailids", fname, 255);
  if(fptr = fopen(fname, "w")){
    GList *node;
    
    foreach(id_list, node){
      struct msg_id *msgid = (struct msg_id *)(node->data);
      if(msgid->is_seen){
	fputs(msgid->str, fptr);
	fputc('\n', fptr);
      }
    }
    fclose(fptr);
    return TRUE;
  }
  return FALSE;
}

static
struct msg_id *find_idlist(GList *id_list, gchar *str)
{
  GList *node;
  struct msg_id *ret = NULL;
  gchar *tmp = g_strdup(str);
  g_strchomp(tmp);

  foreach(id_list, node){
    struct msg_id *msgid = (struct msg_id *)(node->data);
    if(strcmp(msgid->str, tmp) == 0){
      ret = msgid;
      break;
    }
  }
  g_free(tmp);
  return ret;
}

static
guint msg_status(message *msg)
{
  GList *hdr_list;
  guint flags = 0;

  if(hdr_list = find_header(msg->hdr_list, HEAD_STATUS, NULL)){
    header *hdr = (header *)(g_list_first(hdr_list)->data);
    gchar *p = hdr->value;
    while(*p && isspace(*p)) p++;
    while(*p){
      switch(*p){
      case 'D':
	flags &= STATUS_DELETED; break;
      case 'R':
	flags &= STATUS_READ; break;
      }
      p++;
    }
    g_list_free(hdr_list);
    return flags;
  }else if(hdr_list = find_header(msg->hdr_list, HEAD_UNKNOWN, "X-Mozilla-Status")){
    header *hdr = (header *)(g_list_first(hdr_list)->data);
    flags = strtol(hdr->value, (char **)NULL, 16);
    g_list_free(hdr_list);
  }
  return flags;
}

// noamh
void cb_mail_get(GtkWidget *widget, gpointer data)
{
  FILE *in;
  char *line = NULL;
  gint line_size = 0;
  GList *id_list = read_msgids();

  in = fopen(prefs.folder_path_inbox, "rt");

  if(!in){
    jpilot_logf(JP_LOG_WARN, "could not open %s: %s\n", prefs.folder_path_inbox, strerror(errno));
    return;
  }
  jpilot_logf(JP_LOG_INFO, "reading file %s\n", prefs.folder_path_inbox);
  getline(&line, &line_size, in);
  while(strncmp(line, "From ", 5) == 0){
    message *msg = create_message();
    struct msg_id *msgid;
    GList *tmp_list;
    header *id_hdr = NULL;
    guint status_flags;

    g_free(line);
    mbox_read(msg, in, &line, mailSyncPref.truncate);

    status_flags = msg_status(msg);

    /* okay, we have read in the whole message, but may skip it now
       we should split that mbox_read function for headers and body */

    if(!(status_flags & STATUS_DELETED)){
      if(prefs.get_read || (!(status_flags & STATUS_READ))){

	/* use Message ID as id, this matches also if fetched from another host */
	/* jpilot_logf makes problems... */
	/*	jpilot_logf(LOG_DEBUG, "searching Message-ID header\n");*/
	tmp_list = find_header(msg->hdr_list, HEAD_MESSAGE_ID, NULL);
	if(!tmp_list){
	  /* use X-UIDL as id if message id does not exist (VERY unlikely) */
	  /*	  jpilot_logf(LOG_DEBUG, "searching X-UIDL header\n");*/
	  tmp_list = find_header(msg->hdr_list, HEAD_UNKNOWN, "X-UIDL");
	  if(!tmp_list){
	    /* use date as last resort */
	    /*	    jpilot_logf(LOG_DEBUG, "searching Date header\n");*/
	    tmp_list = find_header(msg->hdr_list, HEAD_DATE, NULL);
	    if(!tmp_list){
	      jpilot_logf(JP_LOG_WARN, "no way to uniquely identify messages found...\n");
	    }
	  }
	}
	if(tmp_list){
	  id_hdr = g_list_first(tmp_list)->data;
	  g_list_free(tmp_list);
	}
      
	if((!(msgid = find_idlist(id_list, id_hdr->value))) || (id_hdr == NULL)){
	  struct Mail *pMail = g_malloc(sizeof(struct Mail));
	  gint size;
	  buf_rec br;
	  unsigned char *buf = g_malloc(0xffff);
	
	  if(buf){
	    msg2jp(msg, pMail, mailSyncPref.truncate, status_flags);
	    size = pack_Mail(pMail, buf, 0xFFFF);
      
	    /* This is a new record from the PC, and not yet on the palm */
	    br.rt = NEW_PC_REC;
      
	    /* jp_pc_write will give us a temporary PC unique ID. */
	    /* The palm will give us an "official" unique ID during the sync */
      
	    br.unique_id = 0;
	    /* Any attributes go here.  Usually just the category */
      
	    br.attrib = ATTRIB_INBOX;
	    br.buf = buf;
	    br.size = size;
      
	    jp_pc_write("MailDB", &br);
      
	    g_free(pMail);

	    msgid = (struct msg_id *)g_malloc(sizeof(struct msg_id));
	    msgid->str = g_strchomp(g_strdup(id_hdr->value));
	    id_list = g_list_append(id_list, msgid);

	    g_free(buf);
	  }else
	    jpilot_logf(JP_LOG_WARN, "g_malloc failed\n");

	}else
	  jpilot_logf(JP_LOG_DEBUG, "message was already touched\n");

	if(msgid)
	  msgid->is_seen = TRUE;
      }
    }
    destroy_message(msg);
  }

  if(widget)
    display_records();

  fclose(in);

  write_msgids(id_list);
  destroy_idlist(id_list);

  if(data){
    if (GTK_IS_WIDGET(data)) {
      gtk_widget_destroy(data);
    }
  }
}

