/*  jpilot-Mail
    Copyright (C) 2000 Oliver Kurth

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include <locale.h>

#include <gtk/gtk.h>
#include "libplugin.h"
#include <pi-mail.h>

#include "masqmail.h"
#include "smtp_out.h"
#include "mail.h"

masqmail_conf conf;

void logwrite(int pri, const char *fmt, ...)
{
  va_list args;
  va_start(args, fmt);

  vfprintf(stderr, fmt, args);
  fflush(stderr);

  /*  jpilot_logf(LOG_INFO, fmt, args);*/

  va_end(args);
}

void debugf(const char *fmt, ...)
{
  va_list args;
  va_start(args, fmt);

  vfprintf(stderr, fmt, args);
  fflush(stderr);

  /*  jpilot_logf(LOG_DEBUG, fmt, args);*/

  va_end(args);
}

void mail_accept(FILE *in)
{
  int i = 0;

  conf.host_name = g_strdup(prefs.default_domain);
  conf.curr_route = NULL;
  conf.debug_level = 5;

  /* Make sure that the Date header will be conforming: */
  setlocale(LC_ALL, "C");

  while(!feof(in)){
    gint err;
    message *msg = create_message();

    GList *resolve_list =
      g_list_append(NULL, resolve_byname);
    
    msg->transfer_id = i++;

    if(msg == NULL) _exit(EXIT_FAILURE);
    msg->received_host = NULL;
    msg->return_path = NULL;
    if(prefs.from_address)
      if(strlen(prefs.from_address))
	msg->return_path = create_address(prefs.from_address, TRUE);
    msg->received_prot = PROT_LOCAL;
    msg->rcpt_list = NULL;
      
    jpilot_logf(JP_LOG_DEBUG, "accepting message\n");
    if((err = accept_message(in, msg, ACC_DEL_BCC|ACC_RCPT_FROM_HEAD|ACC_NO_RECVD_HDR))
       == AERR_OK){
      
      jpilot_logf(JP_LOG_DEBUG, "delivering message\n");
      if(!(smtp_deliver(prefs.smtp_server, prefs.smtp_port, resolve_list, msg, NULL, NULL)
	   == smtp_ok))
	debugf("smtp_deliver failed.\n");
      jpilot_logf(JP_LOG_DEBUG, "after delivering\n");

      {
	GList *rcpt_node;
	gboolean failed = FALSE;
	foreach(msg->rcpt_list, rcpt_node){
	  address *rcpt = (address *)(rcpt_node->data);
	  if(!adr_is_delivered(rcpt)){
	    jpilot_logf(JP_LOG_WARN, "message could not be delivered to %s@%s\n", rcpt->local_part, rcpt->domain);
	    failed = TRUE;
	  }
	}
      }
    }

    g_free(msg);

    {
      int c = getc(in);
      if(c != EOF) ungetc(c, in);
      else return;
    }
  }
}

static
void print_header(FILE *out, gchar *hdr, gchar *value)
{
  if(value != NULL){
    gchar *header = g_strdup(value);

    if(header != NULL){
      fprintf(out, "%s %s\r\n", hdr, g_strchomp(header));
    }
    g_free(header);
  }
}

void mail_put(FILE *out)
{
  struct MyMail *pMail;
  gchar *tmp_text;
  int i = 0;
  GList *rec_list = NULL, *rec_node;
  GList *mail_list = NULL, *mail_node;
  buf_rec *pBufRec;

  jp_read_DB_files("MailDB", &rec_list);
  foreach(rec_list, rec_node){
    buf_rec *pBufRec = (buf_rec *)(rec_node->data);
    if (!((pBufRec->rt == DELETED_PALM_REC) || (pBufRec->rt == MODIFIED_PALM_REC))){
      if((pBufRec->attrib & 0x0f) == ATTRIB_OUTBOX){
	struct MyMail *pMail = g_malloc(sizeof(struct MyMail));
	pMail->next = NULL;
	pMail->attrib = pBufRec->attrib;
	pMail->unique_id = pBufRec->unique_id;
	pMail->rt = pBufRec->rt;

	if (unpack_Mail(&(pMail->mail), pBufRec->buf, pBufRec->size) != 0) {
	  mail_list = g_list_append(mail_list, pMail);
	}
      }
    }
  }

  foreach(mail_list, mail_node){
    struct MyMail *pMail = (struct MyMail *)(mail_node->data);
    i++;

    jpilot_logf(JP_LOG_INFO, "sending message %d\n", i);
    if(prefs.from_name && prefs.from_address){
      if(strlen(prefs.from_name) && strlen(prefs.from_address)){
	fprintf(out, "From: %s <%s>\r\n", prefs.from_name, prefs.from_address);
      }
    }

    print_header(out, "To:", pMail->mail.to);
    print_header(out, "Cc:", pMail->mail.cc);
    print_header(out, "Bcc:", pMail->mail.bcc);
    print_header(out, "Reply-To:", pMail->mail.replyTo);
    print_header(out, "Subject:", pMail->mail.subject);

    /* make some advertisement ;-): */
    {
      gchar *str = g_strdup_printf("%s %s", PACKAGE, VERSION);
      print_header(out, "X-Mailer:", str);
      g_free(str);
    }

    print_header(out, "MIME-Version:", "1.0");
    /* check for necessary MIME type: */
    {
      gboolean is_ascii = TRUE;
      if(pMail->mail.body != NULL){
	guchar *p = pMail->mail.body;
	while(*p){
	  if(*p >= 127){
	    is_ascii = FALSE;
	    break;
	  }
	  p++;
	}
      }
      if(is_ascii){
	print_header(out, "Content-Type:", "text/plain; charset=us-ascii");
	print_header(out, "Content-Transfer-Encoding:", "7bit");
      }else{
	/* This is a quick hack. Sorry for all folks using different char sets... */
	print_header(out, "Content-Type:", "text/plain; charset=iso-8859-1");
	print_header(out, "Content-Transfer-Encoding:", "8bit");
      }
    }

    if(pMail->mail.body != NULL){
      fprintf(out, "\r\n%s", pMail->mail.body);
    }
    if(mailSigPref.signature != NULL){
      if(strlen(mailSigPref.signature)){
	fprintf(out, "\r\n--\r\n", pMail->mail.body);
	fprintf(out, "%s", mailSigPref.signature);
      }
    }
    fprintf(out, "\r\n.\r\n");
  }
  
  foreach(mail_list, mail_node){
    struct MyMail *pMail = (struct MyMail *)(mail_node->data);
    g_free(pMail);
  }
  g_list_free(mail_list);

  foreach(rec_list, rec_node){
    struct MyMail *pMail = (struct MyMail *)(rec_node->data);
    g_free(pMail);
  }
  g_list_free(rec_list);
}

void cb_mail_send(GtkWidget *widget, gpointer data)
{
  int pipes[2];

  void (*old_sighandler)(int);
  /* preliminary */
  old_sighandler = signal(SIGCHLD, SIG_DFL);

  if(socketpair(PF_LOCAL, SOCK_STREAM, 0, pipes) == 0){
    pid_t pid;

    pid = fork();
    if(pid == 0){
      FILE *in = fdopen(pipes[0], "r");
      close(pipes[1]);
      mail_accept(in);
      fclose(in);
      _exit(EXIT_SUCCESS);
    }else if(pid > 0){
      int status;

      FILE *out = fdopen(pipes[1], "w");
      mail_put(out);
      fclose(out);

      waitpid(pid, &status, 0);
    }else{
      fprintf(stderr, "fork failed.\n");
    }
    close(pipes[0]);
    close(pipes[1]);
  }
  if (GTK_IS_WIDGET(data)) {
    gtk_widget_destroy(data);
  }

  signal(SIGCHLD, old_sighandler);
}

