/*  MasqMail
    Copyright (C) 2000 Oliver Kurth

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "masqmail.h"

gboolean mbox_read(message *msg, FILE *in, gchar **from_line, int max_size)
{
  gchar *line = NULL;
  gint line_size = 0, line_cnt = 0;
  gint data_size = 0;
  gboolean in_headers = TRUE;
  int l_no = 1;
  header *hdr;

  if(!msg) return FALSE;

  while(!feof(in)){
    if(getline(&line, &line_size, in)){
      l_no++;
      if(strncmp(line, "From ", 5) == 0) {
	break;
      }
    }
    
    if(in_headers){
      if(line[0] == ' ' || line[0] == '\t'){
	/* continuation of 'folded' header: */
	if(hdr){
	  hdr->header = g_strconcat(hdr->header, line, NULL);
	}

      }else if(line[0] == '\n'){
	/* an empty line marks end of headers */
	in_headers = FALSE;
      }else{
	/* in all other cases we expect another header */
	if(hdr = get_header(line))
	  msg->hdr_list = g_list_append(msg->hdr_list, hdr);
	else{
	  /* if get_header() returns NULL, no header was recognized,
	     so this seems to be the first data line of a broken mailer
	     which does not send an empty line after the headers */
	  in_headers = FALSE;
	  msg->data_list = g_list_append(msg->data_list, g_strdup(line));
	}
      }
    }else{
      if (data_size < max_size) {
      	msg->data_list = g_list_append(msg->data_list, g_strdup(line));
      	data_size += strlen(line);
      } 
      line_cnt++;
    }
  }

  *from_line = line;

  return TRUE;
}

