
#include <Python.h>
#include <stdio.h>
#include <math.h>
#include "libnumarray.h"

#ifdef MS_WIN32
#pragma warning(once : 4244)
#endif

#define logical_and(arg1, arg2) (arg1 != 0) & (arg2 != 0)
#define logical_or(arg1, arg2)  (arg1 != 0) | (arg2 != 0)
#define logical_xor(arg1, arg2) ((arg1 != 0) ^ (arg2 != 0)) & 1
#define ufmaximum(arg1, arg2) (((temp1=arg1) > (temp2=arg2)) ? temp1 : temp2)
#define ufminimum(arg1, arg2) (((temp1=arg1) < (temp2=arg2)) ? temp1 : temp2)

static PyObject *_Error;

/*********************  minus  *********************/
/*********************  add  *********************/
/*********************  subtract  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  divide  *********************/
/*********************  divide  *********************/
/*********************  floor_divide  *********************/
/*********************  floor_divide  *********************/
/*********************  true_divide  *********************/
/*********************  true_divide  *********************/
/*********************  remainder  *********************/
/*********************  remainder  *********************/
/*********************  power  *********************/
/*********************  abs  *********************/
/*********************  sin  *********************/
/*********************  cos  *********************/
/*********************  tan  *********************/
/*********************  arcsin  *********************/
/*********************  arccos  *********************/
/*********************  arctan  *********************/
/*********************  arctan2  *********************/
/*********************  log  *********************/
/*********************  log10  *********************/
/*********************  exp  *********************/
/*********************  sinh  *********************/
/*********************  cosh  *********************/
/*********************  tanh  *********************/
/*********************  arcsinh  *********************/
/*********************  arccosh  *********************/
/*********************  arctanh  *********************/
/*********************  ieeemask  *********************/
/*********************  ieeemask  *********************/
/*********************  sqrt  *********************/
/*********************  equal  *********************/
/*********************  not_equal  *********************/
/*********************  greater  *********************/
/*********************  greater_equal  *********************/
/*********************  less  *********************/
/*********************  less_equal  *********************/
/*********************  logical_and  *********************/
/*********************  logical_or  *********************/
/*********************  logical_xor  *********************/
/*********************  logical_not  *********************/
/*********************  bitwise_and  *********************/
/*********************  bitwise_or  *********************/
/*********************  bitwise_xor  *********************/
/*********************  bitwise_not  *********************/
/*********************  rshift  *********************/
/*********************  lshift  *********************/
/*********************  floor  *********************/
/*********************  floor  *********************/
/*********************  ceil  *********************/
/*********************  ceil  *********************/
/*********************  maximum  *********************/
/*********************  minimum  *********************/
/*********************  fabs  *********************/
/*********************  _round  *********************/
/*********************  hypot  *********************/
/*********************  minus  *********************/

static int minus_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CMINUS(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(minus_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  add  *********************/

static int add_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CADD(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(add_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int add_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Complex64 *tout    = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CADD(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(add_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int add_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CADD(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(add_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int add_Complex64_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64 *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout = (Complex64 *) ((char *) output + outboffset);
    Complex64 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex64 *) ((char *) tout + outbstrides[dim]);
            NUM_CADD(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            add_Complex64_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(add_Complex64_accumulate, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));

static int add_Complex64_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64  *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout  = (Complex64 *) ((char *) output + outboffset);
    Complex64 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            NUM_CADD(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            add_Complex64_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(add_Complex64_reduce, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));
/*********************  subtract  *********************/

static int subtract_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CSUB(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(subtract_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int subtract_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Complex64 *tout    = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CSUB(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(subtract_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int subtract_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CSUB(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(subtract_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int subtract_Complex64_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64 *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout = (Complex64 *) ((char *) output + outboffset);
    Complex64 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex64 *) ((char *) tout + outbstrides[dim]);
            NUM_CSUB(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            subtract_Complex64_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(subtract_Complex64_accumulate, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));

static int subtract_Complex64_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64  *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout  = (Complex64 *) ((char *) output + outboffset);
    Complex64 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            NUM_CSUB(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            subtract_Complex64_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(subtract_Complex64_reduce, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));
/*********************  multiply  *********************/

static int multiply_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CMUL(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(multiply_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int multiply_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Complex64 *tout    = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CMUL(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(multiply_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int multiply_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CMUL(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(multiply_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int multiply_Complex64_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64 *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout = (Complex64 *) ((char *) output + outboffset);
    Complex64 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex64 *) ((char *) tout + outbstrides[dim]);
            NUM_CMUL(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            multiply_Complex64_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(multiply_Complex64_accumulate, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));

static int multiply_Complex64_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64  *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout  = (Complex64 *) ((char *) output + outboffset);
    Complex64 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            NUM_CMUL(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            multiply_Complex64_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(multiply_Complex64_reduce, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));
/*********************  divide  *********************/

static int divide_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CDIV(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(divide_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int divide_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Complex64 *tout    = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CDIV(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(divide_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int divide_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CDIV(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(divide_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int divide_Complex64_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64 *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout = (Complex64 *) ((char *) output + outboffset);
    Complex64 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex64 *) ((char *) tout + outbstrides[dim]);
            NUM_CDIV(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            divide_Complex64_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(divide_Complex64_accumulate, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));

static int divide_Complex64_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64  *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout  = (Complex64 *) ((char *) output + outboffset);
    Complex64 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            NUM_CDIV(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            divide_Complex64_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(divide_Complex64_reduce, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));
/*********************  true_divide  *********************/

static int true_divide_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CDIV(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(true_divide_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int true_divide_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Complex64 *tout    = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CDIV(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(true_divide_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int true_divide_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CDIV(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(true_divide_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int true_divide_Complex64_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64 *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout = (Complex64 *) ((char *) output + outboffset);
    Complex64 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex64 *) ((char *) tout + outbstrides[dim]);
            NUM_CDIV(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            true_divide_Complex64_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(true_divide_Complex64_accumulate, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));

static int true_divide_Complex64_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64  *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout  = (Complex64 *) ((char *) output + outboffset);
    Complex64 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            NUM_CDIV(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            true_divide_Complex64_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(true_divide_Complex64_reduce, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));
/*********************  remainder  *********************/

static int remainder_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CREM(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(remainder_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int remainder_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Complex64 *tout    = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CREM(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(remainder_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int remainder_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CREM(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(remainder_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int remainder_Complex64_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64 *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout = (Complex64 *) ((char *) output + outboffset);
    Complex64 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex64 *) ((char *) tout + outbstrides[dim]);
            NUM_CREM(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            remainder_Complex64_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(remainder_Complex64_accumulate, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));

static int remainder_Complex64_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64  *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout  = (Complex64 *) ((char *) output + outboffset);
    Complex64 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            NUM_CREM(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            remainder_Complex64_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(remainder_Complex64_reduce, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));
/*********************  power  *********************/

static int power_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CPOW(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(power_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int power_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Complex64 *tout    = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CPOW(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(power_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int power_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CPOW(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(power_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int power_Complex64_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64 *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout = (Complex64 *) ((char *) output + outboffset);
    Complex64 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex64 *) ((char *) tout + outbstrides[dim]);
            NUM_CPOW(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            power_Complex64_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(power_Complex64_accumulate, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));

static int power_Complex64_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64  *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout  = (Complex64 *) ((char *) output + outboffset);
    Complex64 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            NUM_CPOW(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            power_Complex64_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(power_Complex64_reduce, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));
/*********************  abs  *********************/

static int abs_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = NUM_CABS(*tin);
    }
    return 0;
}

UFUNC_DESCR2(abs_Complex64_vector, sizeof(Complex64), sizeof(Float64));
/*********************  sin  *********************/

static int sin_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CSIN(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(sin_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  cos  *********************/

static int cos_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CCOS(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(cos_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  tan  *********************/

static int tan_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CTAN(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(tan_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  arcsin  *********************/

static int arcsin_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CASIN(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(arcsin_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  arccos  *********************/

static int arccos_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CACOS(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(arccos_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  arctan  *********************/

static int arctan_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CATAN(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(arctan_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  arcsinh  *********************/

static int arcsinh_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CASINH(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(arcsinh_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  arccosh  *********************/

static int arccosh_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CACOSH(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(arccosh_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  arctanh  *********************/

static int arctanh_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CATANH(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(arctanh_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  log  *********************/

static int log_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CLOG(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(log_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  log10  *********************/

static int log10_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CLOG10(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(log10_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  exp  *********************/

static int exp_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CEXP(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(exp_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  sinh  *********************/

static int sinh_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CSINH(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(sinh_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  cosh  *********************/

static int cosh_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CCOSH(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(cosh_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  tanh  *********************/

static int tanh_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CTANH(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(tanh_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  sqrt  *********************/

static int sqrt_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CSQRT(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(sqrt_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  equal  *********************/

static int equal_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = NUM_CEQ(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(equal_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));


static int equal_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = NUM_CEQ(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(equal_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));


static int equal_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = NUM_CEQ(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(equal_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));

/*********************  not_equal  *********************/

static int not_equal_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = NUM_CNE(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(not_equal_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));


static int not_equal_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = NUM_CNE(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(not_equal_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));


static int not_equal_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = NUM_CNE(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(not_equal_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));

/*********************  logical_and  *********************/

static int logical_and_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = NUM_CLAND(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_and_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));


static int logical_and_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = NUM_CLAND(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_and_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));


static int logical_and_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = NUM_CLAND(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_and_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));

/*********************  logical_or  *********************/

static int logical_or_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = NUM_CLOR(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_or_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));


static int logical_or_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = NUM_CLOR(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_or_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));


static int logical_or_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = NUM_CLOR(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_or_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));

/*********************  logical_xor  *********************/

static int logical_xor_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = NUM_CLXOR(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_xor_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));


static int logical_xor_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = NUM_CLXOR(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_xor_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));


static int logical_xor_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = NUM_CLXOR(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_xor_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Bool));

/*********************  logical_not  *********************/

static int logical_not_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Bool *tout = (Bool *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = NUM_CLNOT(*tin);
    }
    return 0;
}

UFUNC_DESCR2(logical_not_Complex64_vector, sizeof(Complex64), sizeof(Bool));
/*********************  floor  *********************/

static int floor_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CFLOOR(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(floor_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  ceil  *********************/

static int ceil_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CCEIL(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(ceil_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  maximum  *********************/

static int maximum_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = NUM_CMAX(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(maximum_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int maximum_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Complex64 *tout    = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = NUM_CMAX(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(maximum_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int maximum_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = NUM_CMAX(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(maximum_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int maximum_Complex64_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64 *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout = (Complex64 *) ((char *) output + outboffset);
    Complex64 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex64 *) ((char *) tout + outbstrides[dim]);
            *tout = NUM_CMAX(lastval ,*tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            maximum_Complex64_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(maximum_Complex64_accumulate, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));

static int maximum_Complex64_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64  *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout  = (Complex64 *) ((char *) output + outboffset);
    Complex64 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            net = NUM_CMAX(net, *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            maximum_Complex64_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(maximum_Complex64_reduce, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));
/*********************  minimum  *********************/

static int minimum_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = NUM_CMIN(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(minimum_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int minimum_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Complex64 *tout    = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = NUM_CMIN(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(minimum_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int minimum_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = NUM_CMIN(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(minimum_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int minimum_Complex64_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64 *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout = (Complex64 *) ((char *) output + outboffset);
    Complex64 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex64 *) ((char *) tout + outbstrides[dim]);
            *tout = NUM_CMIN(lastval ,*tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            minimum_Complex64_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(minimum_Complex64_accumulate, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));

static int minimum_Complex64_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64  *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout  = (Complex64 *) ((char *) output + outboffset);
    Complex64 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            net = NUM_CMIN(net, *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            minimum_Complex64_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(minimum_Complex64_reduce, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));
/*********************  fabs  *********************/

static int fabs_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CFABS(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(fabs_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  _round  *********************/

static int _round_Complex64_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin = (Complex64 *) buffers[0];
    Complex64 *tout = (Complex64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        NUM_CROUND(*tin, *tout);
    }
    return 0;
}

UFUNC_DESCR2(_round_Complex64_vector, sizeof(Complex64), sizeof(Complex64));
/*********************  hypot  *********************/

static int hypot_Complex64_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64  *tin1  = (Complex64 *) buffers[0];
    Complex64  *tin2  = (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        NUM_CHYPOT(*tin1, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3(hypot_Complex64_vector_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int hypot_Complex64_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 *tin1     = (Complex64 *) buffers[0];
    Complex64 tscalar   = *(Complex64 *) buffers[1];
    Complex64 *tout    = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        NUM_CHYPOT(*tin1, tscalar, *tout);
    }
    return 0;
}

UFUNC_DESCR3vs(hypot_Complex64_vector_scalar, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int hypot_Complex64_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Complex64 tscalar = *(Complex64 *) buffers[0];
    Complex64 *tin2   =  (Complex64 *) buffers[1];
    Complex64 *tout  = (Complex64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        NUM_CHYPOT(tscalar, *tin2, *tout);
    }
    return 0;
}

UFUNC_DESCR3sv(hypot_Complex64_scalar_vector, sizeof(Complex64), sizeof(Complex64), sizeof(Complex64));


static int hypot_Complex64_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64 *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout = (Complex64 *) ((char *) output + outboffset);
    Complex64 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            tout = (Complex64 *) ((char *) tout + outbstrides[dim]);
            NUM_CHYPOT(lastval ,*tin, *tout);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            hypot_Complex64_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(hypot_Complex64_accumulate, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));

static int hypot_Complex64_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Complex64  *tin   = (Complex64 *) ((char *) input  + inboffset);
    Complex64 *tout  = (Complex64 *) ((char *) output + outboffset);
    Complex64 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Complex64 *) ((char *) tin + inbstrides[dim]);
            NUM_CHYPOT(net, *tin, net);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            hypot_Complex64_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(hypot_Complex64_reduce, CHECK_ALIGN, sizeof(Complex64), sizeof(Complex64));

static PyMethodDef _ufuncComplex64Methods[] = {

	{NULL,      NULL}        /* Sentinel */
};

static PyObject *init_funcDict(void) {
    PyObject *dict;
    dict = PyDict_New();
    NA_add_cfunc(dict, "('minus', 'vector', (('Complex64',), ('Complex64',)))", (void *) &minus_Complex64_vector_descr);
    NA_add_cfunc(dict, "('add', 'vector_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &add_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('add', 'vector_scalar', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &add_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('add', 'scalar_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &add_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('add', 'reduce', (('Complex64',), ('Complex64',)))", (void *) &add_Complex64_reduce_descr);
    NA_add_cfunc(dict, "('add', 'accumulate', (('Complex64',), ('Complex64',)))", (void *) &add_Complex64_accumulate_descr);
    NA_add_cfunc(dict, "('subtract', 'vector_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &subtract_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('subtract', 'vector_scalar', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &subtract_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('subtract', 'scalar_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &subtract_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('subtract', 'reduce', (('Complex64',), ('Complex64',)))", (void *) &subtract_Complex64_reduce_descr);
    NA_add_cfunc(dict, "('subtract', 'accumulate', (('Complex64',), ('Complex64',)))", (void *) &subtract_Complex64_accumulate_descr);
    NA_add_cfunc(dict, "('multiply', 'vector_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &multiply_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('multiply', 'vector_scalar', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &multiply_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('multiply', 'scalar_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &multiply_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('multiply', 'reduce', (('Complex64',), ('Complex64',)))", (void *) &multiply_Complex64_reduce_descr);
    NA_add_cfunc(dict, "('multiply', 'accumulate', (('Complex64',), ('Complex64',)))", (void *) &multiply_Complex64_accumulate_descr);
    NA_add_cfunc(dict, "('divide', 'vector_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &divide_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('divide', 'vector_scalar', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &divide_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('divide', 'scalar_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &divide_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('divide', 'reduce', (('Complex64',), ('Complex64',)))", (void *) &divide_Complex64_reduce_descr);
    NA_add_cfunc(dict, "('divide', 'accumulate', (('Complex64',), ('Complex64',)))", (void *) &divide_Complex64_accumulate_descr);
    NA_add_cfunc(dict, "('true_divide', 'vector_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &true_divide_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('true_divide', 'vector_scalar', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &true_divide_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('true_divide', 'scalar_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &true_divide_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('true_divide', 'reduce', (('Complex64',), ('Complex64',)))", (void *) &true_divide_Complex64_reduce_descr);
    NA_add_cfunc(dict, "('true_divide', 'accumulate', (('Complex64',), ('Complex64',)))", (void *) &true_divide_Complex64_accumulate_descr);
    NA_add_cfunc(dict, "('remainder', 'vector_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &remainder_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('remainder', 'vector_scalar', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &remainder_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('remainder', 'scalar_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &remainder_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('remainder', 'reduce', (('Complex64',), ('Complex64',)))", (void *) &remainder_Complex64_reduce_descr);
    NA_add_cfunc(dict, "('remainder', 'accumulate', (('Complex64',), ('Complex64',)))", (void *) &remainder_Complex64_accumulate_descr);
    NA_add_cfunc(dict, "('power', 'vector_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &power_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('power', 'vector_scalar', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &power_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('power', 'scalar_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &power_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('power', 'reduce', (('Complex64',), ('Complex64',)))", (void *) &power_Complex64_reduce_descr);
    NA_add_cfunc(dict, "('power', 'accumulate', (('Complex64',), ('Complex64',)))", (void *) &power_Complex64_accumulate_descr);
    NA_add_cfunc(dict, "('abs', 'vector', (('Complex64',), ('Float64',)))", (void *) &abs_Complex64_vector_descr);
    NA_add_cfunc(dict, "('sin', 'vector', (('Complex64',), ('Complex64',)))", (void *) &sin_Complex64_vector_descr);
    NA_add_cfunc(dict, "('cos', 'vector', (('Complex64',), ('Complex64',)))", (void *) &cos_Complex64_vector_descr);
    NA_add_cfunc(dict, "('tan', 'vector', (('Complex64',), ('Complex64',)))", (void *) &tan_Complex64_vector_descr);
    NA_add_cfunc(dict, "('arcsin', 'vector', (('Complex64',), ('Complex64',)))", (void *) &arcsin_Complex64_vector_descr);
    NA_add_cfunc(dict, "('arccos', 'vector', (('Complex64',), ('Complex64',)))", (void *) &arccos_Complex64_vector_descr);
    NA_add_cfunc(dict, "('arctan', 'vector', (('Complex64',), ('Complex64',)))", (void *) &arctan_Complex64_vector_descr);
    NA_add_cfunc(dict, "('arcsinh', 'vector', (('Complex64',), ('Complex64',)))", (void *) &arcsinh_Complex64_vector_descr);
    NA_add_cfunc(dict, "('arccosh', 'vector', (('Complex64',), ('Complex64',)))", (void *) &arccosh_Complex64_vector_descr);
    NA_add_cfunc(dict, "('arctanh', 'vector', (('Complex64',), ('Complex64',)))", (void *) &arctanh_Complex64_vector_descr);
    NA_add_cfunc(dict, "('log', 'vector', (('Complex64',), ('Complex64',)))", (void *) &log_Complex64_vector_descr);
    NA_add_cfunc(dict, "('log10', 'vector', (('Complex64',), ('Complex64',)))", (void *) &log10_Complex64_vector_descr);
    NA_add_cfunc(dict, "('exp', 'vector', (('Complex64',), ('Complex64',)))", (void *) &exp_Complex64_vector_descr);
    NA_add_cfunc(dict, "('sinh', 'vector', (('Complex64',), ('Complex64',)))", (void *) &sinh_Complex64_vector_descr);
    NA_add_cfunc(dict, "('cosh', 'vector', (('Complex64',), ('Complex64',)))", (void *) &cosh_Complex64_vector_descr);
    NA_add_cfunc(dict, "('tanh', 'vector', (('Complex64',), ('Complex64',)))", (void *) &tanh_Complex64_vector_descr);
    NA_add_cfunc(dict, "('sqrt', 'vector', (('Complex64',), ('Complex64',)))", (void *) &sqrt_Complex64_vector_descr);
    NA_add_cfunc(dict, "('equal', 'vector_vector', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &equal_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('equal', 'vector_scalar', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &equal_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('equal', 'scalar_vector', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &equal_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('not_equal', 'vector_vector', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &not_equal_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('not_equal', 'vector_scalar', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &not_equal_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('not_equal', 'scalar_vector', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &not_equal_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_and', 'vector_vector', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &logical_and_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_and', 'vector_scalar', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &logical_and_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_and', 'scalar_vector', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &logical_and_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_or', 'vector_vector', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &logical_or_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_or', 'vector_scalar', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &logical_or_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_or', 'scalar_vector', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &logical_or_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_xor', 'vector_vector', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &logical_xor_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_xor', 'vector_scalar', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &logical_xor_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_xor', 'scalar_vector', (('Complex64', 'Complex64'), ('Bool',)))", (void *) &logical_xor_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_not', 'vector', (('Complex64',), ('Bool',)))", (void *) &logical_not_Complex64_vector_descr);
    NA_add_cfunc(dict, "('floor', 'vector', (('Complex64',), ('Complex64',)))", (void *) &floor_Complex64_vector_descr);
    NA_add_cfunc(dict, "('ceil', 'vector', (('Complex64',), ('Complex64',)))", (void *) &ceil_Complex64_vector_descr);
    NA_add_cfunc(dict, "('maximum', 'vector_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &maximum_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('maximum', 'vector_scalar', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &maximum_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('maximum', 'scalar_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &maximum_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('maximum', 'reduce', (('Complex64',), ('Complex64',)))", (void *) &maximum_Complex64_reduce_descr);
    NA_add_cfunc(dict, "('maximum', 'accumulate', (('Complex64',), ('Complex64',)))", (void *) &maximum_Complex64_accumulate_descr);
    NA_add_cfunc(dict, "('minimum', 'vector_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &minimum_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('minimum', 'vector_scalar', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &minimum_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('minimum', 'scalar_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &minimum_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('minimum', 'reduce', (('Complex64',), ('Complex64',)))", (void *) &minimum_Complex64_reduce_descr);
    NA_add_cfunc(dict, "('minimum', 'accumulate', (('Complex64',), ('Complex64',)))", (void *) &minimum_Complex64_accumulate_descr);
    NA_add_cfunc(dict, "('fabs', 'vector', (('Complex64',), ('Complex64',)))", (void *) &fabs_Complex64_vector_descr);
    NA_add_cfunc(dict, "('_round', 'vector', (('Complex64',), ('Complex64',)))", (void *) &_round_Complex64_vector_descr);
    NA_add_cfunc(dict, "('hypot', 'vector_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &hypot_Complex64_vector_vector_descr);
    NA_add_cfunc(dict, "('hypot', 'vector_scalar', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &hypot_Complex64_vector_scalar_descr);
    NA_add_cfunc(dict, "('hypot', 'scalar_vector', (('Complex64', 'Complex64'), ('Complex64',)))", (void *) &hypot_Complex64_scalar_vector_descr);
    NA_add_cfunc(dict, "('hypot', 'reduce', (('Complex64',), ('Complex64',)))", (void *) &hypot_Complex64_reduce_descr);
    NA_add_cfunc(dict, "('hypot', 'accumulate', (('Complex64',), ('Complex64',)))", (void *) &hypot_Complex64_accumulate_descr);
    return dict;
}

/* platform independent*/
#ifdef MS_WIN32
__declspec(dllexport)
#endif
void init_ufuncComplex64(void) {
    PyObject *m, *d;
    m = Py_InitModule("_ufuncComplex64", _ufuncComplex64Methods);
    d = PyModule_GetDict(m);
    _Error = PyErr_NewException("_ufuncComplex64.error", NULL, NULL);
    PyDict_SetItemString(d, "error", _Error);
    import_libnumarray();
    PyDict_SetItemString(d, "functionDict", init_funcDict());
}
