/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.python.compiler.Code;

class Label {
    int position;
    int[] offsets;
    int[] positions;
    int[] sizes;
    int noffsets;
    Code code;
    int stack;

    public void fix(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if (this.noffsets > 0 && this.position == -1) {
            throw new InternalError("position never set for label");
        }
        int n = 0;
        while (n < this.noffsets) {
            int n2 = this.position - this.offsets[n];
            int n3 = this.positions[n];
            if (this.sizes[n] == 2) {
                dataOutputStream.writeShort(n2);
            } else {
                dataOutputStream.writeInt(n2);
            }
            System.arraycopy(byteArrayOutputStream.toByteArray(), 0, byArray, n3, this.sizes[n]);
            byteArrayOutputStream.reset();
            ++n;
        }
    }

    public void setStack(int n) {
        if (this.stack == -1) {
            this.stack = n;
        } else if (this.stack != n) {
            throw new InternalError("stack sizes don't agree: " + this.stack + ", " + n);
        }
    }

    public int getPosition() {
        if (this.position == -1) {
            throw new InternalError("position never set for label");
        }
        return this.position;
    }

    public void setPosition() {
        this.position = this.code.size();
    }

    public void setBranch(int n, int n2) throws IOException {
        if (this.noffsets >= this.offsets.length) {
            int[] nArray = new int[this.offsets.length * 2];
            System.arraycopy(this.offsets, 0, nArray, 0, this.noffsets);
            this.offsets = nArray;
            int[] nArray2 = new int[this.positions.length * 2];
            System.arraycopy(this.positions, 0, nArray2, 0, this.noffsets);
            this.positions = nArray2;
            int[] nArray3 = new int[this.sizes.length * 2];
            System.arraycopy(this.sizes, 0, nArray3, 0, this.noffsets);
            this.sizes = nArray3;
        }
        this.positions[this.noffsets] = this.code.size();
        this.offsets[this.noffsets] = n;
        this.sizes[this.noffsets] = n2;
        ++this.noffsets;
        if (n2 == 2) {
            this.code.code.writeShort(0);
        } else {
            this.code.code.writeInt(0);
        }
    }

    public Label(Code code) {
        this.code = code;
        this.position = -1;
        this.noffsets = 0;
        this.offsets = new int[4];
        this.positions = new int[4];
        this.sizes = new int[4];
        this.stack = -1;
    }
}

