/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;

public class PyFile
extends PyObject {
    public String name;
    public String mode;
    public boolean softspace;
    public boolean closed;
    private FileWrapper file;
    private static /* synthetic */ Class class$Ljava$io$InputStream;
    private static /* synthetic */ Class class$Ljava$io$OutputStream;

    private static InputStream _pb(InputStream inputStream, String string) {
        if (string.indexOf(98) < 0) {
            try {
                inputStream = (PushbackInputStream)inputStream;
            }
            catch (ClassCastException classCastException) {
                inputStream = new PushbackInputStream(inputStream);
            }
        }
        return inputStream;
    }

    public void __setattr__(String string, PyObject pyObject) {
        if (string != "softspace") {
            if (string == "mode" || string == "closed" || string == "name") {
                throw Py.TypeError("readonly attribute: " + string);
            }
            throw Py.AttributeError(string);
        }
        this.softspace = pyObject.__nonzero__();
    }

    public Object __tojava__(Class clazz) {
        Object object = null;
        try {
            object = this.file.__tojava__(clazz);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (object == null) {
            object = super.__tojava__(clazz);
        }
        return object;
    }

    private static FileWrapper _setup(String string, String string2, int n) {
        int n2 = 32;
        int n3 = 32;
        int n4 = 32;
        int n5 = string2.length();
        if (n5 > 0) {
            n2 = string2.charAt(0);
            if (n5 > 1) {
                n3 = string2.charAt(1);
                if (n5 > 2) {
                    n4 = string2.charAt(2);
                }
            }
        }
        String string3 = "r";
        if (n2 == 114) {
            string3 = n3 == 43 || n4 == 43 ? "rw" : "r";
        } else if (n2 == 119 || n2 == 97) {
            string3 = "rw";
        }
        try {
            Closeable closeable;
            File file = new File(string);
            if (n2 == 119) {
                closeable = new FileOutputStream(file);
                ((FileOutputStream)closeable).close();
                closeable = null;
            }
            closeable = new RandomAccessFile(file, string3);
            if (n2 == 97) {
                ((RandomAccessFile)closeable).seek(((RandomAccessFile)closeable).length());
            }
            RFileWrapper rFileWrapper = new RFileWrapper((RandomAccessFile)closeable);
            return rFileWrapper;
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public PyString read(int n) {
        if (this.closed) {
            this.err_closed();
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (n != 0) {
                String string = this.file.read(n);
                int n2 = string.length();
                if (n2 != 0) {
                    stringBuffer.append(string);
                    if (n <= 0 || (n -= n2) > 0) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        return new PyString(stringBuffer.toString());
    }

    public PyString read() {
        return this.read(-1);
    }

    public PyString readline(int n) {
        if (this.closed) {
            this.err_closed();
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n < 0 || stringBuffer.length() < n) {
            int n2;
            try {
                n2 = this.file.read();
            }
            catch (IOException iOException) {
                throw Py.IOError(iOException);
            }
            if (n2 < 0) break;
            stringBuffer.append((char)n2);
            if ((char)n2 == '\n') break;
        }
        return new PyString(stringBuffer.toString());
    }

    public PyString readline() {
        return this.readline(-1);
    }

    public PyObject readlines(int n) {
        PyString pyString;
        int n2;
        if (this.closed) {
            this.err_closed();
        }
        PyList pyList = new PyList();
        int n3 = 0;
        while ((n2 = (pyString = this.readline()).__len__()) != 0) {
            pyList.append(pyString);
            if (n <= 0 || (n3 += n2) <= n) continue;
            break;
        }
        return pyList;
    }

    public PyObject readlines() {
        return this.readlines(0);
    }

    public void write(String string) {
        if (this.closed) {
            this.err_closed();
        }
        try {
            this.file.write(string);
            this.softspace = false;
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public void writelines(PyObject pyObject) {
        PyObject pyObject2 = null;
        int n = 0;
        while ((pyObject2 = pyObject.__finditem__(n)) != null) {
            if (!(pyObject2 instanceof PyString)) {
                throw Py.TypeError("writelines() argument must be a sequence of strings");
            }
            this.write(pyObject2.toString());
            ++n;
        }
    }

    public long tell() {
        if (this.closed) {
            this.err_closed();
        }
        try {
            return this.file.tell();
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public void seek(long l, int n) {
        if (this.closed) {
            this.err_closed();
        }
        try {
            this.file.seek(l, n);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public void seek(long l) {
        this.seek(l, 0);
    }

    public void flush() {
        if (this.closed) {
            this.err_closed();
        }
        try {
            this.file.flush();
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public void close() {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        this.closed = true;
        this.file = new FileWrapper();
    }

    public PyObject fileno() {
        throw Py.IOError("fileno() is not supported in jpython");
    }

    public String toString() {
        return "<file " + this.name + ", mode " + this.mode + " at " + Py.id(this) + ">";
    }

    private void err_closed() {
        throw Py.ValueError("I/O operation on closed file");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PyFile(FileWrapper fileWrapper, String string, String string2) {
        fileWrapper.setMode(string2);
        this.name = string;
        this.mode = string2;
        this.softspace = false;
        this.closed = false;
        this.file = string2.indexOf(98) < 0 ? new TextWrapper(fileWrapper) : fileWrapper;
    }

    public PyFile(InputStream inputStream, OutputStream outputStream, String string, String string2) {
        this(new IOStreamWrapper(PyFile._pb(inputStream, string2), outputStream), string, string2);
    }

    public PyFile(InputStream inputStream, OutputStream outputStream, String string) {
        this(inputStream, outputStream, string, "r+");
    }

    public PyFile(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, "<???>", "r+");
    }

    public PyFile(InputStream inputStream, String string, String string2) {
        this(new InputStreamWrapper(PyFile._pb(inputStream, string2)), string, string2);
    }

    public PyFile(InputStream inputStream, String string) {
        this(inputStream, string, "r");
    }

    public PyFile(InputStream inputStream) {
        this(inputStream, "<???>", "r");
    }

    public PyFile(OutputStream outputStream, String string, String string2) {
        this(new OutputStreamWrapper(outputStream), string, string2);
    }

    public PyFile(OutputStream outputStream, String string) {
        this(outputStream, string, "w");
    }

    public PyFile(OutputStream outputStream) {
        this(outputStream, "<???>", "w");
    }

    public PyFile(Writer writer, String string, String string2) {
        this(new WriterWrapper(writer), string, string2);
    }

    public PyFile(Writer writer, String string) {
        this(writer, string, "w");
    }

    public PyFile(Writer writer) {
        this(writer, "<???>", "w");
    }

    public PyFile(RandomAccessFile randomAccessFile, String string, String string2) {
        this(new RFileWrapper(randomAccessFile), string, string2);
    }

    public PyFile(RandomAccessFile randomAccessFile, String string) {
        this(randomAccessFile, string, "r+");
    }

    public PyFile(RandomAccessFile randomAccessFile) {
        this(randomAccessFile, "<???>", "r+");
    }

    public PyFile(String string, String string2, int n) {
        this(PyFile._setup(string, string2, n), string, string2);
    }

    private static class FileWrapper {
        protected boolean reading;
        protected boolean writing;
        protected boolean binary;

        void setMode(String string) {
            this.reading = string.indexOf(114) >= 0;
            this.writing = string.indexOf(119) >= 0 || string.indexOf("+") >= 0 || string.indexOf(97) >= 0;
            this.binary = string.indexOf(98) >= 0;
        }

        public String read(int n) throws IOException {
            throw new IOException("file not open for reading");
        }

        public int read() throws IOException {
            throw new IOException("file not open for reading");
        }

        public int available() throws IOException {
            throw new IOException("file not open for reading");
        }

        public void unread(int n) throws IOException {
            throw new IOException("file doesn't support unread");
        }

        public void write(String string) throws IOException {
            throw new IOException("file not open for writing");
        }

        public long tell() throws IOException {
            throw new IOException("file doesn't support tell/seek");
        }

        public void seek(long l, int n) throws IOException {
            throw new IOException("file doesn't support tell/seek");
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public Object __tojava__(Class clazz) throws IOException {
            return null;
        }

        protected byte[] getBytes(String string) {
            if (this.binary) {
                byte[] byArray = new byte[string.length()];
                string.getBytes(0, string.length(), byArray, 0);
                return byArray;
            }
            return string.getBytes();
        }

        protected String getString(byte[] byArray, int n, int n2) {
            if (this.binary) {
                return new String(byArray, 0, n, n2);
            }
            return new String(byArray, n, n2);
        }

        FileWrapper() {
        }
    }

    private static class InputStreamWrapper
    extends FileWrapper {
        InputStream istream;

        public String read(int n) throws IOException {
            if (n == 0) {
                return "";
            }
            if (n < 0) {
                byte[] byArray = new byte[1024];
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 >= 0) {
                    stringBuffer.append(this.getString(byArray, 0, n2));
                    n2 = this.istream.read(byArray);
                }
                return stringBuffer.toString();
            }
            int n3 = this.istream.available();
            byte[] byArray = new byte[n];
            int n4 = this.istream.read(byArray);
            if (n4 < 0) {
                return "";
            }
            return new String(byArray, 0, 0, n4);
        }

        public int read() throws IOException {
            return this.istream.read();
        }

        public int available() throws IOException {
            return this.istream.available();
        }

        public void unread(int n) throws IOException {
            ((PushbackInputStream)this.istream).unread(n);
        }

        public void close() throws IOException {
            this.istream.close();
        }

        public Object __tojava__(Class clazz) throws IOException {
            Class clazz2;
            if (class$Ljava$io$InputStream != null) {
                clazz2 = class$Ljava$io$InputStream;
            } else {
                Class clazz3 = PyFile.class$("java.io.InputStream");
                clazz2 = clazz3;
                class$Ljava$io$InputStream = clazz3;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return this.istream;
            }
            return null;
        }

        public InputStreamWrapper(InputStream inputStream) {
            this.istream = inputStream;
        }
    }

    private static class OutputStreamWrapper
    extends FileWrapper {
        private static final int MAX_WRITE = 30000;
        private OutputStream ostream;

        public void write(String string) throws IOException {
            byte[] byArray = this.getBytes(string);
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n - n2;
                n3 = n3 > 30000 ? 30000 : n3;
                this.ostream.write(byArray, n2, n3);
                n2 += n3;
            }
        }

        public void flush() throws IOException {
            this.ostream.flush();
        }

        public void close() throws IOException {
            this.ostream.close();
        }

        public Object __tojava__(Class clazz) throws IOException {
            Class clazz2;
            if (class$Ljava$io$OutputStream != null) {
                clazz2 = class$Ljava$io$OutputStream;
            } else {
                Class clazz3 = PyFile.class$("java.io.OutputStream");
                clazz2 = clazz3;
                class$Ljava$io$OutputStream = clazz3;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return this.ostream;
            }
            return null;
        }

        public OutputStreamWrapper(OutputStream outputStream) {
            this.ostream = outputStream;
        }
    }

    private static class IOStreamWrapper
    extends InputStreamWrapper {
        private OutputStream ostream;

        public void write(String string) throws IOException {
            this.ostream.write(this.getBytes(string));
        }

        public void flush() throws IOException {
            this.ostream.flush();
        }

        public void close() throws IOException {
            this.ostream.close();
            this.istream.close();
        }

        public Object __tojava__(Class clazz) throws IOException {
            Class clazz2;
            if (class$Ljava$io$OutputStream != null) {
                clazz2 = class$Ljava$io$OutputStream;
            } else {
                Class clazz3 = PyFile.class$("java.io.OutputStream");
                clazz2 = clazz3;
                class$Ljava$io$OutputStream = clazz3;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return this.ostream;
            }
            return super.__tojava__(clazz);
        }

        public IOStreamWrapper(InputStream inputStream, OutputStream outputStream) {
            super(inputStream);
            this.ostream = outputStream;
        }
    }

    private static class WriterWrapper
    extends FileWrapper {
        private static final int MAX_WRITE = 30000;
        private Writer writer;

        public void write(String string) throws IOException {
            this.writer.write(string);
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        public void close() throws IOException {
            this.writer.close();
        }

        public WriterWrapper(Writer writer) {
            this.writer = writer;
        }
    }

    private static class RFileWrapper
    extends FileWrapper {
        protected static final int defaultBufferSize = 4096;
        protected RandomAccessFile file;
        protected long filePosition;
        protected byte[] buffer;
        protected long bufferStart;
        protected long dataEnd;
        protected int dataSize;
        protected boolean endOfFile;
        boolean bufferModified = false;

        public String read(int n) throws IOException {
            byte[] byArray;
            if (n < 0 && (n = (int)(this.file.length() - this.file.getFilePointer())) < 0) {
                n = 0;
            }
            if ((n = this.readBytes(byArray = new byte[n], 0, n)) < 0) {
                n = 0;
            }
            return this.getString(byArray, 0, n);
        }

        private int readBytes(byte[] byArray, int n, int n2) throws IOException {
            if (this.endOfFile) {
                return -1;
            }
            int n3 = (int)(this.dataEnd - this.filePosition);
            if (n3 < 1) {
                this.seek(this.filePosition, 0);
                return this.readBytes(byArray, n, n2);
            }
            int n4 = n3 >= n2 ? n2 : n3;
            System.arraycopy(this.buffer, (int)(this.filePosition - this.bufferStart), byArray, n, n4);
            this.filePosition += (long)n4;
            if (n4 < n2) {
                int n5 = n2 - n4;
                if (n5 > this.buffer.length) {
                    this.file.seek(this.filePosition);
                    n5 = this.file.read(byArray, n + n4, n2 - n4);
                } else {
                    this.seek(this.filePosition, 0);
                    if (!this.endOfFile) {
                        n5 = n5 > this.dataSize ? this.dataSize : n5;
                        System.arraycopy(this.buffer, 0, byArray, n + n4, n5);
                    } else {
                        n5 = -1;
                    }
                }
                if (n5 > 0) {
                    this.filePosition += (long)n5;
                    return n4 + n5;
                }
            }
            return n4;
        }

        public int read() throws IOException {
            if (this.filePosition < this.dataEnd) {
                return this.buffer[(int)(this.filePosition++ - this.bufferStart)] & 0xFF;
            }
            if (this.endOfFile) {
                return -1;
            }
            this.seek(this.filePosition, 0);
            return this.read();
        }

        public int available() throws IOException {
            return 1;
        }

        public void unread(int n) throws IOException {
            --this.filePosition;
        }

        public void write(String string) throws IOException {
            byte[] byArray = this.getBytes(string);
            int n = byArray.length;
            if (n < this.buffer.length) {
                long l;
                int n2 = 0;
                int n3 = 0;
                if (this.filePosition >= this.bufferStart) {
                    n2 = (int)(this.bufferStart + (long)this.buffer.length - this.filePosition);
                }
                if (n2 > 0) {
                    n3 = n2 > n ? n : n2;
                    System.arraycopy(byArray, 0, this.buffer, (int)(this.filePosition - this.bufferStart), n3);
                    this.bufferModified = true;
                    l = this.filePosition + (long)n3;
                    this.dataEnd = l > this.dataEnd ? l : this.dataEnd;
                    this.dataSize = (int)(this.dataEnd - this.bufferStart);
                    this.filePosition += (long)n3;
                }
                if (n3 < n) {
                    this.seek(this.filePosition, 0);
                    System.arraycopy(byArray, n3, this.buffer, (int)(this.filePosition - this.bufferStart), n - n3);
                    this.bufferModified = true;
                    l = this.filePosition + (long)(n - n3);
                    this.dataEnd = l > this.dataEnd ? l : this.dataEnd;
                    this.dataSize = (int)(this.dataEnd - this.bufferStart);
                    this.filePosition += (long)(n - n3);
                }
            } else {
                if (this.bufferModified) {
                    this.flush();
                    this.dataSize = 0;
                    this.bufferStart = this.dataEnd = (long)0;
                }
                this.file.write(byArray, 0, n);
                this.filePosition += (long)n;
            }
        }

        public long tell() throws IOException {
            return this.filePosition;
        }

        public void seek(long l, int n) throws IOException {
            if (n == 1) {
                l += this.file.getFilePointer();
            } else if (n == 2) {
                l += this.file.length();
            }
            if (l < 0L) {
                l = 0L;
            }
            if (l >= this.bufferStart && l < this.dataEnd) {
                this.filePosition = l;
                return;
            }
            if (this.bufferModified) {
                this.flush();
            }
            this.file.seek(l);
            this.bufferStart = this.filePosition = this.file.getFilePointer();
            this.dataSize = this.file.read(this.buffer);
            if (this.dataSize < 0) {
                this.dataSize = 0;
                this.endOfFile = true;
            } else {
                this.endOfFile = false;
            }
            this.dataEnd = this.bufferStart + (long)this.dataSize;
        }

        public void flush() throws IOException {
            this.file.seek(this.bufferStart);
            this.file.write(this.buffer, 0, this.dataSize);
            this.bufferModified = false;
            this.file.getFD().sync();
        }

        public void close() throws IOException {
            if (this.writing && this.bufferModified) {
                this.file.seek(this.bufferStart);
                this.file.write(this.buffer, 0, this.dataSize);
            }
            this.file.close();
        }

        public Object __tojava__(Class clazz) throws IOException {
            Class clazz2;
            Class clazz3;
            if (class$Ljava$io$OutputStream != null) {
                clazz3 = class$Ljava$io$OutputStream;
            } else {
                Class clazz4 = PyFile.class$("java.io.OutputStream");
                clazz3 = clazz4;
                class$Ljava$io$OutputStream = clazz4;
            }
            if (clazz3.isAssignableFrom(clazz) && this.writing) {
                return new FileOutputStream(this.file.getFD());
            }
            if (class$Ljava$io$InputStream != null) {
                clazz2 = class$Ljava$io$InputStream;
            } else {
                Class clazz5 = PyFile.class$("java.io.InputStream");
                clazz2 = clazz5;
                class$Ljava$io$InputStream = clazz5;
            }
            if (clazz2.isAssignableFrom(clazz) && this.reading) {
                return new FileInputStream(this.file.getFD());
            }
            return super.__tojava__(clazz);
        }

        public RFileWrapper(RandomAccessFile randomAccessFile) {
            this(randomAccessFile, 8092);
        }

        public RFileWrapper(RandomAccessFile randomAccessFile, int n) {
            this.file = randomAccessFile;
            this.bufferStart = 0L;
            this.dataEnd = 0L;
            this.dataSize = 0;
            this.filePosition = 0L;
            this.buffer = new byte[n];
            this.endOfFile = false;
        }
    }

    private static class TextWrapper
    extends FileWrapper {
        private FileWrapper file;
        private String sep;
        private boolean sep_is_nl;

        public String read(int n) throws IOException {
            int n2;
            String string = this.file.read(n);
            int n3 = string.indexOf(13);
            if (n3 < 0) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            int n5 = string.length();
            do {
                stringBuffer.append(string.substring(n4, n3));
                stringBuffer.append('\n');
                n4 = n3 + 1;
                if (n4 >= n5 || string.charAt(n4) != '\n') continue;
                ++n4;
            } while ((n3 = string.indexOf(13, n4)) >= 0);
            stringBuffer.append(string.substring(n4));
            if (string.endsWith("\r") && this.file.available() > 0 && (n2 = this.file.read()) != -1 && n2 != 10) {
                this.file.unread(n2);
            }
            return stringBuffer.toString();
        }

        public int read() throws IOException {
            int n = this.file.read();
            if (n != 13) {
                return n;
            }
            if (this.file.available() > 0 && (n = this.file.read()) != -1 && n != 10) {
                this.file.unread(n);
            }
            return 10;
        }

        public void write(String string) throws IOException {
            int n;
            if (!this.sep_is_nl && (n = string.indexOf(10)) >= 0) {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                do {
                    stringBuffer.append(string.substring(n2, n));
                    stringBuffer.append(this.sep);
                } while ((n = string.indexOf(10, n2 = n + 1)) >= 0);
                stringBuffer.append(string.substring(n2));
                string = stringBuffer.toString();
            }
            this.file.write(string);
        }

        public long tell() throws IOException {
            return this.file.tell();
        }

        public void seek(long l, int n) throws IOException {
            this.file.seek(l, n);
        }

        public void flush() throws IOException {
            this.file.flush();
        }

        public void close() throws IOException {
            this.file.close();
        }

        public Object __tojava__(Class clazz) throws IOException {
            return this.file.__tojava__(clazz);
        }

        public TextWrapper(FileWrapper fileWrapper) {
            this.file = fileWrapper;
            this.sep = System.getProperty("line.separator");
            this.sep_is_nl = this.sep == "\n";
        }
    }
}

