/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.OutputStream;
import java.io.Writer;
import org.python.core.Py;
import org.python.core.PyFile;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;

public class StdoutWrapper
extends OutputStream {
    protected String name = "stdout";
    private static /* synthetic */ Class class$Ljava$io$OutputStream;
    private static /* synthetic */ Class class$Ljava$io$Writer;

    protected PyObject getObject(PySystemState pySystemState) {
        return pySystemState.stdout;
    }

    protected void setObject(PySystemState pySystemState, PyObject pyObject) {
        pySystemState.stdout = pyObject;
    }

    protected PyObject myFile() {
        PySystemState pySystemState = Py.getSystemState();
        PyObject pyObject = this.getObject(pySystemState);
        if (pyObject == null) {
            throw Py.AttributeError("missing sys." + this.name);
        }
        if (pyObject instanceof PyJavaInstance) {
            PyFile pyFile = null;
            Object object = pyObject.__tojava__(class$Ljava$io$OutputStream != null ? class$Ljava$io$OutputStream : (class$Ljava$io$OutputStream = StdoutWrapper.class$("java.io.OutputStream")));
            if (object != Py.NoConversion && object != null) {
                OutputStream outputStream = (OutputStream)object;
                pyFile = new PyFile(outputStream, "<java OutputStream>");
            } else {
                object = pyObject.__tojava__(class$Ljava$io$Writer != null ? class$Ljava$io$Writer : (class$Ljava$io$Writer = StdoutWrapper.class$("java.io.Writer")));
                if (object != Py.NoConversion && object != null) {
                    Writer writer = (Writer)object;
                    pyFile = new PyFile(writer, "<java Writer>");
                }
            }
            if (pyFile != null) {
                this.setObject(pySystemState, pyFile);
                return pyFile;
            }
        }
        return pyObject;
    }

    public void flush() {
        PyObject pyObject = this.myFile();
        if (pyObject instanceof PyFile) {
            ((PyFile)pyObject).flush();
        } else {
            pyObject.invoke("flush");
        }
    }

    public void write(String string) {
        PyObject pyObject = this.myFile();
        if (pyObject instanceof PyFile) {
            ((PyFile)pyObject).write(string);
        } else {
            pyObject.invoke("write", new PyString(string));
        }
    }

    public void write(int n) {
        this.write(new String(new char[]{(char)n}));
    }

    public void write(byte[] byArray, int n, int n2) {
        this.write(new String(byArray, n, n2));
    }

    public void clearSoftspace() {
        PyObject pyObject = this.myFile();
        if (pyObject instanceof PyFile) {
            PyFile pyFile = (PyFile)pyObject;
            if (pyFile.softspace) {
                pyFile.write("\n");
                pyFile.flush();
            }
            pyFile.softspace = false;
        } else {
            PyObject pyObject2 = pyObject.__findattr__("softspace");
            if (pyObject2 != null && pyObject2.__nonzero__()) {
                pyObject.invoke("write", Py.Newline);
            }
            pyObject.invoke("flush");
            pyObject.__setattr__("softspace", (PyObject)Py.Zero);
        }
    }

    public void print(PyObject pyObject, boolean bl, boolean bl2) {
        PyString pyString = pyObject.__str__();
        PyObject pyObject2 = this.myFile();
        if (pyObject2 instanceof PyFile) {
            PyFile pyFile = (PyFile)pyObject2;
            String string = pyString.toString();
            if (bl2) {
                string = string + "\n";
            }
            if (pyFile.softspace) {
                string = " " + string;
            }
            pyFile.write(string);
            pyFile.flush();
            if (bl && string.endsWith("\n")) {
                bl = false;
            }
            pyFile.softspace = bl;
        } else {
            PyObject pyObject3 = pyObject2.__findattr__("softspace");
            if (pyObject3 != null && pyObject3.__nonzero__()) {
                pyObject2.invoke("write", Py.Space);
            }
            pyObject2.invoke("write", pyString);
            if (bl2) {
                pyObject2.invoke("write", Py.Newline);
            }
            if (bl && pyString.toString().endsWith("\n")) {
                bl = false;
            }
            pyObject2.__setattr__("softspace", (PyObject)(bl ? Py.One : Py.Zero));
        }
    }

    public void print(String string) {
        this.print(new PyString(string), false, false);
    }

    public void println(String string) {
        this.print(new PyString(string), false, true);
    }

    public void print(PyObject pyObject) {
        this.print(pyObject, false, false);
    }

    public void printComma(PyObject pyObject) {
        this.print(pyObject, true, false);
    }

    public void println(PyObject pyObject) {
        this.print(pyObject, false, true);
    }

    public void println() {
        PyObject pyObject = this.myFile();
        if (pyObject instanceof PyFile) {
            PyFile pyFile = (PyFile)pyObject;
            pyFile.write("\n");
            pyFile.flush();
            pyFile.softspace = false;
        } else {
            pyObject.invoke("write", Py.Newline);
            pyObject.__setattr__("softspace", (PyObject)Py.Zero);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

