## mysql
# RatingCacheMap
CREATE TABLE DB_TABLE_PREFIXRatingCacheMap(
 DB_COLUMN_PREFIXitemId int(11) NOT NULL,
 DB_COLUMN_PREFIXaverageRating int(11) NOT NULL,
 DB_COLUMN_PREFIXvoteCount int(11) NOT NULL,
 PRIMARY KEY(DB_COLUMN_PREFIXitemId)
) DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RatingCacheMap', 1, 0);

# RatingMap
CREATE TABLE DB_TABLE_PREFIXRatingMap(
 DB_COLUMN_PREFIXratingId int(11) NOT NULL,
 DB_COLUMN_PREFIXitemId int(11) NOT NULL,
 DB_COLUMN_PREFIXuserId int(11) NOT NULL,
 DB_COLUMN_PREFIXrating int(11) NOT NULL,
 DB_COLUMN_PREFIXsessionId varchar(128),
 DB_COLUMN_PREFIXremoteIdentifier varchar(255),
 PRIMARY KEY(DB_COLUMN_PREFIXratingId),
 INDEX DB_TABLE_PREFIXRatingMap_75985(DB_COLUMN_PREFIXitemId),
 INDEX DB_TABLE_PREFIXRatingMap_80383(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXuserId),
 INDEX DB_TABLE_PREFIXRatingMap_2369(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXremoteIdentifier)
) DB_TABLE_TYPE
/*!40100 DEFAULT CHARACTER SET utf8 */;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RatingMap', 1, 0);

## postgres
# RatingCacheMap
CREATE TABLE DB_TABLE_PREFIXRatingCacheMap(
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXaverageRating INTEGER NOT NULL,
 DB_COLUMN_PREFIXvoteCount INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXRatingCacheMap ADD PRIMARY KEY (DB_COLUMN_PREFIXitemId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RatingCacheMap', 1, 0);

# RatingMap
CREATE TABLE DB_TABLE_PREFIXRatingMap(
 DB_COLUMN_PREFIXratingId INTEGER NOT NULL,
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXrating INTEGER NOT NULL,
 DB_COLUMN_PREFIXsessionId VARCHAR(128),
 DB_COLUMN_PREFIXremoteIdentifier VARCHAR(255)
);

ALTER TABLE DB_TABLE_PREFIXRatingMap ADD PRIMARY KEY (DB_COLUMN_PREFIXratingId);

CREATE INDEX DB_TABLE_PREFIXRatingMap_75985 ON DB_TABLE_PREFIXRatingMap(DB_COLUMN_PREFIXitemId);

CREATE INDEX DB_TABLE_PREFIXRatingMap_80383 ON DB_TABLE_PREFIXRatingMap(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXuserId);

CREATE INDEX DB_TABLE_PREFIXRatingMap_2369 ON DB_TABLE_PREFIXRatingMap(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXremoteIdentifier);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RatingMap', 1, 0);

## oracle
# RatingCacheMap
CREATE TABLE DB_TABLE_PREFIXRatingCacheMap(
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXaverageRating INTEGER NOT NULL,
 DB_COLUMN_PREFIXvoteCount INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXRatingCacheMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXitemId)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RatingCacheMap', 1, 0);

# RatingMap
CREATE TABLE DB_TABLE_PREFIXRatingMap(
 DB_COLUMN_PREFIXratingId INTEGER NOT NULL,
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXrating INTEGER NOT NULL,
 DB_COLUMN_PREFIXsessionId VARCHAR2(128),
 DB_COLUMN_PREFIXremoteIdentifier VARCHAR2(255)
);

CREATE INDEX DB_TABLE_PREFIXRatingMap_75985
   ON DB_TABLE_PREFIXRatingMap(DB_COLUMN_PREFIXitemId);

CREATE INDEX DB_TABLE_PREFIXRatingMap_80383
   ON DB_TABLE_PREFIXRatingMap(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXuserId);

CREATE INDEX DB_TABLE_PREFIXRatingMap_2369
   ON DB_TABLE_PREFIXRatingMap(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXremoteIdentifier);

ALTER TABLE DB_TABLE_PREFIXRatingMap
 ADD PRIMARY KEY (DB_COLUMN_PREFIXratingId)
;

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RatingMap', 1, 0);

## db2
# RatingCacheMap
CREATE TABLE DB_TABLE_PREFIXRatingCacheMap(
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXaverageRating INTEGER NOT NULL,
 DB_COLUMN_PREFIXvoteCount INTEGER NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXRatingCacheMap ADD PRIMARY KEY (DB_COLUMN_PREFIXitemId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RatingCacheMap', 1, 0);

# RatingMap
CREATE TABLE DB_TABLE_PREFIXRatingMap(
 DB_COLUMN_PREFIXratingId INTEGER NOT NULL,
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXrating INTEGER NOT NULL,
 DB_COLUMN_PREFIXsessionId VARCHAR(128),
 DB_COLUMN_PREFIXremoteIdentifier VARCHAR(255)
);

ALTER TABLE DB_TABLE_PREFIXRatingMap ADD PRIMARY KEY (DB_COLUMN_PREFIXratingId);

CREATE INDEX DB_TABLE_PREFIXRatinc1_75985
   ON DB_TABLE_PREFIXRatingMap(DB_COLUMN_PREFIXitemId);

CREATE INDEX DB_TABLE_PREFIXRatinc1_80383
   ON DB_TABLE_PREFIXRatingMap(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXuserId);

CREATE INDEX DB_TABLE_PREFIXRatinc1_2369
   ON DB_TABLE_PREFIXRatingMap(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXremoteIdentifier);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RatingMap', 1, 0);

## mssql
# RatingCacheMap
CREATE TABLE DB_TABLE_PREFIXRatingCacheMap(
 DB_COLUMN_PREFIXitemId INT NOT NULL,
 DB_COLUMN_PREFIXaverageRating INT NOT NULL,
 DB_COLUMN_PREFIXvoteCount INT NOT NULL
);

ALTER TABLE DB_TABLE_PREFIXRatingCacheMap ADD PRIMARY KEY (DB_COLUMN_PREFIXitemId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RatingCacheMap', 1, 0);

# RatingMap
CREATE TABLE DB_TABLE_PREFIXRatingMap(
 DB_COLUMN_PREFIXratingId INT NOT NULL,
 DB_COLUMN_PREFIXitemId INT NOT NULL,
 DB_COLUMN_PREFIXuserId INT NOT NULL,
 DB_COLUMN_PREFIXrating INT NOT NULL,
 DB_COLUMN_PREFIXsessionId NVARCHAR(128) NULL,
 DB_COLUMN_PREFIXremoteIdentifier NVARCHAR(255) NULL
);

ALTER TABLE DB_TABLE_PREFIXRatingMap ADD PRIMARY KEY (DB_COLUMN_PREFIXratingId);

CREATE INDEX DB_TABLE_PREFIXRatingMap_75985 ON DB_TABLE_PREFIXRatingMap(DB_COLUMN_PREFIXitemId);

CREATE INDEX DB_TABLE_PREFIXRatingMap_80383 ON DB_TABLE_PREFIXRatingMap(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXuserId);

CREATE INDEX DB_TABLE_PREFIXRatingMap_2369 ON DB_TABLE_PREFIXRatingMap(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXremoteIdentifier);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RatingMap', 1, 0);

## sqlite
# RatingCacheMap
CREATE TABLE DB_TABLE_PREFIXRatingCacheMap(
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXaverageRating INTEGER NOT NULL,
 DB_COLUMN_PREFIXvoteCount INTEGER NOT NULL
);

CREATE UNIQUE INDEX DB_TABLE_PREFIXRatingCacheMap_pkey ON DB_TABLE_PREFIXRatingCacheMap(DB_COLUMN_PREFIXitemId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RatingCacheMap', 1, 0);

# RatingMap
CREATE TABLE DB_TABLE_PREFIXRatingMap(
 DB_COLUMN_PREFIXratingId INTEGER NOT NULL,
 DB_COLUMN_PREFIXitemId INTEGER NOT NULL,
 DB_COLUMN_PREFIXuserId INTEGER NOT NULL,
 DB_COLUMN_PREFIXrating INTEGER NOT NULL,
 DB_COLUMN_PREFIXsessionId TEXT,
 DB_COLUMN_PREFIXremoteIdentifier TEXT
);

CREATE UNIQUE INDEX DB_TABLE_PREFIXRatingMap_pkey ON DB_TABLE_PREFIXRatingMap(DB_COLUMN_PREFIXratingId);

CREATE INDEX DB_TABLE_PREFIXRatingMap_75985 ON DB_TABLE_PREFIXRatingMap(DB_COLUMN_PREFIXitemId);

INSERT INTO DB_TABLE_PREFIXSchema (
 DB_COLUMN_PREFIXname,
 DB_COLUMN_PREFIXmajor,
 DB_COLUMN_PREFIXminor
) VALUES('RatingMap', 1, 0);

