/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.prefs;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.GalleryRemoteCore;
import com.gallery.GalleryRemote.MainFrame;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.PreferencePanel;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.ColorWellButton;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;

public class SlideshowPanel
extends PreferencePanel
implements PreferenceNames {
    public static final String MODULE = "SlidePa";
    JLabel icon = new JLabel(GRI18n.getString("SlidePa", "icon"));
    JPanel progressionPanel = new JPanel();
    JPanel locationPanel = new JPanel();
    public JPanel spacerPanel = new JPanel();
    JLabel delay = new JLabel();
    JSlider jDelay = new JSlider();
    JLabel transition = new JLabel();
    JSlider jTransition = new JSlider();
    JLabel help = new JLabel();
    JLabel progress = new JLabel();
    JLabel caption = new JLabel();
    JLabel extra = new JLabel();
    JLabel url = new JLabel();
    JLabel album = new JLabel();
    JLabel summary = new JLabel();
    JLabel description = new JLabel();
    JCheckBox jOverride = new JCheckBox();
    JPanel apperancePanel = new JPanel();
    JComboBox jProgress;
    JComboBox jCaption;
    JComboBox jExtra;
    JComboBox jUrl;
    JComboBox jAlbum;
    JComboBox jSummary;
    JComboBox jDescription;
    JCheckBox jLowRez = new JCheckBox();
    JCheckBox jRandom = new JCheckBox();
    JCheckBox jNoStretch = new JCheckBox();
    JCheckBox jPreloadAll = new JCheckBox();
    JCheckBox jLoop = new JCheckBox();
    JPanel spacerPanel1 = new JPanel();
    ColorWellButton jBackgroundColor = new ColorWellButton(Color.red);
    JTabbedPane tabs = new JTabbedPane();

    public JLabel getIcon() {
        return this.icon;
    }

    public void readProperties(PropertiesFile props) {
        this.jProgress.setSelectedItem(new LocationItem(props.getIntProperty("slideshowProgressLocation")));
        this.jCaption.setSelectedItem(new LocationItem(props.getIntProperty("slideshowCaptionLocation")));
        this.jExtra.setSelectedItem(new LocationItem(props.getIntProperty("slideshowExtraLocation")));
        this.jUrl.setSelectedItem(new LocationItem(props.getIntProperty("slideshowUrlLocation")));
        this.jAlbum.setSelectedItem(new LocationItem(props.getIntProperty("slideshowAlbumLocation")));
        this.jSummary.setSelectedItem(new LocationItem(props.getIntProperty("slideshowSummaryLocation")));
        this.jDescription.setSelectedItem(new LocationItem(props.getIntProperty("slideshowDescriptionLocation")));
        this.jLowRez.setSelected(props.getBooleanProperty("slideshowLowRez"));
        this.jRandom.setSelected(props.getBooleanProperty("slideshowRandom"));
        this.jNoStretch.setSelected(props.getBooleanProperty("slideshowNoStretch"));
        this.jPreloadAll.setSelected(props.getBooleanProperty("slideshowPreloadAll"));
        this.jLoop.setSelected(props.getBooleanProperty("slideshowLoop"));
        this.jDelay.setValue(props.getIntProperty("slideshowDelay") * 1000);
        this.jTransition.setValue(props.getIntProperty("slideshowTransitionDuration"));
        Color color = props.getColorProperty("slideshowColor");
        this.jOverride.setSelected(color != null);
        this.jBackgroundColor.setSelectedColor(color);
        this.jProgress.setEnabled(!props.isOverridden("slideshowProgressLocation"));
        this.jCaption.setEnabled(!props.isOverridden("slideshowCaptionLocation"));
        this.jExtra.setEnabled(!props.isOverridden("slideshowExtraLocation"));
        this.jUrl.setEnabled(!props.isOverridden("slideshowUrlLocation"));
        this.jAlbum.setEnabled(!props.isOverridden("slideshowAlbumLocation"));
        this.jSummary.setEnabled(!props.isOverridden("slideshowSummaryLocation"));
        this.jDescription.setEnabled(!props.isOverridden("slideshowDescriptionLocation"));
        this.jLowRez.setEnabled(!props.isOverridden("slideshowLowRez"));
        this.jRandom.setEnabled(!props.isOverridden("slideshowRandom"));
        this.jNoStretch.setEnabled(!props.isOverridden("slideshowNoStretch"));
        this.jPreloadAll.setEnabled(!props.isOverridden("slideshowPreloadAll"));
        this.jLoop.setEnabled(!props.isOverridden("slideshowLoop"));
        this.jDelay.setEnabled(!props.isOverridden("slideshowDelay"));
        this.jTransition.setEnabled(!props.isOverridden("slideshowTransitionDuration"));
        this.jOverride.setEnabled(!props.isOverridden("slideshowColor"));
        this.jBackgroundColor.setEnabled(!props.isOverridden("slideshowColor"));
    }

    public void writeProperties(PropertiesFile props) {
        if (this.jNoStretch.isSelected() != props.getBooleanProperty("slideshowNoStretch")) {
            ImageUtils.purgeTemp();
            GalleryRemote._().getCore().flushMemory();
        }
        props.setIntProperty("slideshowProgressLocation", ((LocationItem)this.jProgress.getSelectedItem()).id);
        props.setIntProperty("slideshowCaptionLocation", ((LocationItem)this.jCaption.getSelectedItem()).id);
        props.setIntProperty("slideshowExtraLocation", ((LocationItem)this.jExtra.getSelectedItem()).id);
        props.setIntProperty("slideshowUrlLocation", ((LocationItem)this.jUrl.getSelectedItem()).id);
        props.setIntProperty("slideshowAlbumLocation", ((LocationItem)this.jAlbum.getSelectedItem()).id);
        props.setIntProperty("slideshowSummaryLocation", ((LocationItem)this.jSummary.getSelectedItem()).id);
        props.setIntProperty("slideshowDescriptionLocation", ((LocationItem)this.jDescription.getSelectedItem()).id);
        props.setBooleanProperty("slideshowLowRez", this.jLowRez.isSelected());
        props.setBooleanProperty("slideshowRandom", this.jRandom.isSelected());
        props.setBooleanProperty("slideshowNoStretch", this.jNoStretch.isSelected());
        props.setBooleanProperty("slideshowPreloadAll", this.jPreloadAll.isSelected());
        props.setBooleanProperty("slideshowLoop", this.jLoop.isSelected());
        props.setIntProperty("slideshowDelay", this.jDelay.getValue() / 1000);
        props.setIntProperty("slideshowTransitionDuration", this.jTransition.getValue());
        if (this.jOverride.isSelected()) {
            props.setColorProperty("slideshowColor", this.jBackgroundColor.getSelectedColor());
        } else {
            props.setProperty("slideshowColor", null);
        }
        GalleryRemoteCore core = GalleryRemote._().getCore();
        if (!GalleryRemote._().isAppletMode()) {
            ((MainFrame)core).previewFrame.repaint();
        }
    }

    public void buildUI() {
        this.jbInit();
    }

    private void jbInit() {
        Vector<LocationItem> locationItems = new Vector<LocationItem>();
        locationItems.add(new LocationItem(0));
        locationItems.add(new LocationItem(12));
        locationItems.add(new LocationItem(10));
        locationItems.add(new LocationItem(14));
        locationItems.add(new LocationItem(22));
        locationItems.add(new LocationItem(20));
        locationItems.add(new LocationItem(24));
        locationItems.add(new LocationItem(32));
        locationItems.add(new LocationItem(30));
        locationItems.add(new LocationItem(34));
        this.jProgress = new JComboBox(locationItems);
        this.jCaption = new JComboBox(locationItems);
        this.jExtra = new JComboBox(locationItems);
        this.jUrl = new JComboBox(locationItems);
        this.jAlbum = new JComboBox(locationItems);
        this.jSummary = new JComboBox(locationItems);
        this.jDescription = new JComboBox(locationItems);
        this.setLayout(new GridBagLayout());
        this.progressionPanel.setLayout(new GridBagLayout());
        this.locationPanel.setLayout(new GridBagLayout());
        this.locationPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString(MODULE, "locationTitle")));
        this.apperancePanel.setLayout(new GridBagLayout());
        this.delay.setText(GRI18n.getString(MODULE, "delay"));
        this.delay.setLabelFor(this.jDelay);
        this.delay.setToolTipText(GRI18n.getString(MODULE, "delayHelp"));
        this.jDelay.setMinimum(0);
        this.jDelay.setMaximum(30000);
        Hashtable<Integer, JLabel> ticks = new Hashtable<Integer, JLabel>(4);
        ticks.put(new Integer(0), new JLabel(GRI18n.getString(MODULE, "delayNone")));
        ticks.put(new Integer(5000), new JLabel("5s"));
        ticks.put(new Integer(10000), new JLabel("10s"));
        ticks.put(new Integer(30000), new JLabel("30s"));
        this.jDelay.setLabelTable(ticks);
        this.jDelay.setPaintLabels(true);
        this.jDelay.setMajorTickSpacing(5000);
        this.jDelay.setPaintTicks(true);
        this.transition.setText(GRI18n.getString(MODULE, "transition"));
        this.transition.setLabelFor(this.jTransition);
        this.transition.setToolTipText(GRI18n.getString(MODULE, "transitionHelp"));
        this.jTransition.setMinimum(0);
        this.jTransition.setMaximum(5000);
        ticks = new Hashtable(4);
        ticks.put(new Integer(0), new JLabel(GRI18n.getString(MODULE, "transitionNone")));
        ticks.put(new Integer(1000), new JLabel("1s"));
        ticks.put(new Integer(2000), new JLabel("2s"));
        ticks.put(new Integer(5000), new JLabel("5s"));
        this.jTransition.setLabelTable(ticks);
        this.jTransition.setPaintLabels(true);
        this.jTransition.setMajorTickSpacing(1000);
        this.jTransition.setPaintTicks(true);
        this.help.setText(GRI18n.getString(MODULE, "delayDesc"));
        this.jRandom.setText(GRI18n.getString(MODULE, "random"));
        this.jRandom.setToolTipText(GRI18n.getString(MODULE, "randomHelp"));
        this.jNoStretch.setText(GRI18n.getString(MODULE, "noStretch"));
        this.jNoStretch.setToolTipText(GRI18n.getString(MODULE, "noStretchHelp"));
        this.jPreloadAll.setText(GRI18n.getString(MODULE, "preloadAll"));
        this.jPreloadAll.setToolTipText(GRI18n.getString(MODULE, "preloadAllHelp"));
        this.jLoop.setText(GRI18n.getString(MODULE, "loop"));
        this.jLoop.setToolTipText(GRI18n.getString(MODULE, "loopHelp"));
        this.progress.setText(GRI18n.getString(MODULE, "progress"));
        this.progress.setLabelFor(this.jProgress);
        this.progress.setToolTipText(GRI18n.getString(MODULE, "progressHelp"));
        this.caption.setText(GRI18n.getString(MODULE, "caption"));
        this.caption.setLabelFor(this.jCaption);
        this.caption.setToolTipText(GRI18n.getString(MODULE, "captionHelp"));
        this.extra.setText(GRI18n.getString(MODULE, "extra"));
        this.extra.setLabelFor(this.jExtra);
        this.extra.setToolTipText(GRI18n.getString(MODULE, "extraHelp"));
        this.url.setText(GRI18n.getString(MODULE, "url"));
        this.url.setLabelFor(this.jUrl);
        this.url.setToolTipText(GRI18n.getString(MODULE, "urlHelp"));
        this.album.setText(GRI18n.getString(MODULE, "album"));
        this.album.setLabelFor(this.jAlbum);
        this.album.setToolTipText(GRI18n.getString(MODULE, "albumHelp"));
        this.summary.setText(GRI18n.getString(MODULE, "summary"));
        this.summary.setLabelFor(this.jSummary);
        this.summary.setToolTipText(GRI18n.getString(MODULE, "summaryHelp"));
        this.description.setText(GRI18n.getString(MODULE, "description"));
        this.summary.setLabelFor(this.jDescription);
        this.summary.setToolTipText(GRI18n.getString(MODULE, "descriptionHelp"));
        this.jLowRez.setText(GRI18n.getString(MODULE, "lowRez"));
        this.jLowRez.setToolTipText(GRI18n.getString(MODULE, "lowRezHelp"));
        this.jOverride.setText(GRI18n.getString(MODULE, "backgroundColor"));
        this.add((Component)this.tabs, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabs.add(GRI18n.getString(MODULE, "progressionTitle"), this.progressionPanel);
        this.tabs.add(GRI18n.getString(MODULE, "appearanceTitle"), this.apperancePanel);
        this.add((Component)this.help, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.spacerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.progressionPanel.add((Component)this.delay, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.progressionPanel.add((Component)this.jDelay, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.progressionPanel.add((Component)this.transition, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.progressionPanel.add((Component)this.jTransition, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.progressionPanel.add((Component)this.jRandom, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.progressionPanel.add((Component)this.jPreloadAll, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.progressionPanel.add((Component)this.jLoop, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.progressionPanel.add((Component)new JPanel(), new GridBagConstraints(0, 5, 2, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.apperancePanel.add((Component)this.jLowRez, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.apperancePanel.add((Component)this.jNoStretch, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.apperancePanel.add((Component)this.jOverride, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.apperancePanel.add((Component)this.jBackgroundColor, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.apperancePanel.add((Component)this.locationPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.apperancePanel.add((Component)new JPanel(), new GridBagConstraints(0, 4, 2, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        int row = 0;
        this.locationPanel.add((Component)this.progress, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.locationPanel.add((Component)this.jProgress, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.locationPanel.add((Component)this.caption, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.locationPanel.add((Component)this.jCaption, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.locationPanel.add((Component)this.extra, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.locationPanel.add((Component)this.jExtra, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.locationPanel.add((Component)this.summary, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.locationPanel.add((Component)this.jSummary, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.locationPanel.add((Component)this.description, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.locationPanel.add((Component)this.jDescription, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.locationPanel.add((Component)this.url, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.locationPanel.add((Component)this.jUrl, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.locationPanel.add((Component)this.album, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.locationPanel.add((Component)this.jAlbum, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    class LocationItem {
        String name;
        int id;

        public LocationItem(int id) {
            this.id = id;
            this.name = GRI18n.getString(SlideshowPanel.MODULE, "locationItem." + id);
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            return o instanceof LocationItem && this.id == ((LocationItem)o).id;
        }
    }
}

