<?php

##################################################
#
# Copyright (c) 2004-2005 James Hunt and the OIC Group, Inc.
#
# This file is part of Exponent
#
# Exponent is free software; you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# Exponent is distributed in the hope that it
# will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU
# General Public License along with Exponent; if
# not, write to:
#
# Free Software Foundation, Inc.,
# 59 Temple Place,
# Suite 330,
# Boston, MA 02111-1307  USA
#
# $Id: upgrade_version.php,v 1.1.2.1 2005/05/02 16:06:06 filetreefrog Exp $
##################################################
//GREP:HARDCODEDTEXT

if (!defined('PATHOS')) exit('');

$versions = array(
	'0.95'=>'Nebula',
	'0.96'=>'Origin',
	'0.97'=>'Portent',
	'0.98'=>'Quip',
	'0.99'=>'Ramose',
	'1.0'=>'Salient',
);


?>

<form method="post" action="index.php">
<input type="hidden" name="page" value="upgrade" />

<div class="form_section_header">Select Version to Upgrade From</div>
<div class="form_section">
	<div class="control">
		<select name="from_version" value="<?php echo PATHOS; ?>">
		<?php
			foreach ($versions as $version=>$release) {
				echo '<option value="'.$version.'">';
				echo $version . ' ' . $release;
				if ($version == PATHOS) {
					echo ' - Previous Release';
				}
				echo '</option>';
				
				if ($version == PATHOS) {
					break;
				}
			}
		?>
		</select>
		<div class="control_help">
			Select the version of Exponent that you are upgrading from.
			<br /><br />
			<div class="important_message">
				Make sure that you choose the correct version.  Picking an incorrect version can destroy the data in your database.
			</div>
		</div>
		<input type="submit" value="Upgrade" class="text" />
	</div>
</div>
</form>