<?php
/*
 * $RCSfile: GalleryEntity.inc,v $
 *
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2005 Bharat Mediratta
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
/**
 * @package GalleryCore
 * @subpackage ClassInterfaces
 * @version $Revision: 1.41 $ $Date: 2005/08/23 03:49:04 $
 * @author Bharat Mediratta <bharat@menalto.com>
 */

/**
 * Interface class for the GalleryEntity class.
 * (Class schema version: 1.1)
 *
 * This file is automatically generated from XML embedded in the
 * class, combined with the ClassCode.xsl file.  You should not modify
 * it by hand, as your changes will be lost next time this file is
 * rebuilt.  If you want to add more getters/setters, you should add
 * them in the core class.  If you want to change the format of this
 * file, then you should edit the XSL template.
 *
 * @package GalleryCore
 * @subpackage Classes
 */
class GalleryEntity extends GalleryEntity_core {
  
    /**
     * Return meta information about the members of this class
     *
     * @return array member => array(type, class)
     */
    function getPersistentMemberInfo() {
	$meta = parent::getPersistentMemberInfo();
	$meta['members']['id'] = array('class' => 'GalleryEntity', 'type' => STORAGE_TYPE_INTEGER | STORAGE_TYPE_ID);
    
	$meta['members']['creationTimestamp'] = array('class' => 'GalleryEntity', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['isLinkable'] = array('class' => 'GalleryEntity', 'type' => STORAGE_TYPE_BOOLEAN);
    
	$meta['members']['linkId'] = array('class' => 'GalleryEntity', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['modificationTimestamp'] = array('class' => 'GalleryEntity', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['serialNumber'] = array('class' => 'GalleryEntity', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['entityType'] = array('class' => 'GalleryEntity', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['onLoadHandlers'] = array('class' => 'GalleryEntity', 'type' => STORAGE_TYPE_STRING);
    
	return $meta;
    }

    /**
     * Get the data from this persistent object as an associative array
     *
     * @return array memberName => memberValue
     */
    function getMemberData() {
	$data = parent::getMemberData();
        $data['id'] = isset($this->_id) ? $this->_id : null;
        $data['creationTimestamp'] = isset($this->_creationTimestamp) ? $this->_creationTimestamp : null;
        $data['isLinkable'] = isset($this->_isLinkable) ? $this->_isLinkable : null;
        $data['linkId'] = isset($this->_linkId) ? $this->_linkId : null;
        $data['modificationTimestamp'] = isset($this->_modificationTimestamp) ? $this->_modificationTimestamp : null;
        $data['serialNumber'] = isset($this->_serialNumber) ? $this->_serialNumber : null;
        $data['entityType'] = isset($this->_entityType) ? $this->_entityType : null;
        $data['onLoadHandlers'] = isset($this->_onLoadHandlers) ? $this->_onLoadHandlers : null;
	return $data;
    }
  
    /**
     * Return the name of this class with the proper mix of uppercase and
     * lowercase (get_class() always returns lowercase)
     *
     * @return string class name
     */
    function getClassName() {
	return 'GalleryEntity';
    }

    /** 
     * Return the path to the PHP file for this class, relative to the gallery2 dir
     * 
     * @return string path
     */ 
    function getClassFile() { 
        return 'modules/' .  
            basename(dirname(dirname(dirname(__FILE__)))) .  
            '/classes/GalleryEntity.class'; 
    }
    
    /**
     * Get the value of id
     *
     * @return INTEGER the value
     */
    function getid() {
	if (!isset($this->_id)) {
	    return null;
	}
	return $this->_id;
    }

    /**
     * Set the value of id
     *
     * @param INTEGER the value
     */
    function setid($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_id) ? $this->_id : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('id', $value);
	    $this->_id = $value;
	}
    }
  
    /**
     * Get the value of creationTimestamp
     *
     * @return INTEGER the value
     */
    function getcreationTimestamp() {
	if (!isset($this->_creationTimestamp)) {
	    return null;
	}
	return $this->_creationTimestamp;
    }

    /**
     * Set the value of creationTimestamp
     *
     * @param INTEGER the value
     */
    function setcreationTimestamp($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_creationTimestamp) ? $this->_creationTimestamp : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('creationTimestamp', $value);
	    $this->_creationTimestamp = $value;
	}
    }
  
    /**
     * Get the value of isLinkable
     *
     * @return BOOLEAN the value
     */
    function getisLinkable() {
	if (!isset($this->_isLinkable)) {
	    return null;
	}
	return $this->_isLinkable;
    }

    /**
     * Set the value of isLinkable
     *
     * @param BOOLEAN the value
     */
    function setisLinkable($value) {
	/* Set the incoming value to be a 1 or 0 */
	$value = empty($value) ? 0 : 1;
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_isLinkable) ? $this->_isLinkable : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('isLinkable', $value);
	    $this->_isLinkable = $value;
	}
    }
  
    /**
     * Get the value of linkId
     *
     * @return INTEGER the value
     */
    function getlinkId() {
	if (!isset($this->_linkId)) {
	    return null;
	}
	return $this->_linkId;
    }

    /**
     * Set the value of linkId
     *
     * @param INTEGER the value
     */
    function setlinkId($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_linkId) ? $this->_linkId : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('linkId', $value);
	    $this->_linkId = $value;
	}
    }
  
    /**
     * Get the value of modificationTimestamp
     *
     * @return INTEGER the value
     */
    function getmodificationTimestamp() {
	if (!isset($this->_modificationTimestamp)) {
	    return null;
	}
	return $this->_modificationTimestamp;
    }

    /**
     * Set the value of modificationTimestamp
     *
     * @param INTEGER the value
     */
    function setmodificationTimestamp($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_modificationTimestamp) ? $this->_modificationTimestamp : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('modificationTimestamp', $value);
	    $this->_modificationTimestamp = $value;
	}
    }
  
    /**
     * Get the value of serialNumber
     *
     * @return INTEGER the value
     */
    function getserialNumber() {
	if (!isset($this->_serialNumber)) {
	    return null;
	}
	return $this->_serialNumber;
    }

    /**
     * Set the value of serialNumber
     *
     * @param INTEGER the value
     */
    function setserialNumber($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_serialNumber) ? $this->_serialNumber : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('serialNumber', $value);
	    $this->_serialNumber = $value;
	}
    }
  
    /**
     * Get the value of entityType
     *
     * @return STRING the value
     */
    function getentityType() {
	if (!isset($this->_entityType)) {
	    return null;
	}
	return $this->_entityType;
    }

    /**
     * Set the value of entityType
     *
     * @param STRING the value
     */
    function setentityType($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 32);
	$orig = isset($this->_entityType) ? $this->_entityType : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('entityType', $value);
	    $this->_entityType = $value;
	}
    }
  
    /**
     * Get the value of onLoadHandlers
     *
     * @return STRING the value
     */
    function getonLoadHandlers() {
	if (!isset($this->_onLoadHandlers)) {
	    return null;
	}
	return $this->_onLoadHandlers;
    }

    /**
     * Set the value of onLoadHandlers
     *
     * @param STRING the value
     */
    function setonLoadHandlers($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 128);
	$orig = isset($this->_onLoadHandlers) ? $this->_onLoadHandlers : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('onLoadHandlers', $value);
	    $this->_onLoadHandlers = $value;
	}
    }
  
}
?>
