<?php

##################################################
#
# Copyright (c) 2004-2005 James Hunt and the OIC Group, Inc.
#
# This file is part of Exponent
#
# Exponent is free software; you can redistribute
# it and/or modify it under the terms of the GNU
# General Public License as published by the Free
# Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# Exponent is distributed in the hope that it
# will be useful, but WITHOUT ANY WARRANTY;
# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU
# General Public License along with Exponent; if
# not, write to:
#
# Free Software Foundation, Inc.,
# 59 Temple Place,
# Suite 330,
# Boston, MA 02111-1307  USA
#
# $Id: sanity.php,v 1.10.2.2 2005/05/02 16:06:06 filetreefrog Exp $
##################################################
//GREP:HARDCODEDTEXT

if (!defined('PATHOS')) exit('');

include_once("include/sanity.php");

$status = sanity_checkFiles();
// Run sanity checks
$errcount = count($status);
$warncount = 0; // No warnings with permissions
?>
<h2 id="subtitle">
System Requirements Check
</h2>
<table cellspacing="0" cellpadding="3" rules="all" border="0" style="border:1px solid grey;" width="100%">
<tr><td colspan="2" style="background-color: lightgrey;"><b>File and Directory Permission Tests</b></td></tr>
<?php

foreach ($status as $file=>$stat) {
	echo '<tr><td width="55%" class="bodytext">'.$file.'</td><td align="center" width="45%"';
	if ($stat != SANITY_FINE) echo ' class="bodytext error">';
	else echo ' class="bodytext success">';
	switch ($stat) {
		case SANITY_NOT_E:
			echo 'File Not Found';
			break;
		case SANITY_NOT_R:
			echo 'Not Readable';
			break;
		case SANITY_NOT_RW:
			echo 'Not Readable / Writable';
			break;
		case SANITY_FINE:
			$errcount--;
			echo 'Okay';
			break;
		default:
			echo '????';
			break;
	}
	echo '</td></tr>';
}
?>
<tr><td colspan="2" style="background-color: lightgrey;"><b>Other Tests</b></td></tr>
<?php

$status = sanity_checkServer();
$errcount += count($status);
$warncount += count($status);
foreach ($status as $test=>$stat) {
	echo '<tr><td width="55%" class="bodytext">'.$test.'</td>';
	echo '<td align="center" width="45%" ';
	if ($stat[0] == SANITY_FINE) {
		$warncount--;
		$errcount--;
		echo 'class="bodytext success">';
	} else if ($stat[0] == SANITY_ERROR) {
		$warncount--;
		echo 'class="bodytext error">';
	} else {
		$errcount--;
		echo 'class="bodytext warning">';
	}
	echo $stat[1].'</td></tr>';
}

?>
</table>
<br />
<?php

$write_file = 0;

if ($errcount > 0) {
	// Had errors.  Force halt and fix.
	echo 'The Exponent Install Wizard found some major problems with the server environment, which you must fix before you can continue.';
	
	if (ini_get('safe_mode') == true) {
		echo '<br /><br /><div style="font-weight: bold; color: red;">SAFE MODE IS ENABLED.  You may encounter many strange errors unless you give the web server user ownership of ALL Exponent files.  On UNIX, this can be done with a "chown -R" command</div>';
	}
	?>
	<br /><b>Note:</b> For permission errors (files or directories that are not writable / not readable) it is usually best to make sure that the Exponent files were uncompressed with options (-xzvpf) to preserve file permissions.
	<br /><br />
	After you have corrected the above errors, click <a href="index.php?page=sanity">here</a> to run these environment checks again.
	<?php
} else if ($warncount > 0) {
	echo 'The Exponent Install Wizard found some minor problems with the server environment, but you should be able to continue.';
	
	if (ini_get('safe_mode') == true) {
		echo '<br /><br /><div class="important_message">SAFE MODE IS ENABLED.  You may encounter many strange errors unless you give the web server user ownership of ALL Exponent files.  On UNIX, this can be done with a "chown -R" command</div>';
	}
	
	$write_file = 1;
} else {
	// No errors, and no warnings.  Let them through.
	echo 'The Exponent Install Wizard found no problems with the server environment.';
	
	$write_file = 1;
}

if ($errcount == 0) {
	if ($_REQUEST['type'] == 'new') {
	?>
	<br />Please proceed to <a href="index.php?page=dbconfig">configure your database</a>.
	<?php
	} else {
	?>
	<br />Please proceed to <a href="index.php?page=upgrade_version">upgrade your database</a>.
	<?php
	}
}

if ($write_file) {
	// The following checks work on Apache and IIS.  Any other success / failure stories are welcome.
	if (strtolower(substr(php_sapi_name(),0,3)) == 'cgi') {
		//In CGI mode SCRIPT_NAME is not correct, so we will try PATH_INFO first...
		// We need to strip off the last two things, filename and the install dirname.
		$components = join('/',array_splice(split('/',$_SERVER['PATH_INFO']),0,-2)).'/';
	} else {
		// If we aren't in either cgi or cgi-fast, then we are compiled in and should use SCRIPT_NAME
		// We need to strip off the last two things, filename and the install dirname.
		$components = join('/',array_splice(split('/',$_SERVER['SCRIPT_NAME']),0,-2)).'/';
	}
	$path_relative = PATH_RELATIVE;
	
	if ($components != $path_relative) {
		$path_relative = $components;
		$fh = fopen(BASE.'overrides.php','w');
		fwrite($fh,"<?php\r\n\r\ndefine('PATH_RELATIVE','$path_relative');\r\n\r\n?>\r\n");
		fclose($fh);
	}
}

?>