static	char sccsid[] = "@(#) cmdhist.c 1.2 - 7/8/88" ;

/* ----------------------------------------------------------------- *
 *
 * Written by:	Tyrone Shiu
 * Room:	MT 2E-232
 * Phone:	957-3693
 * Email:	mtdcc!tyrone
 *
 * ----------------------------------------------------------------- */

/* ------------------------------------------------------------------ *
 * cmdhist:	This program is similar to the history command (fc) in 
 *		ksh except it is for the program "k" by Dave Neal.
 *		The syntax for the command is as follows:
 *		
 *		cmdhist [-n] [-r] [-l start,end] [-f file] command
 *		where,
 *			-i -- diplay the range cmds in the history file
 *			-n -- list cmds with numbering
 *			-r -- in reverse order
 *			-l -- list the cmd history from start to end.
 *			-l -- list the cmd from -(number) or from number
 *			-f -- use the 'file' as the history file
 *
 *		The follow code is adapted from the k-shell program
 *
 * ------------------------------------------------------------------ */

#include	"cmdhist.h"

static char usage[] = "usage: cmdhist [-i] [-n] [-r] [-l [start,end] | number] ] [-f file] command" ;

/* #ifdef BSD */
int tty_speeds[] = {0, 50, 75, 110, 134, 150, 200, 300,
			600,1200,1800,2400,9600,19200,0};
/* #endif  BSD */

/* This is the main program */

main (argc, argv)
int	argc ;
char*	argv[] ;
{
	register struct fixcmd *fp ;
	register int	c ;

	FILE*	fdo = stdout ;

	char*	cmdName ;
	char*	listRange ;
	char*	histFile ;
	char*	ptr ;

	/* option flags */

	int	iflag = OFF ;
	int	nflag = OFF ;
	int	rflag = OFF ;
	int	fflag = OFF ;
	int	lflag = OFF ;

	char	histname[1024];
	char*	cmdBaseName;
	char*	wherehist ;

	int	validStart ;
	int	validEnd ;
	int	temp ;
	int	range[2] ;
	int	start = START ;
	int	end = END ;

	int	incr = 1;

	/* Decode user arguments */
	while ((c = getopt (argc, argv, "inrf:l:")) != EOF)
	{
		switch(c)
		{
		case 'i': /* display the range of the commands */
			iflag = ON ;
			break ;
		case 'n': /* list the cmds with numbering */
			nflag = ON ;
			break ;

		case 'r': /* list in reverse order */
			rflag = ON ;
			break ;

		case 'f': /* use the next argument as the name for
			   * as the history file.
			   */
			fflag = ON ;
			histFile = calloc (strlen (optarg) + 1, sizeof (char)) ;
			strcpy (histFile, optarg) ;
			break ;

		case 'l': /* history listing range */
			lflag = ON ;
			listRange = calloc (strlen (optarg) + 1, sizeof (char)) ;
			strcpy (listRange, optarg) ;
			break ;

		case '?':
		default :
			fprintf (stderr, "%s\n", usage) ;
			exit (1) ;
		}
	}

	argv = &argv[optind] ;
	argc -= optind ;

	/* No command name or history file name is supplied */
	if ((argc == 0) && (fflag == OFF))
	{
		fprintf (stderr, "%s\n", usage) ;
		exit (1) ;
	}

	/* Built the command history file name. */

	strcpy (histname, "HISTFILE=");

	if (fflag == ON)	/* use the give file as history file */
	{
		if (hist_access (histFile) < 0)
			exit (1) ;

		strcat (histname, histFile) ;
	}
	else	/* use the cmd name */
	{
		wherehist = histname + strlen (histname) ;
		cmdName = *argv ;
		strcat (histname, getenv ("HOME"));
		strcat (histname, "/.");
		if (cmdBaseName = strrchr (cmdName, '/'))
			cmdBaseName++;
		else
			cmdBaseName = cmdName;
		strcat (histname, cmdBaseName);
		strcat (histname, "_history");

		/* check existence of file */
		if (hist_access (wherehist) < 0)
			exit (1) ;
	}

	putenv (histname);

	/* Open the history file */

	hist_open ();

	if ((fp = fc_fix) == NULL)
	{
		fprintf (stderr, "error: no such history file: %s\n", getenv ("HISTFILE")) ;
		exit (1) ;
	}

	/* Setup the valid range */

	if ((validStart = fp->fixind - fp->fixmax - 1) < 1)
		validStart = 1 ;

	validEnd = fp->fixind - 1 ;

	/* Setting the default start and end range
	 * use the maximum range if out of range
	 */

	if ((range[start] = fp->fixind - 16) < 1)
		range[start]  = validStart ;

	range[end] = fp->fixind - 1  ;
	
	if (iflag == ON)
	{
		printf ("start = %d, end = %d\n", validStart, validEnd) ;
		exit (0) ;
	}

	if (lflag == ON)
	{
		/* single element */

		if ((ptr = strchr (listRange, ',')) == NULL)
		{
			if ((range[start] = a_to_i (listRange)) < 1)
				range[start] = range[end] + range[start] + 1 ;
		}
		else	/* two numbers */
		{
			if ((range[start] = a_to_i (listRange)) < 1)
				range[start] = 0 ;
			
			if ((range[end] = a_to_i (++ptr)) < 1)
				range[end] = 0 ;
		}
		
		if (range[start] > range[end])
		{
			temp = range[end] ;
			range[end] = range[start] ;
			range[start] = temp ;
			rflag = (rflag == ON) ? OFF : ON ;
		}

		/* Set to validStart if "start" out of range */
		if ((range[start] < validStart) || range[start] > validEnd)
			range[start] = validStart ;

		/* Set to validEnd if "end" out of range */
		if ((range[end] < validStart) || range[end] > validEnd)
				range[end] = validEnd ;
	}

	/* reverse listing */

	if (rflag == ON)
	{
		incr = -1 ;
		start = END ;
		end = START ;
	}
	
	fflush (fdo) ;

	while(1)
	{
		if(nflag == ON)
			fprintf (fdo, "%d\t", range[start]) ;
		hist_list_fix (hist_position (range[start]),EOF, "\n\t");
		if (range[start] == range[end])
			exit (0) ;
		range[start] += incr;
	}
}

/* Convert string to integer with digital checking */
int a_to_i (str)
char* str ;
{
	char	*p ;

	for (p = str; *p != NULL; p++)
	{
		if (isalpha(*p) != 0)	return (NULL) ;
	}
	return (atoi(str)) ;
}

/*
 * This routine is identical to the routine hist_list ()
 * in history.c except that the "output" variable is #define to 
 * be stderr in history.c which is not what this program wants.
 * To circumvent this problem without changing the source code 
 * of the history.c, the routine is renamed and recompiled
 * under this program.
 */

static long hist_list_fix (offset,last,nl)
long offset;
int last;
char *nl;
{
	register int oldc;
	register FILE *fd;
	register int c;
	if(offset<0)
	{
		p_str (unknown, NL) ;
		return(-1);
	}
	fd = fc_fix->fixfd;
	fseek(fd,offset,0);
	oldc=getc(fd);
	for(offset++;oldc && oldc!=last;oldc=c,offset++)
	{
		if((c = getc(fd)) == EOF)
			return(offset);
		if(oldc=='\n')
		{
			if(c)
			{
				fputs(nl,output);
				continue;
			}
			/* don't print trailing newline for job control */
			else if(last=='&')
				return(offset);
		}
		putc(oldc,output);
	}
	return(offset);
}

/* To see whether the history file is accessible and the file has
 * correct history file format.
 */

static int hist_access (name)
char*	name ;
{
	FILE*	fptr ;

	if ((fptr = fopen (name, "r")) == NULL)
	{	
		fprintf (stderr, "error: no such history file: %s\n", name) ;
		return (-1) ;
	}

	/* Check to see if the file has a history format */

	if (hist_check_fix (fptr))
	{
		fprintf (stderr, "error: invalid history file: %s\n", name) ;
		fclose (fptr) ;
		return (-1) ;
	}

	fclose (fptr) ;
	return (0) ;
}

/* This is the routine to check see if the file is in
 * history format.  Because the file is delcare static
 * in the history.c, so I copy it out again and rename it.
 */

static int hist_check_fix (fd)
register FILE *fd;
{
	setbuf (fd,NULL);
	fseek (fd,0L,0);
	if(getc (fd) != H_UNDO)
		return(1);
	return(0);
}
