/* k: run a command with editing history and subcommand execution.
      (a.k.a korn shell, hold the shell) */

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#ifdef Berkeley
#	ifndef SIGCLD
#		define SIGCLD SIGCHLD
#	endif
#	include <sgtty.h>
#	include <setjmp.h>
#else
#	include <termio.h>
#endif

#define MAXLINE 255
#define PREAD 0
#define PWRITE 1
static char id[] = "@(#)k, version 1.2 experimental - 11/28/88";

#ifdef Berkeley
static jmp_buf env;
int tty_speeds[] = {0, 50, 75, 110, 134, 150, 200, 300,
			600,1200,1800,2400,9600,19200,0};
#endif


extern char *getenv();
extern int   putenv();
extern int   execl(), execvp(), fork(), pipe(), close(), wait(),
             dup(), isatty(), write();
extern int   kread();

static int   trap(), stopawhile(); endstopawhile();
static void  dowait();
static void doshell();
static char *itoa();

extern int   errno;
extern int   progdone;

static char  linebuf[MAXLINE];
static int   linelen, cmdpid, shpid;
static int   retry=0;

#ifdef Berkeley
static struct sgttyb inbuf;
#else
static struct termio inbuf;
#endif


main(argc,argv)
int argc;
char *argv[];
{
	int connector[2];
	int fd;
	char histname[1024];
	char *cmdBaseName;
	char *oldhistname;
	char *wherehist;
	char strpid[32];
#ifdef Berkeley
	int (*sighup)(), (*sigquit)(), (*sigint)(), (*sigcld)(), (*sigpipe)(),
			(*sigusr1)(), (*sigusr2)();
#else
	void (*sighup)(), (*sigquit)(), (*sigint)(), (*sigcld)(), (*sigpipe)(),
			(*sigusr1)(), (*sigusr2)();
#endif

	if (argc<2) {
		fprintf(stderr, "usage: %s command [parameters]\n", argv[0]);
		exit(1);
	}

	if (!isatty(0)) {
		execvp(argv[1], &argv[1]);
		fprintf(stderr,"%s: %s not found\n",argv[0], argv[1]);
		exit(1);
	}

#ifdef Berkeley
	ioctl(0, TIOCGETP, &inbuf);
#else
	ioctl(0, TCGETA, &inbuf);
#endif

	strcpy(strpid, "KPID=");
	strcat(strpid, itoa(getpid()));
	putenv(strpid);

	pipe(connector);

#ifdef Berkeley
	sigsetmask(0);
#endif
	sigpipe = signal(SIGPIPE,trap);
	sigcld = signal(SIGCLD,trap);
	sighup = signal(SIGHUP,trap);
	sigint = signal(SIGINT,trap);
	sigquit = signal(SIGQUIT,trap);
	sigusr1 = signal(SIGUSR1,endstopawhile); /* turn k back on*/
	sigusr2 = signal(SIGUSR2,stopawhile); /* turn off k */

	cmdpid = fork();

	if (cmdpid < 0) {
		fprintf(stderr,"%s: fork failed\n",argv[0]);
		exit(2);
	}

	if (cmdpid == 0) {		/* child process */
		signal(SIGHUP,sighup);
		signal(SIGINT,sigint);
		signal(SIGQUIT,sigquit);
		signal(SIGCLD,sigcld);
		signal(SIGPIPE,sigpipe);
		signal(SIGUSR2,sigusr2);
#ifndef kS
#ifdef Berkeley
		cmdpid = getpid();
		setpgrp(cmdpid, cmdpid);
#else
		setpgrp();
#endif
#endif
		close(0);
		dup(connector[PREAD]);
		close(connector[PREAD]);
		close(connector[PWRITE]);
		execvp(argv[1], &argv[1]);
		fprintf(stderr,"%s: %s not found\n",argv[0], argv[1]);
		exit(1);
	}

	/* parent process continues here */

#if !defined(kS) && defined(Berkeley)
	ioctl(0, TIOCSPGRP, &cmdpid);
	setpgrp(0, cmdpid);
#endif

	if (!isatty(1)) {  /* make sure stdout is tty */
		close(1);
		dup(0);
	}

	close(connector[PREAD]);

	fd = connector[PWRITE];

	if (!(oldhistname=getenv("HISTFILE")))
		oldhistname = "sh_history";

	if (getenv("NOHIST")) 
		putenv("HISTFILE=");
	else {
		strcpy (histname, "HISTFILE=");
		strcat (histname, getenv("HOME"));
		strcat (histname, "/.");
		wherehist = histname + strlen(histname);
		if(cmdBaseName = strrchr(argv[1], '/'))
			cmdBaseName++;
		else
			cmdBaseName=argv[1];
		strcat (histname, cmdBaseName);
		strcat (histname, "_history");
		putenv (histname);
	}



#ifdef Berkeley
	/* Under Berkeley, when we get a SIGCLD the read below will not be
	 * interrupted and things will hang until the user hits <cr>.
	 * This could be fixed using SV_INTERRUPT, but that would not work
	 * under 4.2.
	 */
	if( setjmp(env) != 0 ) {
		close(fd);
		dowait();
		exit(0);
	}
#endif
	while (linelen=kread(0,linebuf,MAXLINE)) {
		if (linelen>0) {
#ifndef kS
			if (linebuf[0] == '#') {
	/**/			continue;
			}
			if ((linebuf[0] == '!') && (linelen > 2)) {
				if (oldhistname) {
					strcpy (wherehist, oldhistname);
					putenv (histname);
					oldhistname = NULL;
				}
				linebuf[linelen] = '\0';

				if (linebuf[1] == '!') {
					if (linelen > 3) {
						doshell(&linebuf[2], fd, 1);
					} else
						write(fd, linebuf, linelen);
				} else
					doshell(&linebuf[1], fd, 0);

			} else if ((linebuf[0] == '\\') &&  (linelen>1) &&
				((linebuf[1] == '!') || (linebuf[1] == '#'))) {
				write(fd, linebuf+1, linelen-1);
			} else {
				write(fd, linebuf, linelen);
			}
#else
			write(fd, linebuf, linelen);
#endif
		}
		if (progdone)
			break;
	}

	close(fd);
	dowait();
	exit(0);
}


static void
dowait()
{
	int pid;

	if (cmdpid || shpid) {
		if (cmdpid == (pid = wait((int *)0))) {
			progdone = 1;
			cmdpid = 0;
#ifdef Berkeley
			longjmp(env, 1);
#endif
		} else if (shpid == pid)
			shpid = 0;
	}
}


static int
trap(sig)
int sig;
{
	int pid;

	if ((sig != SIGCLD)&&(sig != SIGPIPE)) {
		signal(sig,trap);
#if !defined(kS) && !defined(Berkeley)
		/* No need for kill if we have job control & do it right */
		kill(cmdpid,sig);
#endif
		return;
	}
	if (sig == SIGCLD) {
		dowait();
	}
}

static int state=0;
static int who=0;
#ifdef Berkeley
static struct sgttyb ttybuf;
#else
static struct termio ttybuf;
#endif


/* Certain routines such as S may execute screen editor that must 
accept input from a tty.  In these cases the program helper, that is
linked to the editor commands, is executed instead of the editor.
helper signals the k process with SIGUSER2 to "turn off" and then
executes the editor command.  When helper finishes, it signals
thek process with SIGUSER1 to "turn k back on." */

/* turn off k */
static int
stopawhile(sig)
int sig;
{
int fd;
char me[512];

	signal(SIGUSR2, stopawhile);
	retry = 1;
	/* first time through set input to tty mode */
	if (state++ == 0) {
#ifdef Berkeley
		ioctl (0, TIOCGETP, &ttybuf);
		ioctl (0, TIOCSETP, &inbuf);
#else
		ioctl (0, TCGETA, &ttybuf);
		ioctl (0, TCSETAW, &inbuf);
#endif
	}
	/* get helper pid*/
	strcpy(me, "/tmp/");
	strcat(me, itoa(getpid()));
	if( (fd = open(me, O_RDONLY)) < 0) {
		endstopawhile();
		return;
	}
	if ( read(fd, &who, sizeof(int)) != sizeof(int)) {
		close(fd);
		endstopawhile();
		return;
	}
	close(fd);

	/* signal helper to continue */
	kill(who, SIGUSR2);
	/* wait for helper to signal */
	while(state != 0) {
#ifdef Berkeley
		sigpause(0);
#else
		pause();
#endif
	}
	return;
}


/* restore tty to original state and reset state*/
endstopawhile()
{
	signal(SIGUSR1, endstopawhile);
#ifdef Berkeley
	ioctl (0, TIOCSETP, &ttybuf);
#else
	ioctl (0, TCSETAW, &ttybuf);
#endif
	state = who = 0;
	return;
}


static void
doshell(cmd, fd, shpipe)
char *cmd;
int fd;
int shpipe;
{
	int ourpgrp;

	signal(SIGCLD,SIG_DFL);
	signal(SIGINT,SIG_IGN);

	shpid = fork();

	if (shpid < 0) {
		fprintf(stderr,"fork failed, cmd not executed\n");
		return;
	}

	if (shpid  == 0) {		/* child process */
		signal(SIGHUP,SIG_DFL);
		signal(SIGPIPE,SIG_DFL);
		signal(SIGINT,SIG_DFL);
		signal(SIGQUIT,SIG_DFL);
		if (shpipe) {
			close(1);
			dup(fd);
		}
		close(fd);
#ifdef Berkeley
		shpid = getpid();
		setpgrp(shpid, shpid);
#endif
		execl("/bin/sh", "sh", "-c", cmd, 0);
		_exit(1);
	}

	/* parent continues here */

#ifdef Berkeley
	ioctl(0, TIOCSPGRP, &shpid);
	setpgrp(0, shpid);
#endif
	while(shpid) {
		dowait();
	}

#ifdef Berkeley
	ioctl(0, TIOCSPGRP, &cmdpid);
	setpgrp(0, cmdpid);
#endif
	signal(SIGCLD,trap);
	signal(SIGINT,trap);
}



static char *
itoa(val)
int val;
{
static char buf[16];
char *now;

	buf[15] = '\0';
	now = &buf[14];

	while (val) {
		*now-- = '0' + (val % 10);
		val = val / 10;
	}
	return (now+1);
}
