/* default file for color table i/o */
#define COLORFILE	"Colors"

/* symbolic indices */
#define R		0
#define G		1
#define B		2
#define H		0
#define L		1
#define S		2
#define X		0
#define Y		1

/* upper left pixel of palette */
#define PX		486
#define PY		509

/* circle specs */
#define CX		463
#define CY		496
#define CRADIUS		14
#define CRADCOS60	7
#define CRADSIN60	12
#define VX		256
#define VY		240
#define VRADIUS		240

/* commands */
#define NUM_PALETTE	'7'
#define NUM_PICTURE	'8'
#define NUM_NUM		'9'
#define MIX_CIRCLE	'4'
#define MIX_VIRT	'5'
#define MIX_SAME	'6'
#define SAVE		'1'
#define SPECIFICATION	'2'
#define SHOW_COLOR	'3'
#define LIGHTNESS	'.'
#define QUIT		'0'
#define BLINK		'b'
#define CIRCLE		'c'
#define RECTANGLE	'r'
#define FILL		'f'
#define TEXT		't'
#define WRITE		'w'
#define SHELL		'!'

/* how color was generated */
#define FORMULA		1
#define MIXED		2
#define NA		(-1)

/* miscellaneous */
#define NO		0
#define YES		1

struct COL {
	int HLS[3];
	int known;
};

#ifdef NOEXTERN
#define EXTERN
#else
#define EXTERN extern
#endif

EXTERN char cmd_buf;
EXTERN char *readfile, *writefile;
EXTERN int cur_color, cur_mix[3];
EXTERN int pal_drawn, circle_drawn;
EXTERN int def_setup, interactive;
EXTERN int no_seq;
EXTERN int changed;

EXTERN struct COL Colors[256];
