/* used on aed512 terminal to scan through multiple pictures, either arranged
 * on separate bit planes or in multiple figures on the screen (using zoom).
 * Args are
 * rn	number of rows
 * cn	number of columns
 * pn	number of padding chars between views (default 30)
 * e	erase screen first
 * b	use keyboard buttons to control which view presented
	> or < (unshifted) to go to next or prev view
	1234567890:qwerty...   to go to specified view
 * j	change amount of padding based on joystick position
 * mn,o,p	memory planes.  n may be several digits, e.g.
	m034,3 would display planes 0,3, and 4, then 3 alone
 */
#include "aed.h"
#include "stdio.h"

#define NO_OP		033
#define INCREASE	(-1)
#define DECREASE	(-2)
#define UNKNOWN		(-3)
#define abs(x)		(x < 0 ? -x : x)
#define betw(x,y,z)	(x <= y && y <= z)

int mask[8] = {1,2,4,8,16,32,64,128};

main(ac,av)
char **av;
{
	int nrow, ncol, npad, npic;
	int row, col, i, index, er;
	int plane[20], buttons, n;
	int x, y, joy;
	char c;

	npad = 30;
	nrow = ncol = npic = 0;
	er = 1; buttons = 0;
	for(i = 1; i < ac; i++)
		switch(*av[i]) {
		case 'r':
			if((nrow = atoi(++av[i])) < 1)
				error("number of rows must be a positive integer");
			break;
		case 'c':
			if((ncol = atoi(++av[i])) < 1)
				error("number of columns must be a positive integer");
			break;
		case 'p':
			if((npad = atoi(++av[i])) < 0)
				error("number of pads must be a non-negative integer");
			break;
		case 'm':
			while(index = (c = *++av[i]) - '0',c) {
				if(c == ',')
					npic++;
				else if(!betw(0, index, 7))
					error("memory planes must be between 0 and 7");
				else
					plane[npic] += mask[index];
			}
			npic++;
			break;
		case 'e':
			er = 0;
			break;
		case 'b':
			buttons++;
			break;
		case 'j':
			joy++;
			break;
		}
	if(nrow == 0 && ncol == 0)
		nrow = ncol = 1;
	else {
		nrow = nrow ? nrow : ncol;
		ncol = ncol ? ncol : nrow;
	}
	if(npic == 0)
		plane[npic++] = 255;
	startup(0);
	if(er) {
		w_mask(mask[7]);
		erase();
		w_mask(255);
	}
	zoom(ncol, nrow);
	r_mask(*plane);
	index = 0;
	if(buttons) for(;;) {
		switch(n = getnum()) {
		case INCREASE:
			index++;
			break;
		case DECREASE:
			index--;
			break;
		case UNKNOWN:
			break;
		default:
			index = n;
			break;
		}
		index = abs(index);
		r_mask(plane[index % npic]);
		n = (index / npic) % (nrow * ncol);
		row = nrow - n / ncol;
		col = n % ncol;
		origin(col*512/ncol, row*483/nrow);
	} else for(;;) {
		for(row = nrow; row > 0; row--)
			for(col = 0; col < ncol; col++) {
				origin(col*512/ncol, row*483/nrow);
				for(index = 0; index < npic; index++) {
					r_mask(plane[index]);
					if(joy) for(;;) {
						read_joystick(&x, &y);
						npad = (511 - y) * 4;
						if(npad < 2040)
							break;
					}
					for(i = 0; i < npad; i++)
						putchar(NO_OP);
				}
			}
	}
}

error(s)
char *s;
{
	printf("%s\n", s);
	exit();
}

char keyboard[] =
"1234567890:-\
qwertyuiop\
asdfghjkl;\
zxcvbnm";

getnum()
{
	char c, *s;

	raw();
	fflush(stdout); read(0, &c, 1);
	restore();
	if(c == ',')
		return(DECREASE);
	if(c == '.')
		return(INCREASE);
	s = keyboard;
	while(*s)
		if(c == *s++)
			return(s - keyboard);
	return(UNKNOWN);
}
