#include <math.h>
#include "color.h"

static double pi = 3.14159265;

int *rgb(hls)
int *hls;
{
	static int intensity[3];
	int h, l, s, M, m;

	h = hls[H] %= 360;
	l = hls[L] = min(100, max(0, hls[L]));
	s = hls[S] = min(100, max(0, hls[S]));
	M = l*100 + s*(l > 50 ? 100-l : l);
	M = 51*M/2000;
	m = 51*l/10 - M;
	intensity[R] = gun(m, M, h);
	intensity[G] = gun(m, M, h-120);
	intensity[B] = gun(m, M, h-240);
	return(intensity);
}

gun(m, M, h)
int m, M, h;
{
	if(h < 0)
		h += 360;
	if(h < 60)
		return(m + h*(M-m)/60);
	if(h < 180)
		return(M);
	if(h < 240)
		return(m + (240-h)*(M-m)/60);
	return(m);
}

fill_table()
{
	char *dfcn();
	int i;

	if(interactive)
		dfcn("filling table...", NO);
	for(i = 0; i < 256; i++)
		if(Colors[i].known > 0)
			set_table(i, Colors[i].HLS);
}

set_table(color, hls)
int color, *hls;
{
	int *rgb();

	set_color(color, rgb(hls));
}

rect_to_h(rect, hls, radius)
int *rect, *hls, radius;
{
	double h;

	h = atan2((double)rect[Y]/radius, (double)rect[X]/radius) / pi;
	if(h < 0)
		h += 2;
	hls[H] = h * 180;
	h = sqrt((double)(rect[X]*rect[X] + rect[Y]*rect[Y]));
	hls[S] = 100 * (int)h / radius;
	if(hls[S] > 100)
		hls[S] = 100;
}

h_to_rect(hls, rect, radius)
int *hls, *rect, radius;
{
	rect[X] = radius * hls[S] * cos(hls[H]*pi/180) / 100;
	rect[Y] = radius * hls[S] * sin(hls[H]*pi/180) / 100;
}

min(a,b)
int a, b;
{
	return(a < b ? a : b);
}

max(a,b)
int a, b;
{
	return(a > b ? a : b);
}

betw(low, i, high)
{
	return(low <= i && i <= high);
}

hcopy(ha, hb)
int *ha, *hb;
{
	hb[H] = ha[H];
	hb[L] = ha[L];
	hb[S] = ha[S];
}

empty(list, n)
int *list, n;
{
	int i, j;

	i = 256; j = 0;
	while(--i && j < n)
		if(Colors[i].known == 0) {
			Colors[i].known = NA;
			*list++ = i;
			j++;
		}
	return(j);
}

char *specbuf;
int speccur = 0;

addspec(string)
char *string;
{
	int n;
	char *malloc(), *realloc();
	static int first = 1, size = 512;

	if(first) {
		if((specbuf = malloc(size)) == 0)
			return;
		first = 0;
	}
	if((n = strlen(string) + 1) == 1)
		return;
	while(n > size - speccur)
		if((specbuf = realloc(specbuf, size += 512)) == 0)
			return;
	strcpy(specbuf + speccur, string);
	speccur += n;
}
