#perma           permutes the elements of an array, according to
#           a permutation of the dimension vector 1,2,...,n.
#
subroutine perma(a,dmode,n,aext,perm,b,bext)
#a is input array, n is no. of dimensions, aext is vector of extensions
#in each dimension, perm is permutation of dimension vector (simply
#new ordering, not the extents), b is output array, bext is vector of
#extensions for b.
INCLUDE(stack)
POINTER a,b,i,j,p,lc,ss,pc
integer dmode,prod,n,aext(1),bext(1),perm(1)
lc=jstkgt(3*n,2) 	#loop counter
ss=lc+n 	#step size (depends on more rapidly var. indices)
pc=ss+n 	#resets pointer (step size * loop counter)
prod=1
for(i=1;i<=n;i=i+1){ 	#set up vectors for loop control
	is(lc+i-1)=0
	bext(i)=aext(perm(i)) 	#extents for array b
	is(ss+perm(i)-1)=prod 	#calculate step sizes
	prod=prod*bext(i)
	is(pc+perm(i)-1)=prod 	#correction for position pointer into array b
	} 	#final value of prod is total length of array
p=0 	#pointer into array b
for(j=0;j<prod;j=j+1){ 	#step thru array a
	call pcopy(a+j,b+p,1,dmode)
	for(i=0;i<n;i=i+1){
		p=p+is(ss+i) 	#set pointer for accessing b
		is(lc+i)=is(lc+i)+1
		if(is(lc+i)<aext(i+1))break 	#always exit here
		is(lc+i)=0 	#reset counter
		p=p-is(pc+i) 	#reset pointer
		}
	}
call jstkrl(1)
return
end
