#alink		link to function from within another function
#	used by apply, sapply, tapply
POINTER function alink(fun, instr, action)
POINTER fun,instr; integer action
#fun: pointer to function name
#instr: input arg structure for function.

INCLUDE(struct,stack,link,u/infun,u/link)

common/intern/intern	# was executed function internal?
logical intern
POINTER savnam,outstr,ientry,name,istrng,gtds
integer cseek,curpos
SAVE(name)

alink=0	# default
switch(action){
case STARTUP:
case WRAPUP: 
	if(inflen<=0) call killem	# kill underlying process if apply is not part of executive
case EXECUTE:
	name=istrng(TEXT(fun),-1) # copy of name (alias may overwrite)
	savnam=SNAME(instr); SNAME(instr)=fun #make instr look like call to fun
	call link(TEXT(name),ientry(NULL,STR,0,instr),NORMAL_FUN,outstr,print)
	if(!intern && outstr!=NULL){
		curpos=cseek(STACKFD,0,1)	# current stack file position
		if(cseek(STACKFD,outstr,0) != outstr) FATAL(Cannot find result on stack file)
		outstr=gtds(STACKFD)
		curpos=cseek(STACKFD,curpos,0)	# restore stack file
		}
	SNAME(instr)=savnam # restore name
	alink=outstr
	}
return
end
