ROUTINE(approx,		linear approximation to function defined by discrete values)
subroutine approx(x,y,n,xout,nout,rule,yout,iscr)
# assumes x sorted
real x(n),y(n),xout(nout),yout(nout)
integer rule,iscr(nout)

integer where,i,j
real thisx,f

call rcopy(xout,yout,nout)
call sortl(yout,nout,iscr)
j=1	# current x pointer
for(i=1; i<=nout; i=i+1){
	where=iscr(i)	# current xout pointer
	thisx=xout(where)
	while( j<n & x(j)<thisx )  j=j+1	# move j up so x(j-1) < thisx <= x(j)
	if(j==1)	# beyond (or at) left end of data
		if(thisx==x(1)) yout(where) = y(1)
		else switch(rule){
		case 1: NASET(yout(where))
		case 2: yout(where)=y(1)	# copy
			}
	else if(j==n & thisx>x(j))	# beyond right end of data
		switch(rule){
		case 1: NASET(yout(where))
		case 2: yout(where)=y(n)	# copy
			}
	else {
		f = (thisx-x(j-1))/(x(j)-x(j-1))
		yout(where) = (1.-f)*y(j-1) + f*y(j)
		}
	}
return
end
