ROUTINE(cancor,		compute canonical correlations, w. dev, scaling)
subroutine cancor(x,n,kx,y,ky,d,vx,vy)
integer n,kx,ky
real x(n,kx),y(n,ky),vx(kx,kx),vy(ky,ky),d(1)

real norm,snrm2; integer i,j
INCLUDE(stack)

call dev(x,n,n,kx,x,vx)
call dev(y,n,n,ky,y,vy)

call bgsc(x,n,kx,y,ky,vx,vy,d)
# scale the coefficients
do j=1,kx {
	norm=snrm2(kx,vx(1,j),1) #scale j-th column to unit length
	if(norm>0) do i=1,kx {vx(i,j)=vx(i,j)/norm}
	}
do j=1,ky {
	norm=snrm2(ky,vy(1,j),1) #scale j-th column to unit length
	if(norm>0) do i=1,ky {vy(i,j)=vy(i,j)/norm}
	}
return
end
