subroutine hroff(file,lwidth,justCS)
integer file,lwidth; logical justCS

INCLUDE(struct,stack,read,print,io)

integer indent,narg; logical fill, gotCS, ignore
CHARACTER(jgetch,1)
CHARACTER(cmd,2)
data indent/0/
nspace=min0(10,max0(1,lwidth/10))
fill=TRUE; gotCS = FALSE; ignore = FALSE
narg=0
repeat{
	GETLINE(file); AUTO_CHECK=FALSE
	if(EOF)break
	if(jgetch(INBUF,1)=="."){	#formatting command
		cmd=" "; call concat(cmd,1,INBUF,2,2)

		if(cmd=="HL") next		# conditional execution
		if(cmd=="EN") { ignore = FALSE; next }
		if(cmd=="TR") { ignore = TRUE; next }	# troff only
		if(ignore) next

		if(justCS){
			if(cmd=="CS") gotCS=TRUE
			else if(gotCS) return
			}
		LASTCH=LASTCH-4
		if(LASTCH>0) call concat(INBUF,1,INBUF,5,LASTCH+1)	# squash out the .XX (preserve EOS)
		else call jputch(INBUF,1,EOS)
# flush partially finished lines if a recognized command; otherwise ignore
		if(cmd=="AG"|cmd=="RC"|cmd=="IP"|cmd=="CS"|cmd=="TL"|cmd=="PP"|
			cmd=="WR"|cmd=="EX"|cmd=="SH"|cmd=="RT"|cmd=="NF")
				if(BUFPOS>0) FPRINT(OUTFC)

		if(cmd=="AG"){	# an argument
			fill=TRUE
			narg=narg+1
			if(narg==1) FPRINT(OUTFC,"ARGUMENTS:")
			ENCODE(C(INBUF),":",T(nspace-1))
			indent=nspace
			}
		else if(cmd=="RC") {	# returned component
			fill=TRUE
			ENCODE(C(INBUF),":",T(nspace-1))
			indent=nspace
			}
		else if(cmd=="IP") {	# indented paragraph
			fill=TRUE
			SKIP(OUTFC)
			ENCODE(C(INBUF),T(nspace-1))
			indent=nspace
			}
		else if(cmd=="CS" | cmd=="TL") {	# calling seq/title
			fill=FALSE
			FPRINT(OUTFC)
			indent=0
			}
		else if(cmd=="NF") {	# paragraph
			fill=FALSE
			indent=nspace
			}
		else if(cmd=="PP") {	# paragraph
			fill=TRUE
			FPRINT(OUTFC)
			indent=0
			}
		else if(cmd=="RT") {	# value returned
			fill=TRUE
			SKIP(OUTFC)
			FPRINT(OUTFC,"VAL","UE:")
			ENCODE(T(nspace-1))
			indent=nspace
			}
		else if(cmd=="EX") {	# examples
			fill=FALSE
			SKIP(OUTFC)
			FPRINT(OUTFC,"EXAMPLES:")
			indent=nspace
			}
		else if(cmd=="SH") {	# section heading
			fill=TRUE
			SKIP(OUTFC)
			FPRINT(OUTFC,C(INBUF))
			indent=0
			}
		}
	else if(ignore) next
	else if(fill)call hrfld(indent,OUTFC,lwidth)
	else FPRINT(OUTFC,T(indent),C(INBUF))
	}
return
end
