#sift - picks out names, arguments & their defaults in definition string
# used by define
subroutine sift(buffer, eol, infile)
INCLUDE(macro,cnev)
integer buffer(1), eol, infile, nlb
integer eosloc, i, istart, itok, t, token(10), mcro(6)
logical newnam, dmode
integer equal, type	#functions

nargs = 0	#initialization
call unpakl(TSTRING(MACRO),mcro)

#look for the first valid character
i = 0
call incri(i, buffer, eol, infile, TRUE)# 1st nonblank
istart=i
for(itok=1; itok<=5; itok=itok+1){
	token(itok) = buffer(i)
	call incri(i, buffer, eol, infile, FALSE)
	}
token(itok) = MACROEOS
if(equal(mcro, token) == NO) {
	WARNING(Definition should start with the word MACRO)
	i=istart
	}
else if(buffer(i)==M_BLANK)call incri(i, buffer, eol, infile, TRUE)
else FATAL(bad macro name)

#find macro name & set pointer
if(buffer(i)==QUESTION)call incri(i, buffer, eol, infile, FALSE)
if(type(buffer(i))!=LETTER)FATAL(invalid macro name)

#set pointer and find start of args
pname = i
repeat{
	call incri(i, buffer, eol, infile, FALSE)
	t = type(buffer(i))
	if(i == BUFSIZE && (t == LETTER|t == DIGIT)){	#case: macro name ends at end of buffer
		buffer(i+1) = MACROEOS	#mark its end
		return
		}
	if(t==LETTER|t==DIGIT)next
	else if(t==M_NEWLINE){buffer(i)=MACROEOS; return}
	else if(t==M_BLANK){
		buffer(i)=MACROEOS
		call incri(i, buffer, eol, infile, TRUE)
		break
		}
	else break
	}

if(buffer(i)!=LPAREN)FATAL(illegal character in macro name)
#lparen found; change to eos to mark end of name
buffer(i) = MACROEOS
eosloc = i
call incri(i, buffer, eol, infile, TRUE)
if(buffer(i) == RPAREN){
	buffer(i) = MACROEOS	#mark end of macro name
	return	#no arguments found
	}
else{
	#check legality of first character in arglist
	t = type(buffer(i))
	if(t != LETTER)
		FATAL(first character in argument list is illegal)
	#first char OK; record its appearance
	nargs = 1
	pargs(nargs) = i
	pdflts(nargs) = eosloc
	newnam = FALSE
	}

dmode = FALSE	#setting up

#scan the rest of the string, setting arg and default pointers
repeat{
	call incri(i, buffer, eol, infile, newnam)
	t = type(buffer(i)); newnam = FALSE
	if(dmode && buffer(i) != SLASH){ #inside default: check for ?()
		if(buffer(i) != QUESTION)
			next	#it is a regular character
		else{ #possible literal
			call incri(i, buffer, eol, infile, FALSE)
			if(buffer(i) != LPAREN)
				next	#free-standing "?"
			else{ #case: ?(literal)
				nlb = 1
				repeat{
					call incri(i, buffer, eol, infile, FALSE)
					if(buffer(i) == LPAREN)
						nlb = nlb + 1
					else if(buffer(i) == RPAREN){
						nlb = nlb - 1
						if(nlb == 0) break	#parens balanced
						}
					else if(buffer(i) == EOF)
						FATAL(unexpected end-of-file in default literal)
					}
				}
			}
		}
	else if(t == LETTER|t == DIGIT|t == M_BLANK|t == M_NEWLINE){
		if(pdflts(nargs) != eosloc)
			FATAL(missing comma)
		next	#uninteresting character
		}
	else if(buffer(i) == RPAREN){
		buffer(i) = MACROEOS	#mark end
		return
		}
	else if(buffer(i) == SLASH){
		#beginning or end of default string
		buffer(i) = MACROEOS	#mark its appearance
		if(dmode){
			dmode = FALSE	#end of default string
			}
		else{
			dmode = TRUE	#beginning of default string
			pdflts(nargs) = i + 1	#first char of default string
			}
		}
	else if(buffer(i) == COMMA){
		#comma found (outside default string)
		buffer(i) = MACROEOS
		nargs = nargs + 1
		pargs(nargs) = i + 1
		pdflts(nargs) = eosloc
		newnam = TRUE
		}
	else if(buffer(i) == EQUAL)
		next	#argument in arg=// form
	else FATAL(illegal char in argument name)
	}

#program shouldn't get here
FATAL(<sift> abnormal exit from argument scan)

return
end
