ROUTINE(mstree,		friedman-rafsky tow-sample planing and lining by spanning tree)
define(`SHORT',integer)
define(`BIG',1e35)
define(`EPS',1e-30)
#
# program implementing friedman - rafsky two-sample graphics
# version of 7/17/78.
#
# coded by j. h. friedman
#          stanford linear accelerator center
#          p. o. box 4349, stanford ca. 94305, usa.
#          (415) 854-3300  x2256
#
# call mstree(p,n,data,deg,mst,order,plane)
#
# integer p,n
#
# real data(p,n),deg(n,2),plane(2,n)
#
# SHORT  mst(n,5),order(n,2)
#
#   p = dimension (number of columns of data matrix).
#   n = sample cardinality (number of rows of data matrix) .
#   data = pooled sample data matrix.
#   deg = scratch storage for mstree. upon return
#         deg(1:n,1) contain the degree of each node (point)
#         in the mst.
#   mst = scratch storage for mstcpr. upon return
#         the integer pairs (i,mst(i,1)), i=1,n-1
#         label the node pairs defining edges of the pooled
#         sample mst.
#
# output quanities:
#
#   order(1:n,1) = rank vector for "standard" (linear)
#                  multivariate sequence.
#   order(1:n,2) = rank vector for "radial" multivariate sequence.
#
#   plane(1:2,1:n) = planar locations of observations resulting
#                      from multivariate planing procedure.
#
#   note: the indicies 1:n above correspond to the rows of the
#         data matrix, data(1:p,1:n).
#
# labeled commons:
#
# common /dump/ dodump
#
#   logical dodump
#
#   dodump = print flag for dumping intermediate results during
#            planing. used for debugging purposes.
#          = .true., dumping enabled.
#          = .false., dumping disabled.
#            (default value = .false.)
#
# note:
#   if fortran compiler does not support SHORT  declarations,
#   then all such declarations in program must be changed to
#   integer.
#
#
subroutine prim(m,n,points,mst,ui,ji,nit)
integer m,n
real points(m,n),ui(n)
SHORT mst(n),ji(n),nit(n)
nitp = n-1
kp = n
do i = 1,nitp {
	nit(i) = i
	ui(i) = BIG
	}
repeat {
	do i = 1,nitp {
		ni = nit(i)
		d = 0.0
		do i001 = 1,m
			d = d+(points(i001,ni)-points(i001,kp))**2
		if (ui(i)>d) {
			ui(i) = d
			ji(i) = kp
			}
		}
	uk = ui(1)
	do i = 1,nitp
		if (ui(i)<=uk) {
			uk = ui(i)
			k = i
			}
	kp = nit(k)
	mst(kp) = ji(k)
	ui(k) = ui(nitp)
	nit(k) = nit(nitp)
	ji(k) = ji(nitp)
	nitp = nitp-1
	}
	until(nitp==0)
return
end



subroutine mstree(d,n,x,deg,istor,order,x2)
integer d,n
real x(d,n),deg(n,2),x2(2,1)
SHORT istor(1),order(n,1)
integer ttn,ftn,node
nm1 = n-1
ttn = n+n
ftn = ttn+ttn
call prim(d,n,x,istor,deg,istor(ttn+1),istor(ftn+1))
do j = 1,nm1
	deg(j,1) = 1.0
deg(n,1) = 0.0
do j = 1,nm1
	deg(istor(j),1) = deg(istor(j),1)+1.0
istor(ftn+1) = 0
do j = 2,n
	istor(ftn+j) = istor(ftn+j-1)+deg(j-1,1)
do j = 1,nm1 {
	istor(ftn+j) = istor(ftn+j)+1
	istor(ttn+istor(ftn+j)) = istor(j)
	node = istor(j)
	istor(ftn+node) = istor(ftn+node)+1
	istor(ttn+istor(ftn+node)) = j
	}
istor(ftn+1) = 0
do j = 2,n
	istor(ftn+j) = istor(ftn+j-1)+deg(j-1,1)
call map(x,d,n,deg,istor(ftn+1),istor(ttn+1),istor,deg(1,2),order,x2)
call restor(istor,n,deg,istor(ftn+1),istor(ttn+1),deg(1,2))
return
end



subroutine map(x,d,n,deg,pntr,auux,stack,depth,order,x2)
integer d,n,maxdph,enddia,center,diaend
real x(d,1),deg(1),depth(1),x2(2,1)
SHORT pntr(1),auux(1),stack(2,1),order(n,1)
maxdph = n+1
call maxtag(1,deg,pntr,auux,stack,n,depth)
enddia = diaend(1,deg,pntr,auux,depth,maxdph)
call maxtag(enddia,deg,pntr,auux,stack,n,depth)
call msline(enddia,deg,pntr,auux,depth,x,d,n,stack,order)
maxdph = depth(enddia)/2.0+1.0
center = diaend(enddia,deg,pntr,auux,depth,maxdph)
call radlin(x,d,n,center,deg,pntr,auux,stack,depth,order(1,2))
call planit(x,d,n,center,deg,pntr,auux,stack,depth,x2)
return
end



subroutine msline(root,deg,pntr,auux,depth,x,d,n,stack,order)
integer root,d,n,node,stkptr,parent,nxt,son,it
real depth(1),deg(1),x(d,1)
SHORT pntr(1),auux(1),stack(1),order(1)
node = root
parent = 0
stkptr = parent
deg(node) = -deg(node)
it = 1
order(1) = node
repeat {
	jdeg = abs(deg(node))
	nxt = 0
	dphmin = BIG
	do i = 1,jdeg {
		son = auux(pntr(node)+i)
		if (deg(son)>0)
			if (depth(son)<dphmin) {
				dphmin = depth(son)
				nxt = son
				}
		}
	if (nxt!=0) {
		stkptr = stkptr+1
		parent = node
		stack(stkptr) = parent
		node = nxt
		it = it+1
		order(it) = node
		deg(node) = -deg(node)
		}
	else {
		if (stkptr==0)
			break 1
		node = stack(stkptr)
		parent = 0
		if (stkptr>1)
			parent = stack(stkptr-1)
		stkptr = stkptr-1
		}
	}
do i = 1,n
	deg(i) = abs(deg(i))
return
end



subroutine radlin(x,d,n,start,deg,pntr,auux,stack,depth,order)
integer d,start,n,node,stkptr,parent,nxt,istart
real x(d,n),depth(1),deg(1)
SHORT pntr(1),auux(1),stack(n,1),order(1)
node = start
parent = 0
istart = 1
stkptr = 0
repeat {
	jdeg = abs(deg(node))
	i = istart
	repeat {
		if (i>jdeg)
			go to 210
		nxt = auux(pntr(node)+i)
		if (nxt!=parent)
			break 1
		i = i+1
		}
	stkptr = stkptr+1
	stack(stkptr,1) = node
	stack(stkptr,2) = i+1
	parent = node
	node = nxt
	istart = 1
	Next 1
	210  depth(node) = stkptr
	if (stkptr==0)
		break 1
	node = stack(stkptr,1)
	parent = 0
	if (stkptr>1)
		parent = stack(stkptr-1,1)
	istart = stack(stkptr,2)
	stkptr = stkptr-1
	}
do i = 1,n
	order(i) = i
call mssort(depth,order,1,n)
m = 0
repeat {
	m = m+1
	m0 = m
	while (depth(m)==depth(m+1)) {
		m = m+1
		if (m>=n)
			break 1
		}
	if (m>m0) {
		do j = m0,m {
			kj = order(j)
			depth(j) = 0
			do i = 1,d
				depth(j) = depth(j)+(x(i,kj)-x(i,start))**2
			}
		call mssort(depth,order,m0,m)
		}
	}
	until(m>=n)
return
end



subroutine planit(x,d,n,start,deg,pntr,auux,stack,depth,x2)
integer d,start,n,node,stkptr,parent,nxt,istart,propts,frthst
integer grandp,other,princp
real x(d,n),depth(1),deg(1),x2(2,1)
SHORT pntr(1),auux(1),stack(n,1)
common/dump/dodump
logical dodump
node = start
parent = 0
istart = 1
stkptr = 0
repeat {
	jdeg = abs(deg(node))
	i = istart
	repeat {
		if (i>jdeg)
			go to 220
		nxt = auux(pntr(node)+i)
		if (nxt!=parent)
			break 1
		i = i+1
		}
	stkptr = stkptr+1
	stack(stkptr,1) = node
	stack(stkptr,2) = i+1
	parent = node
	node = nxt
	istart = 1
	Next 1
	220  depth(node) = stkptr
	x2(1,node) = parent
	if (stkptr==0)
		break 1
	node = stack(stkptr,1)
	parent = 0
	if (stkptr>1)
		parent = stack(stkptr-1,1)
	istart = stack(stkptr,2)
	stkptr = stkptr-1
	}
do i = 1,n {
	stack(i,1) = x2(1,i)
	stack(i,2) = i
	}
call mssort(depth,stack(1,2),1,n)
m = 0
x2(1,start) = 0.0
x2(2,start) = x2(1,start)
deg(start) = -deg(start)
repeat {
	m = m+1
	m0 = m
	while (depth(m)==depth(m+1)) {
		m = m+1
		if (m>=n)
			break 1
		}
	if (m!=1) {
		if (m>m0) {
			do j = m0,m {
				node = stack(j,2)
				parent = stack(node,1)
				depth(j) = 0.0
				do i01 = 1,d
					depth(j) = depth(j)+(x(i01,node)-x(i01,parent))**2
				depth(j) = -depth(j)
				}
			call mssort(depth,stack(1,2),m0,m)
			}
		repeat {
			k = m0
			while (deg(stack(k,2))<=0.0) {
				k = k+1
				if (k>m)
					break 1
				}
			if (k>m)
				break 1
			propts = stack(k,2)
			parent = stack(propts,1)
			grandp = stack(parent,1)
			if (grandp==0) {
				x2(1,propts) = 0.0
				do i01 = 1,d
					x2(1,propts) = x2(1,propts)+(x(i01,propts)-x(i01,start))**2
				x2(1,propts) = sqrt(x2(1,propts))
				x2(2,propts) = 0.0
				deg(propts) = -deg(propts)
				other = propts
				}
			else {
				dstmax = 0.0
				do j = 1,m
					if (deg(stack(j,2))<=0.0) {
						node = stack(j,2)
						if (node!=parent&&node!=grandp)
							if ((x2(1,node)-x2(1,parent))**2+(x2(2,node)-x2(2,parent))**2>=EPS) {
								dist = 0.0
								do i01 = 1,d
									dist = dist+(x(i01,propts)-x(i01,node))**2
								if (dist>dstmax) {
									dstmax = dist
									frthst = node
									}
								}
						}
				dstpar = 0.0
				do i01 = 1,d
					dstpar = dstpar+(x(i01,propts)-x(i01,parent))**2
				dstpar = sqrt(dstpar)
				dstgpr = 0.0
				do i01 = 1,d
					dstgpr = dstgpr+(x(i01,propts)-x(i01,grandp))**2
				dstgpr = sqrt(dstgpr)
##				if (dodump)
#					write(6,230)propts,frthst,parent,grandp
				call plot2(x2(1,frthst),x2(1,parent),x2(1,grandp),sqrt(dstmax),dstpar,dstgpr,x2(1,propts))
				deg(propts) = -deg(propts)
				}
			if ((x2(1,propts)-x2(1,parent))**2+(x2(2,propts)-x2(2,parent))**2>=EPS)
				princp = propts
			else
				princp = frthst
			jdeg = abs(deg(parent))
			do i = 1,jdeg {
				node = auux(pntr(parent)+i)
				if (node!=grandp&&node!=propts) {
					dstprn = 0.0
					do i01 = 1,d
						dstprn = dstprn+(x(i01,node)-x(i01,princp))**2
					dstprn = sqrt(dstprn)
					dstpar = 0.0
					do i01 = 1,d
						dstpar = dstpar+(x(i01,node)-x(i01,parent))**2
					dstpar = sqrt(dstpar)
					if (grandp!=0)
						other = grandp
					dstoth = 0.0
					do i01 = 1,d
						dstoth = dstoth+(x(i01,node)-x(i01,other))**2
					dstoth = sqrt(dstoth)
##					if (dodump)
#						write(6,240)node,princp,parent,other
					call plot2(x2(1,princp),x2(1,parent),x2(1,other),dstprn,dstpar,dstoth,x2(1,node))
					deg(node) = -deg(node)
					other = node
					}
				}
			m0 = k+1
			}
			until(m0>m)
		if (m>=n)
			break 1
		}
	}
return
#230  format(" propts,frthst,parent,grandp ="4i5)
#240  format(" node,princp,parent,other ="4i5)
end



subroutine plot2(x1,x2,xc,r1,r2,rc,xn)
real xa(2),xb(2),xc(2),xna(2),xnb(2),xn(2),ra,rb,rc
real dsq,d,d1,s,tmp,x1(2),x2(2)
common/dump/dodump
logical dodump
if (r1>=r2) {
	ra = r2
	rb = r1
	xa(1) = x2(1)
	xa(2) = x2(2)
	xb(1) = x1(1)
	xb(2) = x1(2)
	}
else {
	ra = r1
	rb = r2
	xa(1) = x1(1)
	xa(2) = x1(2)
	xb(1) = x2(1)
	xb(2) = x2(2)
	}
dsq = (xa(1)-xb(1))**2+(xa(2)-xb(2))**2
d = sqrt(dsq)
if (d>=ra+rb||d<=rb-ra) {
	d1 = ra/d
	if (d<=rb-ra)
		d1 = -d1
	xn(1) = (xb(1)-xa(1))*d1+xa(1)
	xn(2) = (xb(2)-xa(2))*d1+xa(2)
#	if (dodump)
#		write(6,250)
	}
else {
	d1 = (dsq+ra**2-rb**2)*0.5/d
	s = sqrt(ra**2-d1**2)/d
	d1 = d1/d
	xna(1) = (xb(2)-xa(2))*s
	xnb(1) = -xna(1)
	xna(2) = (xa(1)-xb(1))*s
	xnb(2) = -xna(2)
	tmp = xa(1)+(xb(1)-xa(1))*d1
	xna(1) = xna(1)+tmp
	xnb(1) = xnb(1)+tmp
	tmp = xa(2)+(xb(2)-xa(2))*d1
	xna(2) = xna(2)+tmp
	xnb(2) = xnb(2)+tmp
	if (abs(sqrt((xc(1)-xna(1))**2+(xc(2)-xna(2))**2)-rc)>abs(sqrt((xc(1)-xnb(1))**2+(xc(2)-xnb(2))**2)-rc)) {
		xn(1) = xnb(1)
		xn(2) = xnb(2)
		}
	else {
		xn(1) = xna(1)
		xn(2) = xna(2)
		}
#	if (dodump)
#		write(6,260)
	}
#if (dodump) {
#	dst1 = sqrt((x1(1)-xn(1))**2+(x1(2)-xn(2))**2)
#	dst2 = sqrt((x2(1)-xn(1))**2+(x2(2)-xn(2))**2)
#	write(6,270)r1,dst1,r2,dst2
#	write(6,280)x1(1),x1(2),x2(1),x2(2),xn(1),xn(2)
#	}
return
#250  format(" approx soln.")
#260  format(" exact soln.")
#270  format(" 1st dist ="2g13 .5," 2nd dist ="2g13 .5)
#280  format(" plane points ="6g13 .5)
end



subroutine maxtag(start,deg,pntr,auux,stack,n,count)
integer start,n,node,stkptr,parent,nxt,istart
real count(1),deg(1),maxcnt
SHORT pntr(1),auux(1),stack(2,1)
do i = 1,n
	count(i) = 0.0
node = start
parent = 0
istart = 1
stkptr = 0
repeat {
	jdeg = abs(deg(node))
	i = istart
	repeat {
		if (i>jdeg)
			go to 290
		nxt = auux(pntr(node)+i)
		if (nxt!=parent)
			break 1
		i = i+1
		}
	stkptr = stkptr+1
	stack(1,stkptr) = node
	stack(2,stkptr) = i+1
	parent = node
	node = nxt
	istart = 1
	Next 1
	290  maxcnt = 0.0
	i = 1
	while (i<=jdeg) {
		nxt = auux(pntr(node)+i)
		if (nxt!=parent)
			maxcnt = amax1(maxcnt,count(nxt))
		i = i+1
		}
	count(node) = maxcnt+1.0
	if (stkptr==0)
		break 1
	node = stack(1,stkptr)
	parent = 0
	if (stkptr>1)
		parent = stack(1,stkptr-1)
	istart = stack(2,stkptr)
	stkptr = stkptr-1
	}
return
end



integer function diaend(start,deg,pntr,auux,count,maxdph)
integer start,node,parent,nxt,nxts,depth,maxdph
real count(1),deg(1),maxcnt
SHORT pntr(1),auux(1)
node = start
parent = 0
depth = 0
repeat {
	maxcnt = 0.0
	depth = depth+1
	jdeg = abs(deg(node))
	i = 1
	while (i<=jdeg) {
		nxt = auux(pntr(node)+i)
		if (nxt!=parent)
			if (count(nxt)>maxcnt) {
				maxcnt = count(nxt)
				nxts = nxt
				}
		i = i+1
		}
	if (maxcnt==0.0||depth>=maxdph)
		break 1
	parent = node
	node = nxts
	}
diaend = node
return
end



subroutine restor(istor,start,deg,pntr,auux,stack)
integer start,node,stkptr,parent,nxt,istart
real deg(1)
SHORT istor(1),pntr(1),auux(1),stack(2,1)
node = start
parent = 0
istart = 1
stkptr = 0
repeat {
	jdeg = abs(deg(node))
	i = istart
	repeat {
		if (i>jdeg)
			go to 300
		nxt = auux(pntr(node)+i)
		if (nxt!=parent)
			break 1
		i = i+1
		}
	stkptr = stkptr+1
	stack(1,stkptr) = node
	stack(2,stkptr) = i+1
	parent = node
	node = nxt
	istart = 1
	Next 1
	300  istor(node) = parent
	if (stkptr==0)
		break 1
	node = stack(1,stkptr)
	parent = 0
	if (stkptr>1)
		parent = stack(1,stkptr-1)
	istart = stack(2,stkptr)
	stkptr = stkptr-1
	}
return
end



subroutine mssort(v,a,ii,jj)
#
#     puts into a the permutation vector which sorts v into
#     increasing order.  only elements from ii to jj are considered.
#     arrays iu(k) and il(k) permit sorting up to 2**(k+1)-1 elements
#
#     this is a modification of cacm algorithm #347 by r. c. singleton,
#     which is a modified hoare quicksort.
#
dimension a(jj),v(1),iu(20),il(20)
integer t,tt
SHORT a
real v
m = 1
i = ii
j = jj
repeat {
	if (i<j)
		go to 310
	repeat {
		m = m-1
		if (m==0)
			break 2
		i = il(m)
		j = iu(m)
		while (j-i>=11) {
			310  k = i
			ij = (j+i)/2
			t = a(ij)
			vt = v(ij)
			if (v(i)>vt) {
				a(ij) = a(i)
				a(i) = t
				t = a(ij)
				v(ij) = v(i)
				v(i) = vt
				vt = v(ij)
				}
			l = j
			if (v(j)<vt) {
				a(ij) = a(j)
				a(j) = t
				t = a(ij)
				v(ij) = v(j)
				v(j) = vt
				vt = v(ij)
				if (v(i)>vt) {
					a(ij) = a(i)
					a(i) = t
					t = a(ij)
					v(ij) = v(i)
					v(i) = vt
					vt = v(ij)
					}
				}
			repeat {
				l = l-1
				if (v(l)<=vt) {
					tt = a(l)
					vtt = v(l)
					repeat
						k = k+1
						until(v(k)>=vt)
					if (k>l)
						break 1
					a(l) = a(k)
					a(k) = tt
					v(l) = v(k)
					v(k) = vtt
					}
				}
			if (l-i<=j-k) {
				il(m) = k
				iu(m) = j
				j = l
				m = m+1
				}
			else {
				il(m) = i
				iu(m) = l
				i = k
				m = m+1
				}
			}
		if (i==ii)
			break 1
		i = i-1
		repeat {
			i = i+1
			if (i==j)
				break 1
			t = a(i+1)
			vt = v(i+1)
			if (v(i)>vt) {
				k = i
				repeat {
					a(k+1) = a(k)
					v(k+1) = v(k)
					k = k-1
					}
					until(vt>=v(k))
				a(k+1) = t
				v(k+1) = vt
				}
			}
		}
	}
return
end



