#setpar		set permanent GR-Z parameters
subroutine setpar(instr)
POINTER instr
INCLUDE(stack,struct,print,graphics)

POINTER p,pp,d
logical streq

define(`NTAB',18)
CHARACTER(pars,6,NTAB); integer lenmod(NTAB)
CHARACTER(jgetch,1); CHARACTER(ch,1)
logical doinit
SAVE(pars,doinit)
data doinit/TRUE/
# lenmod is minimum length and desired mode
# coded len*10+mode   
data lenmod/ 15, 43, 43, 43, 43, 43, 22, 22, 15, 
   	     15, 43, 43, 42, 13, 43, 23, 23, 12/
if(doinit){
	doinit = FALSE
	pars(1) = TSTRING(pty)
	pars(2) = TSTRING(mar)
	pars(3) = TSTRING(omd)
	pars(4) = TSTRING(omi)
	pars(5) = TSTRING(oma)
	pars(6) = TSTRING(mai)
	pars(7) = TSTRING(mfrow)
	pars(8) = TSTRING(mfcol)
	pars(9) = TSTRING(csm)
	pars(10) = TSTRING(fty)
	pars(11) = TSTRING(fig)
	pars(12) = TSTRING(plt)
	pars(13) = TSTRING(mfg)
	pars(14) = TSTRING(mex)
	pars(15) = TSTRING(usr)
	pars(16) = TSTRING(pin)
	pars(17) = TSTRING(fin)
	pars(18) = TSTRING(new)
	}

ALLENTRY(instr,p){
	if(NAME(p)==NULL | NAME(p)==USED) next
	for(i=1;i<=NTAB;  i=i+1)
		if(streq(pars(i),TEXT(NAME(p))))break
	if(i>NTAB)next # not found
	NAME(p)=USED
	mode=mod(lenmod(i),10)
	call coeves(p,pp,mode,FALSE)	# NAs not allowed
	d=VALUE(pp)
	if(LENGTH(pp)<lenmod(i)/10){
		EPRINT("Parameter ",C(pars(i))," not set: too few data values")
		next
		}
	if(i==7 | i==8)
		if(max0(is(d) ,is(d+1))>2) SPECIFY( cex(.5), mex(.5) )
	switch(i){
		case 1:  SPECIFY( pty(jgetch(TEXT(is(d)),1)) )
		case 2:  SPECIFY( mar(rs(d),rs(d+1),rs(d+2),rs(d+3)) )
		case 3:  SPECIFY( omd(rs(d),rs(d+1),rs(d+2),rs(d+3)) )
		case 4:  SPECIFY( omi(rs(d),rs(d+1),rs(d+2),rs(d+3)) )
		case 5:  SPECIFY( oma(rs(d),rs(d+1),rs(d+2),rs(d+3)) )
		case 6:  SPECIFY( mai(rs(d),rs(d+1),rs(d+2),rs(d+3)) )
		case 7:  call mfrowz(is(d),is(d+1))
		case 8:  call mfcolz(is(d),is(d+1))
		case 9:  SPECIFY( csm(jgetch(TEXT(is(d)),1)) )
		case 10: ch = jgetch(TEXT(is(d)),1)
			SPECIFY( fty(ch) )
		case 11: call drfigz(rs(d),rs(d+1),rs(d+2),rs(d+3))
		case 12: call drpltz( rs(d),rs(d+1),rs(d+2),rs(d+3))
		case 13: SPECIFY( mfg(is(d),is(d+1),is(d+2),is(d+3)) )
		case 14: SPECIFY( mex(rs(d)) )
		case 15: SPECIFY( usr(rs(d),rs(d+1),rs(d+2),rs(d+3)) )
		case 16: call inpltz( rs(d), rs(d+1) )
		case 17: call infigz( rs(d), rs(d+1) )
		case 18: SPECIFY( new(is(d)!=0) )
		}
	if(i==7 | i==8)
		if(max0(is(d),is(d+1))<=2) SPECIFY( cex(1), mex(1) )
	}
return
end
