FUNCTION quantile(
	x	/REAL/
	probs	/REAL,5/
	)

STATIC( real deflt(5) )
INITIAL( deflt/0., .25, .5, .75, 1./ )

if(MISSING(probs)) call rcopy(deflt,probs,LENGTH(probs))

for(i=1; i<=LENGTH(probs); i=i+1)
	if(probs[i]>1. | probs[i]<0.)
		FATAL(Probabilities must be between 0 and 1 inclusive)

STRUCTURE(
	quantiles	/REAL,LENGTH(probs)/
	scr		/INT,LENGTH(probs)*2/
	)

call qtile(x,LENGTH(x),quantiles,probs,LENGTH(probs),scr)

RETURN(quantiles)
END
