#dstclp		compute probabilities for probfun
subroutine dstclp(x,n,par1,npar1,par2,npar2,whichf,naflag)
real x(1); integer n,whichf,npar1,npar2; logical naflag; POINTER par1,par2
# x: vector of quantiles, probabilities to be overwritten into it
# n: length of x
# par1,par2: value pointers for parameters of dist., checked by dstpar
# npar1,npar2: length of parameter vectors
# whichf: code for distribution
# naflag: flag set to TRUE iff NA's were generated from range checks

INCLUDE(struct, dist)
external pnorm,plogi,plnor,pfdis,ptdis,pbeta,pgamm,pcauc,pchis

PAR1=par1; PAR2=par2; NPAR1=npar1; NPAR2=npar2; NVALUES=n; WHICH=whichf #move values to common
switch(whichf) {
case NORM_DIST: call dstcp1(x,pnorm)
case LOGIS_DIST: call dstcp1(x,plogi)
case LNORM_DIST: call dstcp1(x,plnor)
case F_DIST: call dstcp1(x,pfdis)
case T_DIST: call dstcp1(x,ptdis)
case BETA_DIST: call dstcp1(x,pbeta)
case CAUCHY_DIST: call dstcp1(x,pcauc)
case GAMMA_DIST: call dstcp1(x,pgamm)
case CHISQ_DIST: call dstcp1(x,pchis)
case UNIF_DIST: call dstcp1(x,pnorm) #dummy
default: FATAL(invalid probability distribution)
	}
naflag=NAFLAG
return
end

#dstcp1		inner layer of dstclp, using common block, supplied function
subroutine dstcp1(x,prfun)
real x(1),prfun
external prfun

INCLUDE(stack, struct, dist)
define(`NA_ACTION',`{NASET(x(i)); NAFLAG=TRUE; next}')
integer i
NAFLAG=FALSE; i1=0; i2=0
for(i=1; i<=NVALUES; i=i+1) {
	if(NA(x(i),REAL))next
	switch(WHICH/10) { # switch on type of distribution
	case NORMAL_TYPE: x(i)=prfun(x(i),rs(PAR1+i1),rs(PAR2+i2)) # no range check, 2 pars
	case F_TYPE: switch( WHICH ) { # range check, 1 par.
		case F_DIST: if(x(i)<0.)NA_ACTION
		case BETA_DIST: if(x(i)<0. | x(i)>1.)NA_ACTION
			}
		x(i)=prfun(x(i),rs(PAR1+i1),rs(PAR2+i2))
	case CHISQ_TYPE: if(x(i)<0.)NA_ACTION
		x(i)=prfun(x(i),rs(PAR1+i1)) # >=0, 1 parameter
	case T_TYPE: x(i)=prfun(x(i),rs(PAR1+i1)) #no check, 1 par.
	case UNIF_TYPE: if(x(i)<rs(PAR1+i1) | x(i)>rs(PAR2+i2))NA_ACTION
		x(i)=(x(i)-rs(PAR1+i1))/(rs(PAR2+i2)-rs(PAR1+i1))
		}
	i1=i1+1; if(i1==NPAR1)i1=0; i2=i2+1; if(i2==NPAR2)i2=0
	}
return
end
