#crwls    crwls - weighted least squares regression
subroutine crwls(x,y,n,ndim,k,wt,calp,cres)
#
real x(ndim,1),y(1),wt(1),calp(1),cres(1)
#  dimension of cres nis max(k*(k+2),n).  for calendar k=7
#
#  sabl error flag
common/errcm/ierr
#
#
#  set parameter
data zero/0./
#
kk = k*k
kkk = kk+k+1
call brput(zero,cres,kk+2*k)
#
#  update regression one observation at a time
do i = 1,n {
	sqw = sqrt(wt(i))
	do j = 1,k {
		kkj = kk+j
		cres(kkj) = x(i,j)*sqw
		}
	yi = y(i)*sqw
	call regad(cres,(k),(k),cres(kkk),cres(kk+1),yi)
	}
#
#  calculate regression coefficients
call backu(cres,(k),(k),cres(kkk),calp)
if (ierr==2)
#
#  error
	continue
else
#
#  calculate residuals
	do i = 1,n {
		cres(i) = y(i)
		do j = 1,k
			cres(i) = cres(i)-calp(j)*x(i,j)
		}
return
end



