#drwt     drwt - get robustness weights. ares must be non-negative
subroutine drwt(ares,n,nbi,bis,rw)
#
real ares(1),bis(1),rw(1)
#
#  sabl error flag
common/errcm/ierr
#
#  dynamic core storage
INCLUDE(stack)
#
#  ensure odd- length smoothers
nb = 2*((nbi-1)/2)+1
#
#  get work space
ib1 = jstkgt(n,3)
#
#  smooth the series
call dwmm(ares,n,nb,bis,0,rw)
if (ierr==2) goto 60
call dwls(rw,n,nb,bis,1,n,0,rw,rw,0,rs(ib1))
if (ierr==2) goto 60
#
#  weight according to deviation from smooth
ib = ib1-1
do i = 1,n {
	ib = ib+1
	rw(i) = 0.0
	edge = 6.0*rs(ib)
	if (edge>ares(i)) {
		a = ares(i)/edge
		rw(i) = (1.0-a**2)**2
		}
	}
#
#  release work space
60  call jstkrl(1)
return
end
