#dwls     dwls - weighted moving mean or lsq regression y(loc1)-y(loc2)
subroutine dwls(y,nn,nbi,bis,loc1,loc2,iwt,wt,vt,ideg,ys)
#
#  iwt = 1 for weighted moving robust regression
#  lbw = total length biswt to cover nb data (1 to nbmx)
#  i1  = 1st (left) weight to use at left end (1 to nb)
#  nf  = 1st robustness weight, data, to use at right end = nn-nbm
#  ys(1),... =smoothed y(loc1) to y(loc2)
#
real y(1),bis(1),wt(1),vt(1),ys(1)
logical lwt
#
#  sabl error flag
common/errcm/ierr
#
#  dynamic core storage
INCLUDE(stack)
#
data one/1.0/
#
if (loc1>loc2) return
#
#  ensure odd- length smoothers
nh = (nbi-1)/2
nbm = 2*nh
nb = nbm+1
nhp1 = nh+1
nbmx = 2*nbm+1
#
limu = nn-nh
lwt = iwt!=0
igo = loc1-1
fnn = nn
zz = zrol(all)
zzt = zz*float(nb)
#
#  get work space = 5*nb-2 + (maybe) nn
ib1 = jstkgt(nbmx*2,3)
ib3 = ib1+nbmx
ib1m = ib1-1
ib4 = jstkgt(nb,2)
if (ideg!=0) {
	ib2 = jstkgt(nn,3)
	ib2m = ib2-1
#
#  get dummy x variable for weighted regression
	call rvec(one,fnn,one,rs(ib2))
	}
#
#  is smooth window longer than data?
if (nb>nn) {
#
#  non-existent center (nb>=nn).  do entire series in this loop
	lk = igo
	m2 = loc2-lk
	nhaf = nn/2
#
	do lok = 1,m2 {
		lk = lk+1
		lbw = nbmx
		if (lk>nhaf) {
			if (lk<nn) lbw = lbw-2*(nn-lk)
			lb2 = lbw/2+1
			i1 = lb2-lk+1
			if (lk>nn) i1 = lb2-nn+1
			}
		else {
			if (lk>1) lbw = lbw-2*(lk-1)
			lb2 = lbw/2+1
			i1 = lb2-lk+1
			if (lk<1) i1 = lb2
			}
#
		call biswt(lbw,rs(ib1))
		ibp = ib1m+i1
		call rmovf(rs(ibp),nn,rs(ib1))
		if (lwt) {
			a = (sumx(vt,nn))*(sxy(rs(ib1),wt,nn))
			if (a>zz*fnn*fnn)
				call mult(rs(ib1),wt,nn,rs(ib1))
			else {
				call rmovf(y,nn,rs(ib3))
				call bsorti(rs(ib3),nn,is(ib4))
				half = sumx(rs(ib1),nn)/2.0
				ys(lok) = athaf(y,rs(ib1),is(ib4),half,nn)
				next 1
				}
			}
		a = sumx(rs(ib1),nn)
		call rdiv(a,rs(ib1),nn,rs(ib1))
		if (ideg!=0) call linew(rs(ib2),rs(ib1),nn,lk,rs(ib1))
		ys(lok) = sxy(rs(ib1),y,nn)
		}
	}
else {
#
#  get center and ends
	if (loc2>nh&&loc1<=limu) {
		m1 = max0(loc1,nhp1)
		m2 = min0(loc2,limu)
		all = sumx(bis,nb)
		if (!lwt) {
#
#  unweighted center
			call rdiv(all,bis,nb,rs(ib1))
			do lk = m1,m2 {
				i1 = lk-igo
				nf = lk-nh
				ys(i1) = sxy(rs(ib1),y(nf),nb)
				}
			}
		else
#
#  robustness weighted center
			do lok = m1,m2 {
				lk = lok
				nf = lk-nh
				i1 = lk-igo
				call mult(bis,wt(nf),nb,rs(ib1))
				a = sumx(rs(ib1),nb)
				if (a<=zzt||sumx(vt(nf),nb)<=zzt) {
					call rmovf(y(nf),nb,rs(ib1))
					call bsorti(rs(ib1),nb,is(ib4))
					half = all/2.0
					ys(i1) = athaf(y(nf),bis,is(ib4),half,nb)
					}
				else {
					call rdiv(a,rs(ib1),nb,rs(ib1))
					if (ideg!=0) {
						isx = ib2m+nf
						call linew(rs(isx),rs(ib1),nb,lk,rs(ib1))
						}
					ys(i1) = sxy(rs(ib1),y(nf),nb)
					}
				}
		}
#
#  ends
	m1 = nhp1-loc1
	m2 = loc2-limu
	mlen = max0(m1,m2)
	if (mlen>0) {
		mgo = 1
		if (m1<0) mgo = max0(1,loc1-limu)
		if (m2<0) mgo = max0(1,nhp1-loc2)
		i1 = 2*(mgo-1)
		lbw = min0(nb+i1,nbmx-2)
		i1 = min0(i1,nbm-2)
		i1 = ib3+i1
		nf = nn-nbm
		isx = ib2m+nf
#
#  get upper, then lower end, from center to end
		do mend = mgo,mlen {
			if (lbw<nbmx) {
				lbw = lbw+2
				i1 = i1+2
				call biswt(lbw,rs(ib1))
				}
			call rmovf(rs(ib1),lbw,rs(ib3))
#
#  upper
			lku = limu+mend
			if (lku<=loc2) {
				m2 = lku-igo
				if (!lwt)
					a = sumx(rs(ib1),nb)
				else {
					call mult(rs(ib1),wt(nf),nb,rs(ib1))
					a = sumx(rs(ib1),nb)
					if (a<=zzt||sumx(vt(nf),nb)<=zzt) {
						call rmovf(y(nf),nb,rs(ib1))
						call bsorti(rs(ib1),nb,is(ib4))
						half = sumx(rs(ib3),nb)/2.0
						ys(m2) = athaf(y(nf),rs(ib3),is(ib4),half,nb)
						goto 10
						}
					}
				call rdiv(a,rs(ib1),nb,rs(ib1))
				if (ideg!=0) call linew(rs(isx),rs(ib1),nb,lku,rs(ib1))
				ys(m2) = sxy(rs(ib1),y(nf),nb)
#
				10  call rmovf(rs(ib3),lbw,rs(ib1))
				}
#
#  lower
			lkl = nhp1-mend
			if (lkl>=loc1) {
				m2 = lkl-igo
				if (!lwt)
					 a = sumx(rs(i1),nb)
				else {
					call mult(rs(i1),wt,nb,rs(i1))
					a = sumx(rs(i1),nb)
					if (a<=zzt||sumx(vt,nb)<=zzt) {
						call rmovf(y,nb,rs(ib3))
						call bsorti(rs(ib3),nb,is(ib4))
						lk = i1-ib3+ib1
						half = sumx(rs(lk),nb)/2.0
						ys(m2) = athaf(y,rs(lk),is(ib4),half,nb)
						next 1
						}
					}
				call rdiv(a,rs(i1),nb,rs(ib3))
				if (ideg!=0) call linew(rs(ib2),rs(ib3),nb,lkl,rs(ib3))
				ys(m2) = sxy(rs(ib3),y,nb)
				}
			}
		}
	}
#
#  release work space
if (ideg!=0) call jstkrl(1)
call jstkrl(2)
return
end
