FUNCTION subset( xx/ARRAY,NAOK,ANY/, &)
STATIC( integer ntotal,nsubs,j,i,j0,nxtsub; logical table; POINTER vx,vy )
ALLARG(p)
	if(NAME(p)!=NULL)FATAL(name= not allowed; use == to test equality)
NEXTARG
nsubs=LENGTH(instr)-1
STRUCTURE(ptrs/INT,3*nsubs/, Dim/INT,FROM(xx)/, Label/FROM(xx),OPTIONAL/)
# compute the delta vector
if(nsubs==1) { Dim[1]=LENGTH(xx); ptrs[2]=1; LENGTH(Dim)=1}
else if(nsubs==LENGTH(Dim)) {
	nj=1; j0=VALUE(ptrs)+nsubs-1
	for(j=1; j<=nsubs; j=j+1) {
		is(j0+j)=nj; nj=nj*Dim[j]
		}
	}
else {
	if(LENGTH(Dim)>1)ABORT("Number of subscripts must be 1 or",I(LENGTH(Dim))," for this array")
	else ABORT("Only one subscript allowed for vectors")
	}

call sublst(instr,2,nsubs,ptrs,Dim)
table = FALSE
if (!MISSING(Label)) {	# category or table
	if (MODE(Label)==STR) {	# table
		if (LENGTH(VALUE(Label)) > 1 && LENGTH(Dim) == 1)
			table = FALSE	# single subscript gives vector
		else if (LENGTH(VALUE(Label)) != LENGTH(Dim))
			FATAL(Label component does not match Dim)
		else { call labmod(ptrs,Dim,VALUE(Label)); table = TRUE }
		}
	else if(MODE(Label)!=CHAR) FATAL(Unrecognized type of Label component)
	}
# allocate result data
ntotal=1; for(j=1;j<=nsubs; j=j+1) ntotal=ntotal*Dim[j]
if(ntotal==0) { MODE(P(xx))=NULL; LENGTH(P(xx))=0; RETURN(xx) }	# logical subscript all false
STRUCTURE(y/MODECALC(MODE(xx)),ntotal/)
j0= -1; i=0; ictr=2*nsubs+1; vx=VALUE(xx); vy=VALUE(y)
repeat{
	j0=nxtsub(ptrs,Dim,ptrs[nsubs+1],nsubs,j0,ptrs[ictr])
	if(j0<0)break
	call pcopy(vx+j0,vy,1,MODE(xx))
	vy=vy+1
	}
# remove dead dimensions, reduce to vector if possible
nsubs=LENGTH(Dim); j0=0
for(j=1; j<=nsubs; j=j+1) if(Dim[j]>1){ j0=j0+1; Dim[j0]=Dim[j]}
if(!MISSING(Label) & !table) RETURN(Label,&)	# retain category Label
if(table & j0==0 | !table & j0<2) RETURN(Data=y)	# make vector
else {	# preserve Dim, Data, Label (if table)
	LENGTH(Dim)=j0
	VALUE(xx)=VALUE(y); LENGTH(xx)=LENGTH(y)
	RETURN(xx)
	}
END
