ROUTINE(timaxz,		specify time axis)
subroutine timaxz(iside,istyle,u1,u2,period,isw)
INCLUDE(graphics)
logical plot,yaxis,set,specif
CHARACTER(istyle,1); CHARACTER(it,1); CHARACTER(is,1); CHARACTER(isnew,1)
plot = mod(isw,2)==1
set = isw/2==1
yaxis = mod(iside,2)==0
QUERY( lab(nl,ny), axp(iside,it,is,y1,y2,par) )
if (yaxis) nl = ny
if (it!="n") it = "t"
ua = u1
ub = u2
if (u1==u2) {
	ua = u1-1./period
	ub = ub+1./period
	}
call zstylz(is,istyle,isnew,igo)
is = isnew
specif = TRUE
switch(igo) {
	case 1: # standard axis
		call ztintz(ua,ub,nl,period)
		ul = amin1(ua,u1)
		ur = amax1(ub,u2)
	case 2,7: # internal, rational axis
		if(igo==7) du = (u2-u1)*0.04; else du=0
		ua = ua-du
		ub = ub+du
		call ztintz(ub,ua,nl,period)
		ul = amin1(ua,u1-du)
		ur = amax1(ub,u2+du)
	case 3: # extended - allow half char extra space
		QUERY( cin(cx,cy), pin(px,py) )
		if (!yaxis) du = (u2-u1)*0.5*cx/px
		else du = (u2-u1)*0.5*cy/py
		ul = ua
		ur = ub
		call ztintz(ua,ub,nl,period)
		ul = amin1(ua,ul-du)
		ur = amax1(ub,ur+du)
	case 4: # direct
		nl = (u2-u1)*period+.99
		ul = u1
		ur = u2
	case 5: # type not found - treat as temporary direct
		SPECIFY( axs(iside,is) )
		specif = FALSE; set = FALSE
	case 6:
		specif = FALSE; set = FALSE
	}
if(specif) SPECIFY( axp(iside,it,is,ua,ub,float(nl)) )
if (set) {
	SPECIFY( tsp(u1,u2,period) )
	if (!yaxis) SPECIFY( usr(ul,ur) )
	else SPECIFY( usr(,,ul,ur) )
	}
if (plot&&it!="n") call taxisz(iside,TRUE,TRUE)
return
end
