ROUTINE(chol,		choleski decomposition)
subroutine chol(t,p,l,singlr)
integer p
real t(p,p),l(p,p)
logical singlr

double precision pivot,dpsum,ddotr
singlr=FALSE
do i = 1,p {
	pivot = t(i,i)
	for( j=1; j<i; j=j+1) {
		if (l(j,j)>0.) dpsum = -ddotr(-t(i,j),l(i,1),p,j-1,l(j,1),p)/l(j,j)
		else dpsum = 0.d0
		l(i,j) = dpsum
		pivot = pivot-dpsum**2
		}
	l(i,i) = pivot
	if (l(i,i)>0.) l(i,i) = sqrt(l(i,i))
	else {	#      set row i to 0
		do j = 1,i
			l(i,j) = 0.
		if(!singlr)WARNING(singularity in choleski decomposition)
		singlr=TRUE
		}
	}
return
end
