ROUTINE(condu,		approximate cond. estimate for upper-triangular matrix)
subroutine condu(r,p,z,b,rank)
integer p,rank,i,j; real r(p,p),z(1),b(1)
# r: upper triangular matrix, p by p
# z: scratch space, returned as cond. est. for each dimension(see QRCE)
# b: diagonal factors, to adjust r before condition calculations (e.g, norms ofcols of data matrix

INCLUDE(print)
real eps1,eps2

eps2=sqrt(PRECISION)
eps1=eps2*sqrt(eps2) # rules of thumb .5, .75 pwrs of precision

for(i=1; i<=p; i=i+1) # adjust r for preconditioning
	for(j=i; j<=p; j=j+1)
		if(b(j)>0.)r(i,j)=r(i,j)/b(j)
i=0
for(rank=p; rank>=1; rank=rank-1) {
	i=i+1
	call qrce(rank,r,p,z(i),z(p+1))
	z(i)=1./z(i)
	if(z(i)>eps1)break
	}
if(rank<p) EPRINT("Matrix not of full rank: rank probably <=",I(rank))
else if(abs(z(1))<eps2)EPRINT("Possibly singular data -- condition > 1/",R(z(1)))
for(i=1; i<=p; i=i+1) # undo the preconditioning
	for(j=i; j<=p; j=j+1)
		if(b(j)>0.)r(i,j)=r(i,j)*b(j)
return
end
