ROUTINE(gslsiw,weighted Gram-Schmidt least-squares optional intercept)
subroutine gslsiw(x,n,k,y,ny,w,q,r,corth,coef,nc,resid,int,work)
integer n,k,ny,nc
real x(n,k),y(n,ny),q(n,nc),r(2),w(n),corth(nc,ny),coef(nc,ny),resid(n,ny),work(2)
logical int

INCLUDE(stack)
INCLUDE(gs) #parameters for gs iteration
integer j,jj,i,ii,rank
real wnorm,snrm2,dot
logical savexy
POINTER jstkgt,xsave,ysave,const,other,ocoef

omega=0.; theta=1.4; sigma=PRECISION
savexy=FALSE
for(i=1;i<=n;i=i+1)
	if(w(i)==0.0) savexy=TRUE
if(savexy){
	xsave=jstkgt(n*k,REAL); call rcopy(x,rs(xsave),n*k)
	ysave=jstkgt(n*ny,REAL); call rcopy(y,rs(ysave),n*ny)
	}
for(i=1;i<=n;i=i+1){
	for(j=1;j<=k;j=j+1) x(i,j)=x(i,j)*w(i)
	for(j=1;j<=ny;j=j+1) y(i,j)=y(i,j)*w(i)
	}
if(int) { # prepare intercept calculations
	const=jstkgt(ny,REAL)
	other=jstkgt(k*ny,REAL)
	ocoef=jstkgt(k*ny,REAL)
	wnorm=snrm2(n,w,1)
	for(i=1;i<=n;i=i+1) q(i,1)=w(i)/wnorm
	call devw(x,n,k,y,ny,work,rs(const),q)
	call rfill(0.,r,nc**2)
	call gsls(x,n,k,y,ny,q(1,2),r(1+nc),rs(other),rs(ocoef),resid,rank,work(k+1))
	for(j=nc; j>1; j=j-1){ # shift elements of r down
		jj=j-1; ii=(j-1)*k
		for(i=ii+j; i>ii; i=i-1){ r(i+jj)=r(i); r(i)=0. }
		}
	r(1)=wnorm
	for(i=1;i<nc;i=i+1) r(1+i*nc)=work(i)
	for(i=1;i<=ny;i=i+1){
		call rcopy(rs(other+(i-1)*k),corth(2,i),k)
		call rcopy(rs(ocoef+(i-1)*k),coef(2,i),k)
		corth(1,i)=rs(const+i-1)
		coef(1,i)=-dot(-corth(1,i),work,1,k,coef(2,i),1)/wnorm
		}
	call jstkrl(3)
	}
else {
	call rfill(0.,r,k**2)
	call gsls(x,n,k,y,ny,q,r,corth,coef,resid,rank,work)
	}
if(savexy) {
	call rcopy(rs(xsave),x,n*k)
	call rcopy(rs(ysave),y,n*ny)
	call jstkrl(2)
	}
for(i=1;i<=n;i=i+1)
	for(j=1;j<=ny;j=j+1)
		if(w(i)>0) resid(i,j)=resid(i,j)/w(i)
		else if(int) resid(i,j)=-dot(-y(i,j)+coef(1,j),x(i,1),n,k,coef(2,j),1)
		else resid(i,j)=-dot(-y(i,j),x(i,1),n,k,coef(1,j),1)
return
end
