ROUTINE(hcp,		 hierarchical clustering process - packed matrix)
subroutine hcp(d,n,dist,hcmerg,old,new,dx,w,mins)
external hcmerg
real d(1), w(1), dx(1), x, mins(1), newmin
integer old(1), new(1), j, l, np, inew, iold, lold
logical dist

if(!dist) call negate(d,(n*(n-1))/2)
call rfill(1.,w,n)

for(j=1; j<n; j=j+1)
	mins(j) = newmin(d,n,w,j)

#   form (n - 1) clusters. 
#   The d "matrix" is a packed vector of strictly lower triangle of the
#   real matrix

for(np=1; ; np=np+1) {	# n-1 merges

# find smallest distance

	x=BIG
	for(j=1; j<n; j=j+1)	# which column has smallest value
		if(mins(j)<x){ x = mins(j); iold = j }

	l = (iold-1)*n-(iold*(iold-1))/2+1   # start of iold'th column
	for(inew=iold+1; inew<=n; inew=inew+1){
		if(w(inew)>0.)
			if(d(l)<=x) break
		l = l+1
		}

# now merge objects iold and inew at distance x

	dx(np) = x
	new(np) = inew
	old(np) = iold

# flag the columns that may need updating after merge
	l = -1
	lold=((iold-1)*(2*n-iold-2))/2
	for(j=1; j<inew; j=j+1){
		if(j>iold){
			if(d(l+inew)==mins(j)) mins(j)=BIG
			if(d(lold+j-1)<mins(j)) mins(j)=BIG
			}
		if(j<iold){
			if(d(l+inew)==mins(j)) mins(j)=BIG
			if(d(l+iold)==mins(j)) mins(j)=BIG
			}
		l = l+n-j-1
		}

	call hcmerg(d,n,iold,inew,w)	# do the merge operation
	if(np>=n-1) break	# dont try to update after last merge
	w(iold) = 0.
	mins(iold) = BIG

# update the mins vector

	for(j=1; j<inew; j=j+1)
		if(w(j)>0. && mins(j)==BIG) mins(j)=newmin(d,n,w,j)
	if(inew<n) mins(inew) = newmin(d,n,w,inew)
	}
if(!dist) call negate(dx,n-1)
return
end

real function newmin(d,n,w,i)	# find min of ith column
real d(1),w(1); integer n,i
real curmin
istart = (i-1)*n-(i*(i-1))/2+1   # start of ith column
curmin = BIG
for(j=i+1; j<=n; j=j+1){
	if(w(j)>0.) curmin = amin1( curmin, d(istart) )
	istart=istart+1
	}
return(curmin)
end
