ROUTINE(inits,find number of terms needed in orthogonal series)
integer function inits(os,nos,eta)
integer nos; real os(nos),eta

# april 1977 version.  w. fullerton, c3, los alamos scientific lab.
#
# initialize the orthogonal series so that inits is the number of terms
# needed to insure the error is no larger than eta.  ordinarily, eta
# will be chosen to be one-tenth machine precision.
#
#             input arguments --
# os     array of nos coefficients in an orthogonal series.
# nos    number of coefficients in os.
# eta    requested accuracy of series.
#
integer i,ii
real err
if (nos<1) ERROR(number of coefficients less than one)
err = 0.
do ii = 1,nos {
	i = nos+1-ii
	err = err+abs(os(i))
	if (err>eta)
		break 1
	}
if (i==nos) ERROR(eta may be too small)
return(i)
end
